/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax.event;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.event.TreeEvent;
import org.netbeans.tax.event.Util;

public final class TreeEventChangeSupport {
    private PropertyChangeSupport propertyChangeSupport;
    private TreeObject eventSource;
    private EventCache eventCache;

    public TreeEventChangeSupport(TreeObject eventSource) {
        this.eventSource = eventSource;
        this.eventCache = new EventCache();
    }

    public final TreeEvent createEvent(String propertyName, Object oldValue, Object newValue) {
        return new TreeEvent(this.eventSource, propertyName, oldValue, newValue);
    }

    protected final TreeObject getEventSource() {
        return this.eventSource;
    }

    private final PropertyChangeSupport getPropertyChangeSupport() {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this.eventSource);
        }
        return this.propertyChangeSupport;
    }

    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(listener);
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeEventChangeSupport::addPropertyChangeListener: listener = " + listener);
            Util.THIS.debug("    propertyChangeSupport = " + this.listListeners());
            if (listener == null) {
                Util.THIS.debug("    eventSource = " + this.eventSource);
            }
        }
    }

    public final void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(propertyName, listener);
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeEventChangeSupport::addPropertyChangeListener: propertyName = " + propertyName);
            Util.THIS.debug("    listener = " + listener);
            Util.THIS.debug("    propertyChangeSupport = " + this.listListeners());
            if (listener == null) {
                Util.THIS.debug("    eventSource = " + this.eventSource);
                Util.THIS.debug(new RuntimeException("TreeEventChangeSupport.addPropertyChangeListener"));
            }
        }
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(listener);
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeEventChangeSupport::removePropertyChangeListener: listener = " + listener);
            Util.THIS.debug("    propertyChangeSupport = " + this.listListeners());
        }
    }

    public final void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(propertyName, listener);
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeEventChangeSupport::removePropertyChangeListener: propertyName = " + propertyName);
            Util.THIS.debug("    listener = " + listener);
            Util.THIS.debug("-                       ::removePropertyChangeListener: propertyChangeSupport = " + this.listListeners());
        }
    }

    public final boolean hasPropertyChangeListeners(String propertyName) {
        return this.getPropertyChangeSupport().hasListeners(propertyName);
    }

    public final void firePropertyChange(TreeEvent evt) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeEventChangeSupport::firePropertyChange ( " + evt + " )");
            Util.THIS.debug("    eventSource  = " + this.eventSource);
            Util.THIS.debug("    EventManager = " + this.eventSource.getEventManager());
        }
        if (this.eventSource.getEventManager() == null) {
            return;
        }
        this.eventSource.getEventManager().firePropertyChange(this, evt);
    }

    protected final void firePropertyChangeNow(TreeEvent evt) {
        this.getPropertyChangeSupport().firePropertyChange(evt);
    }

    protected final void firePropertyChangeLater(TreeEvent evt) {
        this.eventCache.addEvent(evt);
    }

    protected final void firePropertyChangeCache() {
        this.eventCache.firePropertyChange();
    }

    protected final void clearPropertyChangeCache() {
        this.eventCache.clear();
    }

    private String listListeners(Object instance) {
        try {
            Class<?> klass = instance.getClass();
            Field field = klass.getDeclaredField("listeners");
            field.setAccessible(true);
            return field.get(instance).toString();
        }
        catch (Exception ex) {
            return "" + ex.getClass() + " " + ex.getMessage();
        }
    }

    private String listChildrenListeners(PropertyChangeSupport support) {
        try {
            PropertyChangeSupport instance = support;
            Class<?> klass = instance.getClass();
            Field field = klass.getDeclaredField("children");
            field.setAccessible(true);
            StringBuffer sb = new StringBuffer();
            Map map = (Map)field.get(instance);
            if (map == null) {
                return "";
            }
            Set keys = map.keySet();
            for (Object key : keys) {
                sb.append("\n[").append(key).append("] ").append(this.listListeners(map.get(key)));
            }
            return sb.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "<" + ex + ">";
        }
    }

    public final String listListeners() {
        StringBuffer sb = new StringBuffer();
        sb.append("[*general*] ").append(this.listListeners(this.getPropertyChangeSupport())).append("\n");
        sb.append(this.listChildrenListeners(this.getPropertyChangeSupport()));
        return sb.toString();
    }

    private class EventCache {
        List eventList = new LinkedList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            List list = this.eventList;
            synchronized (list) {
                this.eventList.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addEvent(TreeEvent event) {
            List list = this.eventList;
            synchronized (list) {
                this.eventList.add(event);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void firePropertyChange() {
            LinkedList listCopy;
            List list = this.eventList;
            synchronized (list) {
                listCopy = new LinkedList(this.eventList);
                this.eventList.clear();
            }
            Iterator it = listCopy.iterator();
            while (it.hasNext()) {
                TreeEventChangeSupport.this.firePropertyChangeNow((TreeEvent)it.next());
            }
        }
    }
}

