/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.clientproject;

import java.io.IOException;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.ant.UpdateImplementation;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class UpdateProjectImpl
implements UpdateImplementation {
    private static final boolean TRANSPARENT_UPDATE = Boolean.getBoolean("carproject.transparentUpdate");
    private static final String BUILD_NUMBER = System.getProperty("netbeans.buildnumber");
    private static final String MINIMUM_ANT_VERSION_ELEMENT = "minimum-ant-version";
    private final Project project;
    private final AntProjectHelper helper;
    private final AuxiliaryConfiguration cfg;
    private boolean alreadyAskedInWriteAccess;
    private boolean isCurrent;
    private Element cachedElement;

    UpdateProjectImpl(Project project, AntProjectHelper helper, AuxiliaryConfiguration cfg) {
        assert (project != null && helper != null && cfg != null);
        this.project = project;
        this.helper = helper;
        this.cfg = cfg;
    }

    public boolean isCurrent() {
        return true;
    }

    public boolean canUpdate() {
        if (TRANSPARENT_UPDATE) {
            return true;
        }
        if (this.alreadyAskedInWriteAccess) {
            return false;
        }
        boolean canUpdate = this.showUpdateDialog();
        if (!canUpdate) {
            this.alreadyAskedInWriteAccess = true;
            ProjectManager.mutex().postReadRequest(new Runnable(){

                @Override
                public void run() {
                    UpdateProjectImpl.this.alreadyAskedInWriteAccess = false;
                }
            });
        }
        return canUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUpdate(EditableProperties props) throws IOException {
        this.helper.putPrimaryConfigurationData(this.getUpdatedSharedConfigurationData(), true);
        this.cfg.removeConfigurationFragment("data", "http://www.netbeans.org/ns/j2se-project/1", true);
        this.cfg.removeConfigurationFragment("data", "http://www.netbeans.org/ns/j2se-project/2", true);
        ProjectManager.getDefault().saveProject(this.project);
        UpdateProjectImpl updateProjectImpl = this;
        synchronized (updateProjectImpl) {
            this.isCurrent = Boolean.TRUE;
        }
    }

    public Element getUpdatedSharedConfigurationData() {
        if (this.cachedElement == null) {
            Element oldRoot = this.cfg.getConfigurationFragment("data", "http://www.netbeans.org/ns/j2se-project/1", true);
            if (oldRoot != null) {
                Document doc = oldRoot.getOwnerDocument();
                Element newRoot = doc.createElementNS("http://www.netbeans.org/ns/car-project/1", "data");
                XMLUtil.copyDocument((Element)oldRoot, (Element)newRoot, (String)"http://www.netbeans.org/ns/car-project/1");
                Element sourceRoots = doc.createElementNS("http://www.netbeans.org/ns/car-project/1", "source-roots");
                Element root = doc.createElementNS("http://www.netbeans.org/ns/car-project/1", "root");
                root.setAttribute("id", "src.dir");
                sourceRoots.appendChild(root);
                newRoot.appendChild(sourceRoots);
                Element testRoots = doc.createElementNS("http://www.netbeans.org/ns/car-project/1", "test-roots");
                root = doc.createElementNS("http://www.netbeans.org/ns/car-project/1", "root");
                root.setAttribute("id", "test.src.dir");
                testRoots.appendChild(root);
                newRoot.appendChild(testRoots);
                this.cachedElement = UpdateProjectImpl.updateMinAntVersion(newRoot, doc);
            } else {
                oldRoot = this.cfg.getConfigurationFragment("data", "http://www.netbeans.org/ns/j2se-project/2", true);
                if (oldRoot != null) {
                    Document doc = oldRoot.getOwnerDocument();
                    Element newRoot = doc.createElementNS("http://www.netbeans.org/ns/car-project/1", "data");
                    XMLUtil.copyDocument((Element)oldRoot, (Element)newRoot, (String)"http://www.netbeans.org/ns/car-project/1");
                    this.cachedElement = UpdateProjectImpl.updateMinAntVersion(newRoot, doc);
                }
            }
        }
        return this.cachedElement;
    }

    public EditableProperties getUpdatedProjectProperties() {
        EditableProperties cachedProperties = this.helper.getProperties("nbproject/project.properties");
        if (cachedProperties.get((Object)"javadoc.additionalparam") == null) {
            cachedProperties.put("javadoc.additionalparam", "");
        }
        if (cachedProperties.get((Object)"build.generated.dir") == null) {
            cachedProperties.put("build.generated.dir", "${build.dir}/generated");
        }
        if (cachedProperties.get((Object)"meta.inf") == null) {
            cachedProperties.put("meta.inf", "${src.dir}/conf");
        }
        return cachedProperties;
    }

    private static Element updateMinAntVersion(Element root, Document doc) {
        Element me;
        NodeList list = root.getElementsByTagNameNS("http://www.netbeans.org/ns/car-project/1", MINIMUM_ANT_VERSION_ELEMENT);
        if (list.getLength() == 1 && (list = (me = (Element)list.item(0)).getChildNodes()).getLength() == 1) {
            me.replaceChild(doc.createTextNode("1.6.5"), list.item(0));
            return root;
        }
        assert (false) : "Invalid project file";
        return root;
    }

    private boolean showUpdateDialog() {
        JButton updateOption = new JButton(NbBundle.getMessage(UpdateProjectImpl.class, (String)"CTL_UpdateOption"));
        updateOption.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UpdateHelper.class, (String)"AD_UpdateOption"));
        return DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)NbBundle.getMessage(UpdateProjectImpl.class, (String)"TXT_ProjectUpdate", (Object)BUILD_NUMBER), NbBundle.getMessage(UpdateProjectImpl.class, (String)"TXT_ProjectUpdateTitle"), -1, 2, new Object[]{updateOption, NotifyDescriptor.CANCEL_OPTION}, (Object)updateOption)) == updateOption;
    }
}

