/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.refactoring;

import java.util.Collection;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParserResult;
import org.netbeans.modules.groovy.refactoring.RefactoringTask;
import org.netbeans.modules.groovy.refactoring.findusages.model.RefactoringElement;
import org.netbeans.modules.groovy.refactoring.move.MoveFileRefactoringUI;
import org.netbeans.modules.groovy.refactoring.rename.RenameRefactoringUI;
import org.netbeans.modules.groovy.refactoring.ui.WhereUsedQueryUI;
import org.netbeans.modules.groovy.refactoring.utils.GroovyProjectUtil;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public final class RefactoringTaskFactory {
    private RefactoringTaskFactory() {
    }

    public static RefactoringTask createRefactoringTask(Lookup lookup, RefactoringType type) {
        EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
        if (GroovyProjectUtil.isFromEditor(ec)) {
            return RefactoringTaskFactory.getTextComponentTask(lookup, type);
        }
        return RefactoringTaskFactory.getNodeToElementTask(lookup, type);
    }

    private static RefactoringTask getTextComponentTask(Lookup lookup, RefactoringType type) {
        EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
        FileObject fileObject = RefactoringTaskFactory.getFileObject(lookup);
        switch (type.ordinal()) {
            case 0: {
                return new FindUsagesTextComponentTask(ec, fileObject);
            }
            case 1: {
                return new RenameRefactoringTextComponentTask(ec, fileObject);
            }
            case 2: {
                return new MoveRefactoringTextComponentTask(ec, fileObject);
            }
        }
        return null;
    }

    private static RefactoringTask getNodeToElementTask(Lookup lookup, RefactoringType type) {
        FileObject fileObject = (FileObject)lookup.lookup(FileObject.class);
        Collection nodes = lookup.lookupAll(Node.class);
        switch (type.ordinal()) {
            case 0: {
                return new FindUsagesNodeToElementTask(nodes, fileObject);
            }
            case 1: {
                break;
            }
            case 2: {
                return new MoveNodeToElementTask(nodes, fileObject);
            }
            default: {
                return null;
            }
        }
        return null;
    }

    private static FileObject getFileObject(Lookup lookup) {
        Collection nodes = lookup.lookupAll(Node.class);
        Node node = nodes.size() == 1 ? (Node)nodes.iterator().next() : null;
        DataObject dataObject = node != null ? (DataObject)node.getLookup().lookup(DataObject.class) : null;
        return dataObject != null ? dataObject.getPrimaryFile() : null;
    }

    public static enum RefactoringType {
        FIND_USAGES,
        RENAME,
        MOVE;

    }

    private static class FindUsagesTextComponentTask
    extends RefactoringTask.TextComponentTask {
        public FindUsagesTextComponentTask(EditorCookie ec, FileObject fileObject) {
            super(ec, fileObject);
        }

        @Override
        protected RefactoringUI createRefactoringUI(RefactoringElement selectedElement, int startOffset, int endOffset, GroovyParserResult info) {
            if (selectedElement != null && selectedElement.getName() != null) {
                return new WhereUsedQueryUI(selectedElement);
            }
            return null;
        }
    }

    private static class RenameRefactoringTextComponentTask
    extends RefactoringTask.TextComponentTask {
        public RenameRefactoringTextComponentTask(EditorCookie ec, FileObject fileObject) {
            super(ec, fileObject);
        }

        @Override
        protected RefactoringUI createRefactoringUI(RefactoringElement selectedElement, int startOffset, int endOffset, GroovyParserResult info) {
            if (selectedElement != null && selectedElement.getName() != null) {
                return new RenameRefactoringUI(selectedElement);
            }
            return null;
        }
    }

    private static class MoveRefactoringTextComponentTask
    extends RefactoringTask.TextComponentTask {
        public MoveRefactoringTextComponentTask(EditorCookie ec, FileObject fileObject) {
            super(ec, fileObject);
        }

        @Override
        protected RefactoringUI createRefactoringUI(RefactoringElement selectedElement, int startOffset, int endOffset, GroovyParserResult info) {
            if (selectedElement != null && selectedElement.getFileObject() != null) {
                return new MoveFileRefactoringUI(selectedElement);
            }
            return null;
        }
    }

    private static class FindUsagesNodeToElementTask
    extends RefactoringTask.NodeToElementTask {
        public FindUsagesNodeToElementTask(Collection<? extends Node> nodes, FileObject fileObject) {
            super(fileObject);
        }

        @Override
        protected RefactoringUI createRefactoringUI(RefactoringElement selectedElement, GroovyParserResult info) {
            if (selectedElement != null && selectedElement.getName() != null) {
                return new WhereUsedQueryUI(selectedElement);
            }
            return null;
        }
    }

    private static class MoveNodeToElementTask
    extends RefactoringTask.NodeToElementTask {
        public MoveNodeToElementTask(Collection<? extends Node> nodes, FileObject fileObject) {
            super(fileObject);
        }

        @Override
        protected RefactoringUI createRefactoringUI(RefactoringElement selectedElement, GroovyParserResult info) {
            if (selectedElement != null && selectedElement.getFileObject() != null) {
                return new MoveFileRefactoringUI(selectedElement);
            }
            return null;
        }
    }
}

