/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.annotation;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.project.api.PhpAnnotations;
import org.netbeans.modules.php.spi.annotation.AnnotationLineParser;
import org.netbeans.modules.php.spi.annotation.AnnotationParsedLine;

public final class CustomTypeAnnnotationLineParser
implements AnnotationLineParser {
    private static final AnnotationLineParser INSTANCE = new CustomTypeAnnnotationLineParser();
    private volatile boolean treatUnknownAnnotationsAsTypeAnnotations = PhpAnnotations.getDefault().isUnknownAnnotationsAsTypeAnnotations();

    public static AnnotationLineParser getDefault() {
        return INSTANCE;
    }

    private CustomTypeAnnnotationLineParser() {
        PhpAnnotations.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("PROP_UNKNOWN_ANNOTATIONS_AS_TYPE_ANNOTATIONS".equals(evt.getPropertyName())) {
                    CustomTypeAnnnotationLineParser.this.treatUnknownAnnotationsAsTypeAnnotations = (Boolean)evt.getNewValue();
                }
            }
        });
    }

    public AnnotationParsedLine parse(String line) {
        AnnotationParsedLine result = null;
        if (this.treatUnknownAnnotationsAsTypeAnnotations) {
            result = this.parseLine(line, result);
        }
        return result;
    }

    private AnnotationParsedLine parseLine(String line, AnnotationParsedLine result) {
        String annotationPart;
        String[] tokens;
        String[] wsSeparatedLine = line.split("[\t ]", 2);
        if (wsSeparatedLine.length > 0 && (tokens = (annotationPart = wsSeparatedLine[0]).split("\\(", 2)).length > 0) {
            String annotation = tokens[0].trim();
            String description = line.substring(annotation.length()).trim();
            HashMap<OffsetRange, String> types = new HashMap<OffsetRange, String>();
            types.put(new OffsetRange(0, annotation.length()), annotation);
            result = new AnnotationParsedLine.ParsedLine(annotation, types, description, true);
        }
        return result;
    }
}

