/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.model.impl.ModelElementImpl;
import org.netbeans.modules.php.editor.model.impl.ScopeImpl;
import org.netbeans.modules.php.editor.model.impl.Type;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.openide.util.Union2;

class AssignmentImpl<Container extends ModelElementImpl>
extends ScopeImpl {
    private Container container;
    @NullAllowed
    private Union2<List<String>, Collection<? extends TypeScope>> typeNameScopes;
    private OffsetRange scopeRange;
    private boolean arrayAccess;
    private boolean conditionalBlock;
    private boolean catchClause;

    AssignmentImpl(Container container, Scope scope, OffsetRange scopeRange, OffsetRange nameRange, Assignment assignment, Map<String, AssignmentImpl> allAssignments, boolean isDeprecated) {
        this(container, scope, scopeRange, nameRange, VariousUtils.extractVariableTypeFromAssignment(assignment, allAssignments), isDeprecated);
        if (assignment.getLeftHandSide() instanceof ArrayAccess) {
            this.arrayAccess = true;
        }
    }

    AssignmentImpl(Container container, Scope scope, OffsetRange scopeRange, OffsetRange nameRange, @NullAllowed String typeName, boolean isDeprecated) {
        super(scope, ((ModelElementImpl)container).getName(), ((ModelElementImpl)container).getFile(), nameRange, ((ModelElementImpl)container).getPhpElementKind(), isDeprecated);
        this.container = container;
        ArrayList types = new ArrayList();
        if (typeName != null) {
            List typeNames = StringUtils.explode((String)typeName, (String)"|");
            typeNames.forEach(type -> {
                Object modifiedTypeName = type != null ? type.trim() : null;
                boolean isNullableType = CodeUtils.isNullableType((String)modifiedTypeName);
                if (isNullableType) {
                    modifiedTypeName = ((String)modifiedTypeName).substring(1);
                }
                if (modifiedTypeName != null && !VariousUtils.isSemiType(type)) {
                    QualifiedName qualifiedName = QualifiedName.create((String)modifiedTypeName);
                    QualifiedName fullyQualifiedName = VariousUtils.getFullyQualifiedName(qualifiedName, nameRange.getStart(), scope);
                    if (qualifiedName.getSegments().size() != fullyQualifiedName.getSegments().size()) {
                        modifiedTypeName = fullyQualifiedName.toString();
                    }
                }
                if (isNullableType) {
                    modifiedTypeName = "?" + (String)modifiedTypeName;
                }
                types.add(modifiedTypeName);
            });
        }
        this.typeNameScopes = Union2.createFirst(types);
        this.scopeRange = scopeRange;
    }

    boolean canBeProcessed(String tName) {
        return AssignmentImpl.canBeProcessed(tName, this.getName()) && AssignmentImpl.canBeProcessed(tName, this.getName().substring(1));
    }

    static boolean canBeProcessed(String tName, String name) {
        if (((String)tName).length() > 0 && ((String)tName).indexOf(name) == -1) {
            return true;
        }
        String varThis = "var-type:$this";
        int indexOfVarThis = ((String)tName).indexOf(varThis);
        if (indexOfVarThis != -1 && !name.equals(varThis)) {
            return ((String)(tName = ((String)tName).substring(0, indexOfVarThis) + ((String)tName).substring(indexOfVarThis + varThis.length()))).length() > 0 && ((String)tName).indexOf(name) == -1;
        }
        return false;
    }

    @CheckForNull
    private Collection<? extends TypeScope> typesFromUnion() {
        if (this.typeNameScopes != null && this.typeNameScopes.hasSecond() && this.typeNameScopes.second() != null) {
            return (Collection)this.typeNameScopes.second();
        }
        return null;
    }

    @CheckForNull
    String typeNameFromUnion() {
        List<String> typeNames = this.typeNamesFromUnion();
        return !typeNames.isEmpty() ? Type.asUnionType(typeNames) : null;
    }

    private List<String> typeNamesFromUnion() {
        if (this.typeNameScopes != null) {
            if (this.typeNameScopes.hasFirst() && !((List)this.typeNameScopes.first()).isEmpty()) {
                return (List)this.typeNameScopes.first();
            }
            if (this.typeNameScopes.hasSecond() && this.typeNameScopes.second() != null) {
                TypeScope type = (TypeScope)ModelUtils.getFirst((Collection)this.typeNameScopes.second());
                return type != null ? Collections.singletonList(type.getName()) : Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    String typeNameFromUnion(boolean withoutNullableTypePrefix) {
        if (withoutNullableTypePrefix) {
            return CodeUtils.removeNullableTypePrefix(this.typeNameFromUnion());
        }
        return this.typeNameFromUnion();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append(" == ").append(this.typeNameScopes);
        return sb.toString();
    }

    public Collection<? extends String> getTypeNames() {
        return this.typeNamesFromUnion();
    }

    public Collection<? extends TypeScope> getTypes() {
        List empty = Collections.emptyList();
        Collection<TypeScope> types = this.typesFromUnion();
        if (types != null) {
            return types;
        }
        String tName = this.typeNameFromUnion(true);
        if (tName != null && this.canBeProcessed(tName)) {
            types = VariousUtils.getType((VariableScope)this.getInScope(), tName, this.getOffset(), false);
        }
        if (types != null) {
            if (types.isEmpty() && tName != null && !VariousUtils.isSemiType(tName)) {
                return empty;
            }
            this.typeNameScopes = Union2.createSecond(types);
            return types;
        }
        this.typeNameScopes = null;
        return empty;
    }

    Container getContainer() {
        return this.container;
    }

    @Override
    public OffsetRange getBlockRange() {
        return this.scopeRange;
    }

    @Override
    public String getNormalizedName() {
        return this.getClass().getName() + ":" + this.toString() + ":" + String.valueOf(this.getOffset());
    }

    public boolean isArrayAccess() {
        String tpName = this.typeNameFromUnion(true);
        return this.arrayAccess || tpName != null && tpName.equals("array");
    }

    public void setAsArrayAccess(boolean arrayAccess) {
        this.arrayAccess = arrayAccess;
    }

    public boolean isConditionalBlock() {
        return this.conditionalBlock;
    }

    public void setConditionalBlock(boolean conditionalBlock) {
        this.conditionalBlock = conditionalBlock;
    }

    public boolean isCatchClause() {
        return this.catchClause;
    }

    void setCatchClause(boolean catchClause) {
        this.catchClause = catchClause;
    }
}

