/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import com.sun.source.tree.CatchTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.UnionType;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.matching.Matcher;
import org.netbeans.api.java.source.matching.Pattern;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.jdk.UseSpecificCatch;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.util.NbBundle;

public class JoinCatches {
    public static ErrorDescription hint(HintContext ctx) {
        TryTree tt = (TryTree)ctx.getPath().getLeaf();
        ArrayList<? extends CatchTree> catches = new ArrayList<CatchTree>(tt.getCatches());
        if (catches.size() <= 1) {
            return null;
        }
        for (int i = 0; i < catches.size(); ++i) {
            CatchTree toTest = (CatchTree)catches.get(i);
            TreePath toTestPath = new TreePath(ctx.getPath(), toTest);
            TreePath mainVar = new TreePath(toTestPath, toTest.getParameter());
            VariableElement excVar = (VariableElement)ctx.getInfo().getTrees().getElement(mainVar);
            TypeMirror mainVarType = ctx.getInfo().getTrees().getTypeMirror(mainVar);
            if (excVar == null || !Utilities.isValidType(mainVarType)) continue;
            LinkedHashMap<TypeMirror, Integer> duplicates = new LinkedHashMap<TypeMirror, Integer>();
            duplicates.put(mainVarType, i);
            for (int j = i + 1; j < catches.size(); ++j) {
                boolean bl;
                TypeMirror varType;
                Pattern pattern = Pattern.createPatternWithRemappableVariables((TreePath)new TreePath(toTestPath, toTest.getBlock()), Collections.singleton(excVar), (boolean)false);
                Collection found = Matcher.create((CompilationInfo)ctx.getInfo()).setCancel(new AtomicBoolean()).setPresetVariable(ctx.getVariables(), ctx.getMultiVariables(), ctx.getVariableNames()).setSearchRoot(new TreePath(new TreePath(ctx.getPath(), (Tree)catches.get(j)), ((CatchTree)catches.get(j)).getBlock())).setTreeTopSearch().match(pattern);
                if (!found.iterator().hasNext()) continue;
                TreePath catchPath = new TreePath(ctx.getPath(), (Tree)catches.get(j));
                TreePath var = new TreePath(catchPath, ((CatchTree)catches.get(j)).getParameter());
                ArrayList<TreePath> statements = new ArrayList<TreePath>();
                TreePath blockPath = new TreePath(catchPath, ((CatchTree)catches.get(j)).getBlock());
                for (StatementTree statementTree : ((CatchTree)catches.get(j)).getBlock().getStatements()) {
                    statements.add(new TreePath(blockPath, statementTree));
                }
                if (UseSpecificCatch.assignsTo(ctx, var, statements) || !Utilities.isValidType(varType = ctx.getInfo().getTrees().getTypeMirror(var))) continue;
                boolean bl2 = true;
                ArrayList<? extends TypeMirror> varTypes = new ArrayList<TypeMirror>();
                if (varType.getKind() == TypeKind.UNION) {
                    varTypes.addAll(((UnionType)varType).getAlternatives());
                } else {
                    varTypes.add(varType);
                }
                Iterator it = duplicates.keySet().iterator();
                block3: while (it.hasNext()) {
                    TypeMirror existingType = (TypeMirror)it.next();
                    List<TypeMirror> caughtList = existingType.getKind() == TypeKind.UNION ? ((UnionType)existingType).getAlternatives() : Collections.singletonList(existingType);
                    for (TypeMirror typeMirror : varTypes) {
                        for (TypeMirror caught : caughtList) {
                            if (ctx.getInfo().getTypes().isSubtype(caught, typeMirror)) {
                                Integer index = (Integer)duplicates.get(existingType);
                                if (index == null) continue;
                                it.remove();
                                bl &= index > JoinCatches.findMin(duplicates.values());
                                continue;
                            }
                            if (!ctx.getInfo().getTypes().isSubtype(typeMirror, caught)) continue;
                            bl = false;
                        }
                        if (bl) continue;
                        break block3;
                    }
                }
                if (!bl || varTypes.isEmpty()) continue;
                duplicates.put(varType, j);
            }
            if (duplicates.size() < 2) continue;
            String displayName = NbBundle.getMessage(JoinCatches.class, (String)"ERR_JoinCatches");
            ArrayList<TypeMirrorHandle> types = new ArrayList<TypeMirrorHandle>();
            for (TypeMirror t : duplicates.keySet()) {
                types.add(TypeMirrorHandle.create((TypeMirror)t));
            }
            return ErrorDescriptionFactory.forName((HintContext)ctx, (Tree)toTest.getParameter().getType(), (String)displayName, (Fix[])new Fix[]{new FixImpl(ctx.getInfo(), ctx.getPath(), new ArrayList<Integer>(duplicates.values()), types).toEditorFix()});
        }
        return null;
    }

    private static int findMin(Collection<Integer> x) {
        int m = Integer.MAX_VALUE;
        for (int i : x) {
            if (i >= m) continue;
            m = i;
        }
        return m;
    }

    private static final class FixImpl
    extends JavaFix {
        private final List<Integer> duplicates;
        private final List<TypeMirrorHandle> typeHandles;

        public FixImpl(CompilationInfo info, TreePath tryStatement, List<Integer> duplicates, List<TypeMirrorHandle> types) {
            super(info, tryStatement);
            this.duplicates = duplicates;
            this.typeHandles = types;
        }

        protected String getText() {
            return NbBundle.getMessage(JoinCatches.class, (String)"FIX_JoinCatches");
        }

        private void addDisjointType(List<Tree> to, Tree type) {
            if (type == null) {
                return;
            }
            if (type.getKind() == Tree.Kind.UNION_TYPE) {
                to.addAll(((UnionTypeTree)type).getTypeAlternatives());
            } else {
                to.add(type);
            }
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath tp = ctx.getPath();
            LinkedList<Tree> disjointTypes = new LinkedList<Tree>();
            TryTree tt = (TryTree)tp.getLeaf();
            int first = this.duplicates.get(0);
            List<Integer> remainingDuplicates = this.duplicates.subList(1, this.duplicates.size());
            this.addDisjointType(disjointTypes, tt.getCatches().get(first).getParameter().getType());
            for (Integer d : remainingDuplicates) {
                this.addDisjointType(disjointTypes, tt.getCatches().get(d).getParameter().getType());
            }
            LinkedList<CatchTree> newCatches = new LinkedList<CatchTree>();
            int c = 0;
            for (CatchTree catchTree : tt.getCatches()) {
                if (c == first) {
                    wc.rewrite(catchTree.getParameter().getType(), (Tree)wc.getTreeMaker().UnionType(disjointTypes));
                }
                if (remainingDuplicates.contains(c++)) continue;
                newCatches.add(catchTree);
            }
            TryTree nue = wc.getTreeMaker().Try(tt.getResources(), tt.getBlock(), newCatches, tt.getFinallyBlock());
            wc.rewrite((Tree)tt, (Tree)nue);
        }
    }
}

