/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import org.primefaces.expression.SearchExpressionResolver;
import org.primefaces.expression.SearchExpressionResolverFactory;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.SharedStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchExpressionFacade {
    public static final int NONE = 0;
    public static final int VALIDATE_RENDERER = 1;
    public static final int IGNORE_NO_RESULT = 2;
    public static final int PARENT_FALLBACK = 3;
    private static final Logger LOG = Logger.getLogger(SearchExpressionFacade.class.getName());
    private static final String SHARED_EXPRESSION_BUFFER_KEY = SearchExpressionFacade.class.getName() + ".SHARED_EXPRESSION_BUFFER";
    private static final String SHARED_SPLIT_BUFFER_KEY = SearchExpressionFacade.class.getName() + ".SHARED_SPLIT_BUFFER_KEY";
    private static final char[] EXPRESSION_SEPARATORS = new char[]{',', ' '};

    public static List<UIComponent> resolveComponents(FacesContext context, UIComponent source, String expressions) {
        String[] splittedExpressions;
        ArrayList<UIComponent> components = new ArrayList<UIComponent>();
        if (!ComponentUtils.isValueBlank(expressions) && (splittedExpressions = SearchExpressionFacade.split(context, expressions, EXPRESSION_SEPARATORS)) != null) {
            SearchExpressionFacade.validateExpressions(context, source, expressions, splittedExpressions);
            for (String splittedExpression : splittedExpressions) {
                UIComponent component;
                String expression = splittedExpression.trim();
                if (ComponentUtils.isValueBlank(expression) || (component = SearchExpressionFacade.resolveComponent(context, source, expression)) == null) continue;
                components.add(component);
            }
        }
        return components;
    }

    public static String resolveComponentsForClient(FacesContext context, UIComponent source, String expressions) {
        return SearchExpressionFacade.resolveComponentsForClient(context, source, expressions, 0);
    }

    public static String resolveComponentsForClient(FacesContext context, UIComponent source, String expressions, int options) {
        if (ComponentUtils.isValueBlank(expressions)) {
            if (SearchExpressionFacade.isOptionSet(options, 3)) {
                return source.getParent().getClientId(context);
            }
            return null;
        }
        String[] splittedExpressions = SearchExpressionFacade.split(context, expressions, EXPRESSION_SEPARATORS);
        String buildedExpressions = "";
        if (splittedExpressions != null) {
            SearchExpressionFacade.validateExpressions(context, source, expressions, splittedExpressions);
            StringBuilder expressionsBuffer = SharedStringBuilder.get(context, SHARED_EXPRESSION_BUFFER_KEY);
            for (int i = 0; i < splittedExpressions.length; ++i) {
                String component;
                String expression = splittedExpressions[i].trim();
                if (ComponentUtils.isValueBlank(expression)) continue;
                if (i != 0 && expressionsBuffer.length() > 0) {
                    expressionsBuffer.append(" ");
                }
                if ((component = SearchExpressionFacade.resolveComponentForClient(context, source, expression, options)) == null) continue;
                expressionsBuffer.append(component);
            }
            buildedExpressions = expressionsBuffer.toString();
        }
        if (ComponentUtils.isValueBlank(buildedExpressions)) {
            return null;
        }
        return buildedExpressions;
    }

    public static String resolveComponentForClient(FacesContext context, UIComponent source, String expression) {
        return SearchExpressionFacade.resolveComponentForClient(context, source, expression, 0);
    }

    public static String resolveComponentForClient(FacesContext context, UIComponent source, String expression, int options) {
        if (ComponentUtils.isValueBlank(expression)) {
            return null;
        }
        char separatorChar = UINamingContainer.getSeparatorChar((FacesContext)context);
        String separatorString = String.valueOf(separatorChar);
        expression = expression.trim();
        SearchExpressionFacade.validateExpression(context, source, expression, separatorChar, separatorString);
        if (SearchExpressionFacade.isPassTroughExpression(expression)) {
            return expression;
        }
        UIComponent component = SearchExpressionFacade.resolveComponentInternal(context, source, expression, separatorChar, separatorString, options);
        if (component == null) {
            return null;
        }
        if (SearchExpressionFacade.isOptionSet(options, 1) && context.isProjectStage(ProjectStage.Development) && ComponentUtils.isValueBlank(component.getRendererType())) {
            LOG.warning("Can not update component \"" + component.getClass().getName() + "\" with id \"" + component.getClientId(context) + "\" without a attached renderer. Expression \"" + expression + "\" referenced from \"" + source.getClientId(context) + "\"");
        }
        return component.getClientId(context);
    }

    public static UIComponent resolveComponent(FacesContext context, UIComponent source, String expression) {
        return SearchExpressionFacade.resolveComponent(context, source, expression, 0);
    }

    public static UIComponent resolveComponent(FacesContext context, UIComponent source, String expression, int options) {
        if (ComponentUtils.isValueBlank(expression)) {
            if (SearchExpressionFacade.isOptionSet(options, 3)) {
                return source.getParent();
            }
            return null;
        }
        char separatorChar = UINamingContainer.getSeparatorChar((FacesContext)context);
        String separatorString = String.valueOf(separatorChar);
        expression = expression.trim();
        SearchExpressionFacade.validateExpression(context, source, expression, separatorChar, separatorString);
        if (expression.equals("@none")) {
            return null;
        }
        if (SearchExpressionFacade.isClientExpressionOnly(expression)) {
            throw new FacesException("Client side expression (PFS and @widgetVar) are not supported... expression \"" + expression + "\" referenced from \"" + source.getClientId(context) + "\".");
        }
        UIComponent component = SearchExpressionFacade.resolveComponentInternal(context, source, expression, separatorChar, separatorString, options);
        if (component == null && !SearchExpressionFacade.isOptionSet(options, 2)) {
            throw new FacesException("Cannot find component with expression \"" + expression + "\" referenced from \"" + source.getClientId(context) + "\".");
        }
        return component;
    }

    private static void validateExpression(FacesContext context, UIComponent source, String expression, char separatorChar, String separatorString) {
        if (context.isProjectStage(ProjectStage.Development)) {
            if (expression.startsWith(separatorString + "@")) {
                throw new FacesException("A expression should not start with the separater char and a keyword. Expression: \"" + expression + "\" referenced from \"" + source.getClientId(context) + "\"");
            }
            String[] subExpressions = SearchExpressionFacade.split(context, expression, separatorChar);
            if (subExpressions != null && subExpressions.length > 1) {
                for (String subExpression : subExpressions) {
                    if (SearchExpressionFacade.isNestable(subExpression = subExpression.trim())) continue;
                    throw new FacesException("Subexpression \"" + subExpression + "\" in full expression \"" + expression + "\" from \"" + source.getClientId(context) + "\" can not be nested.");
                }
            }
        }
    }

    private static void validateExpressions(FacesContext context, UIComponent source, String expressions, String[] splittedExpressions) {
        if (context.isProjectStage(ProjectStage.Development) && splittedExpressions.length > 1 && (expressions.contains("@none") || expressions.contains("@all"))) {
            throw new FacesException("It's not possible to use @none or @all combined with other expressions. Expressions: \"" + expressions + "\" referenced from \"" + source.getClientId(context) + "\"");
        }
    }

    private static UIComponent resolveComponentInternal(FacesContext context, UIComponent source, String expression, char separatorChar, String separatorString, int options) {
        UIComponent component;
        if (ComponentUtils.isValueBlank(expression)) {
            return null;
        }
        if (expression.contains("@")) {
            if (expression.contains(separatorString)) {
                boolean startsWithSeperator;
                boolean bl = startsWithSeperator = expression.charAt(0) == separatorChar;
                if (startsWithSeperator) {
                    expression = expression.substring(1);
                }
                UIComponent last = source;
                String[] subExpressions = SearchExpressionFacade.split(context, expression, separatorChar);
                if (subExpressions != null) {
                    for (int j = 0; j < subExpressions.length; ++j) {
                        SearchExpressionResolver resolver;
                        UIComponent temp;
                        String subExpression = subExpressions[j].trim();
                        if (ComponentUtils.isValueBlank(subExpression)) continue;
                        if (startsWithSeperator && j == 0 && !subExpression.contains("@")) {
                            subExpression = separatorString + subExpression;
                        }
                        if ((temp = (resolver = SearchExpressionResolverFactory.findResolver(subExpression)).resolve(source, last, subExpression)) == null) {
                            if (!SearchExpressionFacade.isOptionSet(options, 2)) {
                                throw new FacesException("Cannot find component for subexpression \"" + subExpression + "\" from component with id \"" + last.getClientId(context) + "\" in full expression \"" + expression + "\" referenced from \"" + source.getClientId(context) + "\".");
                            }
                            return null;
                        }
                        last = temp;
                    }
                }
                component = last;
            } else {
                SearchExpressionResolver resolver = SearchExpressionResolverFactory.findResolver(expression);
                component = resolver.resolve(source, source, expression);
                if (component == null && !SearchExpressionFacade.isOptionSet(options, 2)) {
                    throw new FacesException("Cannot find component for expression \"" + expression + "\" referenced from \"" + source.getClientId(context) + "\".");
                }
            }
        } else {
            component = source.findComponent(expression);
            if (component == null && !SearchExpressionFacade.isOptionSet(options, 2)) {
                throw new FacesException("Cannot find component with expression \"" + expression + "\" referenced from \"" + source.getClientId(context) + "\".");
            }
        }
        return component;
    }

    private static String[] split(FacesContext context, String value, char ... separators) {
        char[] charArray;
        if (value == null) {
            return null;
        }
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder buffer = SharedStringBuilder.get(context, SHARED_SPLIT_BUFFER_KEY);
        int parenthesesCounter = 0;
        for (char c : charArray = value.toCharArray()) {
            if (c == '(') {
                ++parenthesesCounter;
            }
            if (c == ')') {
                --parenthesesCounter;
            }
            if (parenthesesCounter == 0) {
                boolean isSeparator = false;
                for (char separator : separators) {
                    if (c != separator) continue;
                    isSeparator = true;
                }
                if (isSeparator) {
                    tokens.add(buffer.toString());
                    buffer.delete(0, buffer.length());
                    continue;
                }
                buffer.append(c);
                continue;
            }
            buffer.append(c);
        }
        tokens.add(buffer.toString());
        return tokens.toArray(new String[tokens.size()]);
    }

    private static boolean isPassTroughExpression(String expression) {
        return SearchExpressionFacade.isClientExpressionOnly(expression) || expression.contains("@all") || expression.contains("@none");
    }

    private static boolean isClientExpressionOnly(String expression) {
        return expression.contains("@(") || expression.contains("@widgetVar(");
    }

    private static boolean isNestable(String expression) {
        return !SearchExpressionFacade.isPassTroughExpression(expression);
    }

    private static boolean isOptionSet(int options, int option) {
        return (options & option) != 0;
    }
}

