/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.wizards;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.glassfish.common.ui.IpComboBox;
import org.netbeans.modules.glassfish.common.utils.Util;
import org.netbeans.modules.glassfish.common.wizards.AddDomainLocationVisualPanel;
import org.netbeans.modules.glassfish.common.wizards.AddServerLocationPanel;
import org.netbeans.modules.glassfish.common.wizards.ServerWizardIterator;
import org.netbeans.modules.glassfish.spi.ServerUtilities;
import org.netbeans.modules.glassfish.spi.Utils;
import org.netbeans.modules.glassfish.tooling.data.GlassFishConfig;
import org.netbeans.modules.glassfish.tooling.data.GlassFishVersion;
import org.netbeans.modules.glassfish.tooling.server.config.ConfigBuilderProvider;
import org.netbeans.modules.glassfish.tooling.server.config.GlassFishConfigManager;
import org.netbeans.modules.glassfish.tooling.server.config.JavaSEPlatform;
import org.netbeans.modules.glassfish.tooling.server.config.JavaSESet;
import org.netbeans.modules.glassfish.tooling.utils.ServerUtils;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class AddDomainLocationPanel
implements WizardDescriptor.Panel,
ChangeListener {
    private final String PROP_ERROR_MESSAGE = "WizardPanel_errorMessage";
    private final String PROP_WARNING_MESSAGE = "WizardPanel_warningMessage";
    private final String PROP_INFO_MESSAGE = "WizardPanel_infoMessage";
    private ServerWizardIterator wizardIterator;
    private AddDomainLocationVisualPanel component;
    private WizardDescriptor wizard;
    private transient List<ChangeListener> listeners = new CopyOnWriteArrayList<ChangeListener>();
    private String gfRoot;
    boolean defaultJavaSESupported;
    private AtomicBoolean isValidating = new AtomicBoolean();

    public AddDomainLocationPanel(ServerWizardIterator wizardIterator) {
        this.wizardIterator = wizardIterator;
        this.wizard = null;
    }

    public boolean isValid() {
        if (this.isValidating.compareAndSet(false, true)) {
            try {
                AddDomainLocationVisualPanel panel = (AddDomainLocationVisualPanel)this.getComponent();
                if (this.wizardIterator.isLocal()) {
                    boolean bl = this.validateForLocalDomain(panel);
                    return bl;
                }
                boolean bl = this.validateForRemoteDomain(panel);
                return bl;
            }
            finally {
                this.isValidating.set(false);
            }
        }
        return true;
    }

    @Override
    public void stateChanged(ChangeEvent ev) {
        this.fireChangeEvent(ev);
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    private void fireChangeEvent(ChangeEvent ev) {
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(ev);
        }
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new AddDomainLocationVisualPanel();
            this.component.addChangeListener(this);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        FileObject fo = FileUtil.getConfigFile((String)"Services/JavaHelp/org-netbeans-modules-usersguide-helpset.xml");
        if (null != fo) {
            return new HelpCtx("registering_app_server_hk2_domain");
        }
        return null;
    }

    public void readSettings(Object settings) {
        if (this.wizard == null) {
            this.wizard = (WizardDescriptor)settings;
        }
        this.gfRoot = this.wizardIterator.getGlassfishRoot();
        ((AddDomainLocationVisualPanel)this.getComponent()).initModels(this.gfRoot, this.wizardIterator.isLocal());
        JavaPlatform defaultJava = JavaPlatform.getDefault();
        JavaSEPlatform defaultJavaPlatform = JavaSEPlatform.toValue((String)defaultJava.getSpecification().getVersion().toString());
        GlassFishVersion glassFishVersion = ServerUtils.getServerVersion((String)this.gfRoot);
        GlassFishConfig configAdapter = GlassFishConfigManager.getConfig((URL)ConfigBuilderProvider.getBuilderConfig((GlassFishVersion)glassFishVersion));
        JavaSESet javaSEConfig = configAdapter != null ? configAdapter.getJavaSE() : null;
        Set glassFishJavaSEPlatfors = javaSEConfig != null ? javaSEConfig.platforms() : null;
        this.defaultJavaSESupported = glassFishJavaSEPlatfors != null ? glassFishJavaSEPlatfors.contains(defaultJavaPlatform) : false;
        this.wizardIterator.serDefaultJavaSESupported(this.defaultJavaSESupported);
    }

    public void storeSettings(Object settings) {
    }

    private static void setGlobalValues(ServerWizardIterator wizardIterator, AddDomainLocationVisualPanel panel) {
        wizardIterator.setTargetValue(panel.getTargetValue());
        wizardIterator.setUserName(panel.getUserNameValue());
        wizardIterator.setPassword(panel.getPasswordValue());
    }

    private String validateLocalHost(Object rawHost) {
        if (rawHost instanceof IpComboBox.InetAddr) {
            return ((IpComboBox.InetAddr)rawHost).toString();
        }
        if (rawHost instanceof String) {
            String host = (String)rawHost;
            if (host.length() == 0) {
                host = "localhost";
            }
            return host;
        }
        return "localhost";
    }

    private boolean validateForLocalDomain(AddDomainLocationVisualPanel panel) throws MissingResourceException {
        String domainField = panel.getLocalDomain().trim();
        File domainDirCandidate = new File(this.gfRoot, "domains" + File.separator + domainField);
        String host = this.validateLocalHost(panel.getLocalHost());
        if (domainField.length() < 1) {
            if (!Utils.canWrite(domainDirCandidate)) {
                this.wizard.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"MSG_EnterDomainDirectory"));
            } else {
                this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"MSG_MustHaveName"));
            }
            return false;
        }
        int dex = domainField.indexOf(File.separator);
        if (AddServerLocationPanel.isRegisterableDomain(domainDirCandidate, this.wizardIterator)) {
            String uri = this.wizardIterator.formatUri("localhost", this.wizardIterator.getAdminPort(), panel.getTargetValue(), new File(this.gfRoot, "domains").getAbsolutePath(), domainField);
            if (-1 == this.wizardIterator.getHttpPort()) {
                this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"ERR_InvalidDomainData", (Object)domainField));
                return false;
            }
            if (-1 == this.wizardIterator.getAdminPort()) {
                this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"ERR_InvalidDomainData", (Object)domainField));
                return false;
            }
            if (this.wizardIterator.hasServer(uri)) {
                this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"ERR_DomainAlreadyRegistered", (Object)domainField));
                return false;
            }
            this.wizardIterator.setDomainLocation(domainDirCandidate.getAbsolutePath());
            this.wizardIterator.setHostName(host);
            panel.setPortsFields(this.wizardIterator.getAdminPort(), this.wizardIterator.getHttpPort(), true);
            AddDomainLocationPanel.setGlobalValues(this.wizardIterator, panel);
            this.wizard.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"MSG_RegisterExistingEmbedded", (Object)domainField));
            return true;
        }
        panel.setPortsFields(false);
        File domainsDir = domainDirCandidate.getParentFile();
        if (Utils.canWrite(domainsDir) && dex < 0 && !ServerUtilities.isTP2(this.gfRoot) && !domainDirCandidate.exists()) {
            this.wizardIterator.setDomainLocation(domainDirCandidate.getAbsolutePath());
            this.wizardIterator.setHostName(host);
            this.wizardIterator.setUseDefaultPorts(panel.getUseDefaultPorts());
            AddDomainLocationPanel.setGlobalValues(this.wizardIterator, panel);
            if (this.defaultJavaSESupported) {
                this.wizard.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"MSG_CreateEmbedded", (Object)domainField));
            } else {
                this.wizard.putProperty("WizardPanel_warningMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"WRN_CreateEmbedded", (Object)domainField));
            }
            return this.defaultJavaSESupported;
        }
        domainDirCandidate = new File(domainField);
        String domainLoc = domainDirCandidate.getAbsolutePath();
        if (AddServerLocationPanel.isRegisterableDomain(domainDirCandidate)) {
            this.wizardIterator.setDomainLocation(domainLoc);
            this.wizardIterator.setHostName(host);
            AddDomainLocationPanel.setGlobalValues(this.wizardIterator, panel);
            this.wizard.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"MSG_RegisterExisting", (Object)domainField));
            Util.readServerConfiguration(domainDirCandidate, this.wizardIterator);
            return true;
        }
        if (AddServerLocationPanel.canCreate(domainDirCandidate) && !ServerUtilities.isTP2(this.gfRoot)) {
            this.wizardIterator.setDomainLocation(domainLoc);
            this.wizard.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"MSG_CreateDomain", (Object)domainField));
            this.wizardIterator.setUseDefaultPorts(panel.getUseDefaultPorts());
            this.wizardIterator.setHostName(host);
            AddDomainLocationPanel.setGlobalValues(this.wizardIterator, panel);
            return true;
        }
        if (new File(domainsDir, domainField).exists()) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"ERR_UnusableDomain", (Object)domainField));
        } else if (domainDirCandidate.exists()) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"ERR_UnusableDomain", (Object)domainField));
        } else {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"ERR_CannotCreateDomain", (Object)domainField));
        }
        return false;
    }

    private int strToInt(String str, String msgKey, List<String> errors) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            errors.add(NbBundle.getMessage(this.getClass(), (String)msgKey, (Object)str));
            return -1;
        }
    }

    private String joinErrorMessages(List<String> errors) {
        String eol = "<br/>";
        int length = 0;
        for (String error : errors) {
            length += (length > 0 ? "<br/>".length() : 0) + error.length();
        }
        StringBuilder sb = new StringBuilder(length);
        for (String error : errors) {
            if (sb.length() > 0) {
                sb.append("<br/>");
            }
            sb.append(error);
        }
        return sb.toString();
    }

    private boolean validateForRemoteDomain(AddDomainLocationVisualPanel panel) {
        String host = panel.getRemoteHost();
        LinkedList<String> errors = new LinkedList<String>();
        int dasPort = this.strToInt(panel.getAdminPortValue(), "AddDomainLocationPanel.invalidDasPort", errors);
        int httpPort = this.strToInt(panel.getHttpPortValue(), "AddDomainLocationPanel.invalidHttpPort", errors);
        if (dasPort < 0 || httpPort < 0) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)this.joinErrorMessages(errors));
            return false;
        }
        this.wizardIterator.setAdminPort(dasPort);
        this.wizardIterator.setHttpPort(httpPort);
        this.wizardIterator.setHostName(host);
        this.wizardIterator.setRemoteDomain(panel.getRemoteDomain());
        AddDomainLocationPanel.setGlobalValues(this.wizardIterator, panel);
        this.wizard.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"AddDomainLocationPanel.remoteInstance", (Object)host, (Object)Integer.toString(dasPort), (Object)Integer.toString(httpPort)));
        return true;
    }
}

