/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class GlassFishExecutors {
    private static final String THREAD_GROUP_NAME_TOP = "GlassFish";
    private static final String THREAD_GROUP_NAME_LOG = "Log Reader";
    private static final String THREAD_GROUP_NAME_STAT = "Status Task";
    private static final ThreadGroup tgTop = GlassFishExecutors.initTgTop();
    private static final ThreadGroup tgLog = GlassFishExecutors.initTgLog();
    private static final ThreadGroup tgStat = GlassFishExecutors.initTgStat();
    private static final int FETCH_LOG_EXECUTOR_POOL_MIN_SIZE = 1;
    private static final int FETCH_LOG_EXECUTOR_POOL_MAX_SIZE = Integer.MAX_VALUE;
    private static final long FETCH_LOG_EXECUTOR_POOL_KEEPALIVE_TIME = 0L;
    private static final ThreadPoolExecutor fetchLogExecutor = new ThreadPoolExecutor(1, Integer.MAX_VALUE, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new FetchLogThreadFactory());

    private static ThreadGroup initTgTop() {
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        if (tg != null) {
            ThreadGroup tgParrent;
            while ((tgParrent = tg.getParent()) != null) {
                tg = tgParrent;
            }
        }
        return new ThreadGroup(tg, THREAD_GROUP_NAME_TOP);
    }

    private static ThreadGroup initTgLog() {
        return new ThreadGroup(tgTop, THREAD_GROUP_NAME_LOG);
    }

    private static ThreadGroup initTgStat() {
        return new ThreadGroup(tgTop, THREAD_GROUP_NAME_STAT);
    }

    public static ExecutorService fetchLogExecutor() {
        return fetchLogExecutor;
    }

    private static final class FetchLogThreadFactory
    implements ThreadFactory {
        private FetchLogThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(tgLog, r, GlassFishExecutors.THREAD_GROUP_NAME_LOG);
            t.setDaemon(true);
            return t;
        }
    }

    private static final class StatusThreadFactory
    implements ThreadFactory {
        private StatusThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(tgStat, r, GlassFishExecutors.THREAD_GROUP_NAME_STAT);
            t.setDaemon(true);
            return t;
        }
    }
}

