/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony2.commands;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.symfony2.commands.Bundle;
import org.netbeans.modules.php.symfony2.commands.SymfonyCommandVO;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class SymfonyCommandsXmlParser
extends DefaultHandler {
    private static final Logger LOGGER = Logger.getLogger(SymfonyCommandsXmlParser.class.getName());
    private final XMLReader xmlReader;
    private final List<SymfonyCommandVO> commands;
    private String currentCommand = null;
    private List<StringBuilder> currentUsages = null;
    private String currentDescription = null;
    private StringBuilder currentHelp = null;
    private Content content = Content.NONE;

    private SymfonyCommandsXmlParser(List<SymfonyCommandVO> commands) throws SAXException {
        assert (commands != null);
        this.commands = commands;
        this.xmlReader = FileUtils.createXmlReader();
    }

    public static void parse(Reader reader, List<SymfonyCommandVO> commands) {
        try {
            SymfonyCommandsXmlParser parser = new SymfonyCommandsXmlParser(commands);
            parser.xmlReader.setContentHandler(parser);
            parser.xmlReader.parse(new InputSource(reader));
        }
        catch (SAXException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        catch (Throwable ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, null, ex);
            }
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("commands".equals(qName)) {
            assert (this.content == Content.NONE);
            this.content = Content.COMMANDS;
        } else if ("command".equals(qName)) {
            if (this.content != Content.COMMANDS) {
                return;
            }
            assert (this.currentCommand == null);
            assert (this.currentUsages == null);
            assert (this.currentDescription == null);
            assert (this.currentHelp == null);
            this.currentCommand = attributes.getValue("name");
            this.currentUsages = new ArrayList<StringBuilder>();
        } else if ("usage".equals(qName)) {
            assert (this.content == Content.COMMANDS) : this.content;
            assert (this.currentUsages != null);
            assert (this.currentDescription == null);
            assert (this.currentHelp == null);
            if (this.currentCommand != null) {
                this.content = Content.USAGE;
                this.currentUsages.add(new StringBuilder());
            }
        } else if ("description".equals(qName)) {
            assert (this.content == Content.COMMANDS) : this.content;
            assert (this.currentDescription == null);
            assert (this.currentHelp == null);
            if (this.currentCommand != null) {
                this.content = Content.DESCRIPTION;
            }
        } else if ("help".equals(qName)) {
            assert (this.content == Content.COMMANDS) : this.content;
            assert (this.currentHelp == null);
            if (this.currentCommand != null) {
                this.content = Content.HELP;
                this.currentHelp = new StringBuilder();
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("commands".equals(qName)) {
            this.content = Content.NONE;
        } else if ("usage".equals(qName)) {
            if (this.content == Content.USAGE) {
                this.content = Content.COMMANDS;
            }
        } else if ("description".equals(qName)) {
            if (this.content == Content.DESCRIPTION) {
                this.content = Content.COMMANDS;
            }
        } else if ("help".equals(qName) && this.content == Content.HELP) {
            assert (this.currentCommand != null);
            if (this.currentUsages == null) {
                this.currentUsages = Collections.emptyList();
            }
            if (this.currentDescription == null) {
                this.currentDescription = "";
            }
            this.commands.add(new SymfonyCommandVO(this.currentCommand.trim(), this.currentDescription.trim(), SymfonyCommandsXmlParser.processHelp(this.currentUsages, this.currentHelp.toString().trim())));
            this.currentCommand = null;
            this.currentUsages = null;
            this.currentDescription = null;
            this.currentHelp = null;
            this.content = Content.COMMANDS;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        switch (this.content.ordinal()) {
            case 1: {
                break;
            }
            case 2: {
                this.currentUsages.get(this.currentUsages.size() - 1).append(ch, start, length);
                break;
            }
            case 3: {
                this.currentDescription = new String(ch, start, length);
                break;
            }
            case 4: {
                assert (this.currentHelp != null);
                this.currentHelp.append(ch, start, length);
                break;
            }
            case 0: {
                break;
            }
            default: {
                assert (false) : "Unknown content: " + (Object)((Object)this.content);
                break;
            }
        }
    }

    private static String processHelp(List<StringBuilder> usages, String help) {
        StringBuilder result = new StringBuilder();
        boolean titlePrinted = false;
        for (StringBuilder usage : usages) {
            String usg = usage.toString().trim();
            if (!StringUtils.hasText((String)usg)) continue;
            if (!titlePrinted) {
                titlePrinted = true;
                result.append(Bundle.LBL_Usage());
            }
            result.append("<br><i>");
            result.append(usg.replace("<", "&lt;").replace(">", "&gt;"));
            result.append("</i>");
        }
        if (titlePrinted) {
            result.append("<br><br>");
        }
        if (StringUtils.hasText((String)help)) {
            result.append(help.replace("<info>", "<i>").replace("</info>", "</i>").replace("<comment>", "<i>").replace("</comment>", "</i>").replace("\n", "<br>"));
        }
        if (result.length() == 0) {
            return "";
        }
        return "<html>" + result.toString();
    }

    static enum Content {
        NONE,
        COMMANDS,
        USAGE,
        DESCRIPTION,
        HELP;

    }
}

