/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.prep.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.netbeans.modules.css.indexing.api.CssIndexModel;
import org.netbeans.modules.css.indexing.api.CssIndexModelFactory;
import org.netbeans.modules.css.lib.api.CssParserResult;
import org.netbeans.modules.css.prep.editor.model.CPElement;
import org.netbeans.modules.css.prep.editor.model.CPElementHandle;
import org.netbeans.modules.css.prep.editor.model.CPElementType;
import org.netbeans.modules.css.prep.editor.model.CPModel;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.openide.filesystems.FileObject;

public class CPCssIndexModel
extends CssIndexModel {
    private static final String MIXINS_INDEX_KEY = "cp_mixins";
    private static final String VARIABLES_INDEX_KEY = "cp_variables";
    private static final Collection<String> INDEX_KEYS = Arrays.asList("cp_mixins", "cp_variables");
    private static final String VALUE_SEPARATOR = ",";
    private static final String ITEMS_SEPARATOR = "/";
    private Collection<CPElementHandle> mixins;
    private Collection<CPElementHandle> variables;

    public CPCssIndexModel(Collection<CPElementHandle> mixins, Collection<CPElementHandle> variableNames) {
        this.mixins = mixins;
        this.variables = variableNames;
    }

    public Collection<CPElementHandle> getVariables() {
        return this.variables;
    }

    public Collection<CPElementHandle> getMixins() {
        return this.mixins;
    }

    public void storeToIndex(IndexDocument document) {
        this.storeItems(this.mixins, document, MIXINS_INDEX_KEY);
        this.storeItems(this.variables, document, VARIABLES_INDEX_KEY);
    }

    private void storeItems(Collection<? extends CPElementHandle> items, IndexDocument document, String key) {
        Iterator<? extends CPElementHandle> i = items.iterator();
        StringBuilder sb = new StringBuilder();
        while (i.hasNext()) {
            CPElementHandle handle = i.next();
            sb.append(handle.getName());
            sb.append(ITEMS_SEPARATOR);
            sb.append(handle.getType().getIndexCode());
            sb.append(ITEMS_SEPARATOR);
            sb.append(CPCssIndexModel.encodeElementId(handle.getElementId()));
            if (!i.hasNext()) continue;
            sb.append(VALUE_SEPARATOR);
        }
        document.addPair(key, sb.toString(), false, true);
    }

    static String encodeElementId(String string) {
        return string.replace('/', '%');
    }

    static String decodeElementId(String string) {
        return string.replace('%', '/');
    }

    public static final class Factory
    extends CssIndexModelFactory {
        public CPCssIndexModel getModel(CssParserResult result) {
            CPModel model = CPModel.getModel(result);
            Collection<CPElement> mixins = model.getMixins();
            Collection<CPElement> vars = model.getVariables();
            return new CPCssIndexModel(CPElement.toHandles(mixins), CPElement.toHandles(vars));
        }

        public CPCssIndexModel loadFromIndex(IndexResult result) {
            String mixins = result.getValue(CPCssIndexModel.MIXINS_INDEX_KEY);
            String variables = result.getValue(CPCssIndexModel.VARIABLES_INDEX_KEY);
            return new CPCssIndexModel(this.parseItems(mixins, result.getFile()), this.parseItems(variables, result.getFile()));
        }

        public Collection<String> getIndexKeys() {
            return INDEX_KEYS;
        }

        private Collection<CPElementHandle> parseItems(String value, FileObject file) {
            if (value == null || value.isEmpty()) {
                return Collections.emptyList();
            }
            String[] items = value.split(CPCssIndexModel.VALUE_SEPARATOR);
            ArrayList<CPElementHandle> handles = new ArrayList<CPElementHandle>(items.length);
            for (String item : items) {
                String[] split = item.split(CPCssIndexModel.ITEMS_SEPARATOR);
                String name = split[0];
                String typeIndexCode = split[1];
                String elementId = CPCssIndexModel.decodeElementId(split[2]);
                CPElementType type = CPElementType.forIndexCode(typeIndexCode);
                CPElementHandle handle = new CPElementHandle(file, name, type, elementId);
                handles.add(handle);
            }
            return handles;
        }
    }
}

