/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.monitoring.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.monitoring.model.ListMetricsDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ListMetricsRequest
extends BmcRequest<ListMetricsDetails> {
    private String compartmentId;
    private ListMetricsDetails listMetricsDetails;
    private String opcRequestId;
    private String page;
    private Integer limit;
    private Boolean compartmentIdInSubtree;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public ListMetricsDetails getListMetricsDetails() {
        return this.listMetricsDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    @InternalSdk
    public ListMetricsDetails getBody$() {
        return this.listMetricsDetails;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).listMetricsDetails(this.listMetricsDetails).opcRequestId(this.opcRequestId).page(this.page).limit(this.limit).compartmentIdInSubtree(this.compartmentIdInSubtree);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",listMetricsDetails=").append(String.valueOf((Object)this.listMetricsDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",compartmentIdInSubtree=").append(String.valueOf(this.compartmentIdInSubtree));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListMetricsRequest)) {
            return false;
        }
        ListMetricsRequest other = (ListMetricsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.listMetricsDetails, (Object)other.listMetricsDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals(this.compartmentIdInSubtree, other.compartmentIdInSubtree);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.listMetricsDetails == null ? 43 : this.listMetricsDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.compartmentIdInSubtree == null ? 43 : this.compartmentIdInSubtree.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListMetricsRequest, ListMetricsDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private ListMetricsDetails listMetricsDetails = null;
        private String opcRequestId = null;
        private String page = null;
        private Integer limit = null;
        private Boolean compartmentIdInSubtree = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder listMetricsDetails(ListMetricsDetails listMetricsDetails) {
            this.listMetricsDetails = listMetricsDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListMetricsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.listMetricsDetails(o.getListMetricsDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.compartmentIdInSubtree(o.getCompartmentIdInSubtree());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListMetricsRequest build() {
            ListMetricsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ListMetricsDetails body) {
            this.listMetricsDetails(body);
            return this;
        }

        public ListMetricsRequest buildWithoutInvocationCallback() {
            ListMetricsRequest request = new ListMetricsRequest();
            request.compartmentId = this.compartmentId;
            request.listMetricsDetails = this.listMetricsDetails;
            request.opcRequestId = this.opcRequestId;
            request.page = this.page;
            request.limit = this.limit;
            request.compartmentIdInSubtree = this.compartmentIdInSubtree;
            return request;
        }
    }
}

