/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.tag;

import java.io.File;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.tag.CreateTag;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CreateTagAction
extends ContextAction {
    @Override
    protected boolean enable(Node[] nodes) {
        return HgUtils.isFromHgRepository(HgUtils.getCurrentContext(nodes));
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_CreateTag";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext ctx = HgUtils.getCurrentContext(nodes);
        File[] roots = HgUtils.getActionRoots(ctx);
        if (roots == null || roots.length == 0) {
            return;
        }
        final File repository = Mercurial.getInstance().getRepositoryRoot(roots[0]);
        CreateTag createTag = new CreateTag(repository);
        if (!createTag.showDialog()) {
            return;
        }
        final String tagName = createTag.getTagName();
        final String message = createTag.getMessage();
        final String revision = createTag.getRevision();
        final boolean local = createTag.isLocalTag();
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(repository);
        HgProgressSupport support = new HgProgressSupport(this){
            final /* synthetic */ CreateTagAction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void perform() {
                OutputLogger logger = this.getLogger();
                try {
                    logger.outputInRed(NbBundle.getMessage(CreateTagAction.class, (String)"MSG_CREATE_TITLE"));
                    logger.outputInRed(NbBundle.getMessage(CreateTagAction.class, (String)"MSG_CREATE_TITLE_SEP"));
                    logger.output(NbBundle.getMessage(CreateTagAction.class, (String)"MSG_CREATE_INFO_SEP", (Object)tagName, (Object)repository.getAbsolutePath()));
                    HgCommand.createTag(repository, tagName, message, revision, local, logger);
                    if (!local) {
                        HgUtils.logHgLog(HgCommand.doTip(repository, logger), logger);
                    }
                }
                catch (HgException.HgCommandCanceledException hgCommandCanceledException) {
                }
                catch (HgException ex) {
                    HgUtils.notifyException(ex);
                }
                logger.outputInRed(NbBundle.getMessage(CreateTagAction.class, (String)"MSG_CREATE_DONE"));
                logger.output("");
            }
        };
        support.start(rp, repository, NbBundle.getMessage(CreateTagAction.class, (String)"MSG_CreateTag_Progress", (Object)tagName));
    }
}

