/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ide.ergonomics.fod;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ide.ergonomics.fod.FeatureInfo;
import org.netbeans.modules.ide.ergonomics.fod.FeatureProjectFactory;
import org.netbeans.modules.ide.ergonomics.fod.FindComponentModules;
import org.netbeans.modules.ide.ergonomics.fod.FoDLayersProvider;
import org.netbeans.modules.ide.ergonomics.fod.ModulesActivator;
import org.netbeans.modules.ide.ergonomics.fod.ModulesInstaller;
import org.netbeans.modules.ide.ergonomics.fod.ProgressMonitor;
import org.netbeans.spi.project.ui.ProjectConvertor;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

class FeatureProjectConvertor
implements ProjectConvertor {
    private final FileObject def;

    private FeatureProjectConvertor(FileObject def) {
        this.def = def;
    }

    static ProjectConvertor create(FileObject def) {
        return new FeatureProjectConvertor(def);
    }

    public ProjectConvertor.Result isProject(FileObject projectDirectory) {
        return new ProjectConvertor.Result(Lookup.EMPTY, (Callable)new Factory(projectDirectory), projectDirectory.getName(), FeatureProjectFactory.loadIcon());
    }

    private final class Factory
    implements Callable<Project>,
    ProgressMonitor {
        private final FileObject projectDir;

        public Factory(FileObject projectDir) {
            this.projectDir = projectDir;
        }

        @Override
        public Project call() throws Exception {
            FeatureInfo info = FoDLayersProvider.getInstance().whichProvides(FeatureProjectConvertor.this.def);
            FindComponentModules findModules = new FindComponentModules(info, new FeatureInfo[0]);
            Collection<UpdateElement> toInstall = findModules.getModulesForInstall();
            Collection<UpdateElement> toEnable = findModules.getModulesForEnable();
            if (toInstall != null && !toInstall.isEmpty()) {
                ModulesInstaller installer = new ModulesInstaller(toInstall, findModules, this);
                installer.getInstallTask().schedule(0);
                installer.getInstallTask().waitFinished();
            } else if (toEnable != null && !toEnable.isEmpty()) {
                ModulesActivator enabler = new ModulesActivator(toEnable, findModules, this);
                enabler.getEnableTask().schedule(0);
                enabler.getEnableTask().waitFinished();
            }
            ProjectConvertor delegate = (ProjectConvertor)FeatureProjectConvertor.this.def.getAttribute("fod");
            if (delegate == null) {
                throw new IOException("Cannot find project convertor for " + this.projectDir);
            }
            ProjectConvertor.Result res = delegate.isProject(this.projectDir);
            if (res == null) {
                throw new IOException("Cannot recognize project for " + this.projectDir + " by " + delegate);
            }
            return res.createProject();
        }

        @Override
        public void onDownload(ProgressHandle progressHandle) {
        }

        @Override
        public void onValidate(ProgressHandle progressHandle) {
        }

        @Override
        public void onInstall(ProgressHandle progressHandle) {
        }

        @Override
        public void onEnable(ProgressHandle progressHandle) {
        }

        @Override
        public void onError(String message) {
        }
    }
}

