/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.ui.support;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.project.ui.convertor.ProjectConvertorFactory;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.LookupListener;
import org.openide.util.Parameters;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class ProjectConvertors {
    private ProjectConvertors() {
        throw new IllegalStateException("No instance allowed");
    }

    public static boolean isConvertorProject(@NonNull Project project) {
        return ProjectConvertorFactory.isConvertorProject(project);
    }

    public static void unregisterConvertorProject(@NonNull Project project) {
        ProjectConvertorFactory.unregisterConvertorProject(project);
    }

    @CheckForNull
    public static Project getNonConvertorOwner(@NonNull FileObject file) {
        for (FileObject parent = file; parent != null; parent = parent.getParent()) {
            Project prj = FileOwnerQuery.getOwner((FileObject)parent);
            if (prj != null && ProjectConvertors.isConvertorProject(prj)) continue;
            return prj;
        }
        return null;
    }

    @NonNull
    public static FileEncodingQueryImplementation createFileEncodingQuery() {
        return new ConvertorFileEncodingQuery();
    }

    @NonNull
    public static Lookup createProjectConvertorLookup(Object ... instances) {
        return new CloseableLookup(instances);
    }

    @NonNull
    public static Lookup createDelegateToOwnerLookup(@NonNull FileObject projectDirectory) {
        return new OwnerLookup(projectDirectory);
    }

    private static final class ConvertorFileEncodingQuery
    extends FileEncodingQueryImplementation {
        ConvertorFileEncodingQuery() {
        }

        @CheckForNull
        public Charset getEncoding(@NonNull FileObject file) {
            Project p = ProjectConvertors.getNonConvertorOwner(file);
            return p != null ? ((FileEncodingQueryImplementation)p.getLookup().lookup(FileEncodingQueryImplementation.class)).getEncoding(file) : null;
        }
    }

    private static final class CloseableLookup
    extends ProxyLookup
    implements Closeable {
        CloseableLookup(Object ... instances) {
            this.setLookups(new Lookup[]{Lookups.fixed((Object[])instances)});
        }

        @Override
        public void close() throws IOException {
            this.setLookups(new Lookup[]{Lookup.EMPTY});
        }
    }

    private static final class OwnerLookup
    extends Lookup
    implements Closeable {
        private static final Class[] BLACK_LIST = new Class[]{ProjectOpenedHook.class, ProjectInformation.class};
        private final FileObject projectDirectory;
        private volatile boolean closed;
        private static final Lookup.Result<?> EMPTY_RESULT = new Lookup.Result<Object>(){

            public void addLookupListener(LookupListener l) {
            }

            public void removeLookupListener(LookupListener l) {
            }

            public Collection<?> allInstances() {
                return Collections.emptySet();
            }
        };

        OwnerLookup(@NonNull FileObject projectDirectory) {
            Parameters.notNull((CharSequence)"projectDirectory", (Object)projectDirectory);
            this.projectDirectory = projectDirectory;
        }

        public <T> T lookup(Class<T> clazz) {
            Lookup delegate;
            if (OwnerLookup.supports(clazz) && (delegate = this.findDelegate()) != null) {
                return (T)delegate.lookup(clazz);
            }
            return null;
        }

        public <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
            Lookup delegate;
            if (OwnerLookup.supports(template.getType()) && (delegate = this.findDelegate()) != null) {
                return delegate.lookup(template);
            }
            return EMPTY_RESULT;
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
        }

        private Lookup findDelegate() {
            if (this.closed) {
                return null;
            }
            Project currentOwner = ProjectConvertors.getNonConvertorOwner(this.projectDirectory);
            return currentOwner == null ? null : currentOwner.getLookup();
        }

        private static boolean supports(@NullAllowed Class<?> clz) {
            if (clz == null) {
                return false;
            }
            for (Class blackListed : BLACK_LIST) {
                if (!blackListed.isAssignableFrom(clz)) continue;
                return false;
            }
            return true;
        }
    }
}

