/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.classfile;

import com.sun.tools.classfile.Attribute;
import com.sun.tools.classfile.AttributeException;
import com.sun.tools.classfile.Attributes;
import com.sun.tools.classfile.ClassReader;
import com.sun.tools.classfile.ConstantPoolException;
import com.sun.tools.classfile.Instruction;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Code_attribute
extends Attribute {
    public final int max_stack;
    public final int max_locals;
    public final int code_length;
    public final byte[] code;
    public final int exception_table_length;
    public final Exception_data[] exception_table;
    public final Attributes attributes;

    Code_attribute(ClassReader cr, int name_index, int length) throws IOException, ConstantPoolException {
        super(name_index, length);
        this.max_stack = cr.readUnsignedShort();
        this.max_locals = cr.readUnsignedShort();
        this.code_length = cr.readInt();
        this.code = new byte[this.code_length];
        cr.readFully(this.code);
        this.exception_table_length = cr.readUnsignedShort();
        this.exception_table = new Exception_data[this.exception_table_length];
        for (int i = 0; i < this.exception_table_length; ++i) {
            this.exception_table[i] = new Exception_data(cr);
        }
        this.attributes = new Attributes(cr);
    }

    public int getByte(int offset) throws InvalidIndex {
        if (offset < 0 || offset >= this.code.length) {
            throw new InvalidIndex(offset);
        }
        return this.code[offset];
    }

    public int getUnsignedByte(int offset) throws InvalidIndex {
        if (offset < 0 || offset >= this.code.length) {
            throw new InvalidIndex(offset);
        }
        return this.code[offset] & 0xFF;
    }

    public int getShort(int offset) throws InvalidIndex {
        if (offset < 0 || offset + 1 >= this.code.length) {
            throw new InvalidIndex(offset);
        }
        return this.code[offset] << 8 | this.code[offset + 1] & 0xFF;
    }

    public int getUnsignedShort(int offset) throws InvalidIndex {
        if (offset < 0 || offset + 1 >= this.code.length) {
            throw new InvalidIndex(offset);
        }
        return (this.code[offset] << 8 | this.code[offset + 1] & 0xFF) & 0xFFFF;
    }

    public int getInt(int offset) throws InvalidIndex {
        if (offset < 0 || offset + 3 >= this.code.length) {
            throw new InvalidIndex(offset);
        }
        return this.getShort(offset) << 16 | this.getShort(offset + 2) & 0xFFFF;
    }

    @Override
    public <R, D> R accept(Attribute.Visitor<R, D> visitor, D data) {
        return visitor.visitCode(this, data);
    }

    public Iterable<Instruction> getInstructions() {
        return () -> new Iterator<Instruction>(){
            Instruction current = null;
            int pc = 0;
            Instruction next;
            {
                this.next = this.pc < Code_attribute.this.code.length ? new Instruction(Code_attribute.this.code, this.pc) : null;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public Instruction next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                this.current = this.next;
                this.pc += this.current.length();
                this.next = this.pc < Code_attribute.this.code.length ? new Instruction(Code_attribute.this.code, this.pc) : null;
                return this.current;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported.");
            }
        };
    }

    public static class Exception_data {
        public final int start_pc;
        public final int end_pc;
        public final int handler_pc;
        public final int catch_type;

        Exception_data(ClassReader cr) throws IOException {
            this.start_pc = cr.readUnsignedShort();
            this.end_pc = cr.readUnsignedShort();
            this.handler_pc = cr.readUnsignedShort();
            this.catch_type = cr.readUnsignedShort();
        }
    }

    public static class InvalidIndex
    extends AttributeException {
        private static final long serialVersionUID = -8904527774589382802L;
        public final int index;

        InvalidIndex(int index) {
            this.index = index;
        }

        @Override
        public String getMessage() {
            return "invalid index " + this.index + " in Code attribute";
        }
    }
}

