/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.session;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.core.api.support.java.method.MethodModel;
import org.netbeans.modules.j2ee.core.api.support.java.method.MethodModelSupport;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.SessionMethodController;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.session.IconVisitor;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.session.SessionChildren;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared.ComponentMethodModel;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared.ComponentMethodViewStrategy;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared.MethodsNode;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;

public class MethodChildren
extends ComponentMethodModel {
    private static final Logger LOG = Logger.getLogger(MethodChildren.class.getName());
    private ComponentMethodViewStrategy mvs;
    private final SessionMethodController controller;
    private final MethodsNode.ViewType viewType;
    private final SessionChildren session;

    public MethodChildren(SessionChildren session, ClasspathInfo cpInfo, EjbJar ejbModule, SessionMethodController smc, MethodsNode.ViewType viewType) {
        super(cpInfo, ejbModule, smc.getBeanClass(), MethodChildren.getHomeInterface(smc, viewType));
        this.controller = smc;
        this.viewType = viewType;
        this.session = session;
        this.mvs = new SessionStrategy();
    }

    private static String getHomeInterface(SessionMethodController smc, MethodsNode.ViewType viewType) {
        if (viewType == MethodsNode.ViewType.NO_INTERFACE) {
            return null;
        }
        return viewType == MethodsNode.ViewType.LOCAL ? smc.getLocalHome() : smc.getHome();
    }

    @Override
    protected Collection<String> getInterfaces() {
        if (this.viewType == MethodsNode.ViewType.LOCAL) {
            return this.controller.getLocalInterfaces();
        }
        if (this.viewType == MethodsNode.ViewType.REMOTE) {
            return this.controller.getRemoteInterfaces();
        }
        return this.controller.getLocalInterfaces();
    }

    @Override
    public ComponentMethodViewStrategy createViewStrategy() {
        return this.mvs;
    }

    @Override
    public void fireTypeChange() {
        this.session.propertyChange(new PropertyChangeEvent((Object)this, "TYPE_CHANGE", "", ""));
    }

    private class SessionStrategy
    implements ComponentMethodViewStrategy {
        private SessionStrategy() {
        }

        @Override
        public void deleteImplMethod(MethodModel me, String implClass, FileObject implClassFO) throws IOException {
            switch (MethodChildren.this.viewType) {
                case NO_INTERFACE: {
                    MethodChildren.this.controller.delete(me);
                    break;
                }
                case LOCAL: 
                case REMOTE: {
                    SessionMethodController sessionMethodController = MethodChildren.this.controller;
                    MethodsNode.ViewType viewType = MethodChildren.this.viewType;
                    MethodChildren.this.viewType;
                    sessionMethodController.delete(me, viewType == MethodsNode.ViewType.LOCAL);
                }
            }
        }

        @Override
        public Image getBadge(MethodModel me) {
            return null;
        }

        @Override
        public Image getIcon(MethodModel me) {
            IconVisitor iv = new IconVisitor();
            return ImageUtilities.loadImage((String)iv.getIconUrl(MethodChildren.this.controller.getMethodTypeFromInterface(me)));
        }

        @Override
        public void openMethod(final MethodModel me, final String implClass, FileObject implClassFO) {
            final ArrayList methodHandle = new ArrayList();
            try {
                if (implClassFO == null) {
                    LOG.log(Level.WARNING, "No fileObject found for class={0}.", implClass);
                }
                JavaSource javaSource = JavaSource.forFileObject((FileObject)implClassFO);
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){
                    final /* synthetic */ SessionStrategy this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run(CompilationController controller) throws IOException {
                        controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        TypeElement typeElement = controller.getElements().getTypeElement(implClass);
                        for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                            if (!MethodModelSupport.isSameMethod((CompilationController)controller, (ExecutableElement)executableElement, (MethodModel)me)) continue;
                            methodHandle.add(ElementHandle.create((Element)executableElement));
                        }
                    }
                }, true);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
            if (methodHandle.size() > 0) {
                ElementOpen.open((FileObject)implClassFO, (ElementHandle)((ElementHandle)methodHandle.get(0)));
            }
        }
    }
}

