/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.nette.tester.options;

import java.util.List;
import java.util.prefs.Preferences;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.php.api.util.FileUtils;
import org.openide.util.NbPreferences;

public final class TesterOptions {
    private static final String PREFERENCES_PATH = "nette-tester";
    private static final TesterOptions INSTANCE = new TesterOptions();
    private static final String TESTER_PATH = "tester.path";
    private static final String BINARY_EXECUTABLE = "binary.executable";
    private static final String PHP_INI_PATH = "php.ini.path";
    private volatile boolean testerSearched = false;

    private TesterOptions() {
    }

    public static TesterOptions getInstance() {
        return INSTANCE;
    }

    @CheckForNull
    public String getTesterPath() {
        String path = this.getPreferences().get(TESTER_PATH, null);
        if (path == null && !this.testerSearched) {
            this.testerSearched = true;
            List scripts = FileUtils.findFileOnUsersPath((String)"tester");
            if (!scripts.isEmpty()) {
                path = (String)scripts.get(0);
                this.setTesterPath(path);
            }
        }
        return path;
    }

    public void setTesterPath(String path) {
        this.getPreferences().put(TESTER_PATH, path);
    }

    @CheckForNull
    public String getPhpIniPath() {
        return this.getPreferences().get(PHP_INI_PATH, null);
    }

    public void setPhpIniPath(String path) {
        this.getPreferences().put(PHP_INI_PATH, path);
    }

    @CheckForNull
    public String getBinaryExecutable() {
        return this.getPreferences().get(BINARY_EXECUTABLE, null);
    }

    public void setBinaryExecutable(@NullAllowed String binaryExecutable) {
        if (binaryExecutable == null) {
            this.getPreferences().remove(BINARY_EXECUTABLE);
        } else {
            this.getPreferences().put(BINARY_EXECUTABLE, binaryExecutable);
        }
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(TesterOptions.class).node(PREFERENCES_PATH);
    }
}

