/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;

class ProfilerTableHover {
    private static final boolean REPAINT_ON_HIDE = !Boolean.getBoolean("ProfilerTableHover.noRepaintOnHide");
    private final ProfilerTable table;
    private Popup popup;
    private Point popupLocation;
    private Rectangle popupRect;
    private AWT awt;
    private Mouse mouse;
    private Paranoid paranoid;
    private Point currentPoint;
    private Point forwardPoint;
    private static CellRendererPane PAINTER;

    static void install(ProfilerTable table) {
        new ProfilerTableHover(table).install();
    }

    private ProfilerTableHover(ProfilerTable table) {
        this.table = table;
    }

    private void install() {
        this.mouse = new Mouse();
        this.mouse.install();
    }

    private void showPopup(Painter p, Rectangle rect) {
        this.mouse.deinstall();
        Point l = this.table.getLocationOnScreen();
        rect.translate(l.x, l.y);
        this.popupRect = rect;
        this.popupLocation = new Point(l.x + p.getX(), l.y + p.getY());
        PopupFactory popupFactory = PopupFactory.getSharedInstance();
        this.popup = popupFactory.getPopup(this.table, p, this.popupLocation.x, this.popupLocation.y);
        this.popup.show();
        this.paranoid = new Paranoid(p);
        this.paranoid.install();
        this.awt = new AWT();
        this.awt.install();
    }

    private void hidePopup() {
        if (this.awt != null) {
            this.awt.deinstall();
            this.awt = null;
        }
        if (this.paranoid != null) {
            this.paranoid.deinstall();
            this.paranoid = null;
        }
        this.popup.hide();
        this.popupRect = null;
        this.popupLocation = null;
        this.popup = null;
        if (REPAINT_ON_HIDE) {
            this.table.repaint();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProfilerTableHover.this.mouse.install();
            }
        });
    }

    private void checkPopup(int row, int column, Point point) {
        if (row < 0 || row >= this.table.getRowCount()) {
            return;
        }
        if (column < 0 || column >= this.table.getColumnCount()) {
            return;
        }
        if (point == null) {
            point = this.currentPoint;
        } else {
            this.currentPoint = point;
        }
        if (point == null) {
            return;
        }
        Rectangle cellRect = this.table.getCellRect(row, column, true);
        Rectangle rendererRect = this.getRendererRect(row, column);
        if (rendererRect == null) {
            return;
        }
        rendererRect.translate(cellRect.x, cellRect.y);
        if (cellRect.contains(rendererRect)) {
            return;
        }
        Rectangle visibleRect = cellRect.intersection(rendererRect);
        if (visibleRect.contains(point)) {
            this.showPopup(new Painter(row, column, rendererRect), visibleRect);
        }
    }

    private Rectangle getRendererRect(int row, int column) {
        Component component = this.getRenderer(row, column);
        if (component instanceof JComponent && ((JComponent)component).getClientProperty("ProfilerTableHover_NoHover") != null) {
            return null;
        }
        Rectangle bounds = component.getBounds();
        bounds.x -= this.table.getColumnOffset(this.table.convertColumnIndexToModel(column));
        return bounds;
    }

    private Component getRenderer(int row, int column) {
        TableCellRenderer renderer = this.table.getCellRenderer(row, column);
        return this.table.getRenderer(renderer, row, column, true);
    }

    private static CellRendererPane getPainter() {
        if (PAINTER == null) {
            PAINTER = new CellRendererPane(){

                @Override
                public void paintComponent(Graphics g, Component c, Container p, int x, int y, int w, int h, boolean shouldValidate) {
                    super.paintComponent(g, c, p, x, y, w, h, shouldValidate);
                    this.remove(c);
                }
            };
        }
        return PAINTER;
    }

    private class Mouse
    extends MouseAdapter {
        private Mouse() {
        }

        void install() {
            ProfilerTableHover.this.table.addMouseMotionListener(this);
        }

        void deinstall() {
            ProfilerTableHover.this.table.removeMouseMotionListener(this);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (e.getModifiers() != 0) {
                return;
            }
            Point point = e.getPoint();
            if (point.equals(ProfilerTableHover.this.forwardPoint)) {
                return;
            }
            ProfilerTableHover.this.checkPopup(ProfilerTableHover.this.table.rowAtPoint(point), ProfilerTableHover.this.table.columnAtPoint(point), point);
        }
    }

    private class Painter
    extends JPanel {
        private final int row;
        private final int column;
        private final Object value;
        private final TableCellRenderer renderer;

        Painter(int row, int column, Rectangle bounds) {
            super(null);
            this.row = row;
            this.column = column;
            this.value = ProfilerTableHover.this.table.getValueAt(row, column);
            this.renderer = ProfilerTableHover.this.table.getCellRenderer(row, column);
            this.setBorder(BorderFactory.createLineBorder(ProfilerTableHover.this.table.getGridColor()));
            this.setBounds(bounds.x - 1, bounds.y - 1, bounds.width + 2, bounds.height + 2);
            this.setPreferredSize(this.getSize());
        }

        @Override
        protected void paintComponent(Graphics g) {
            Component x = ProfilerTableHover.this.table.getRenderer(this.renderer, this.row, this.column, false);
            ProfilerTableHover.getPainter().paintComponent(g, x, null, 1, 1, this.getWidth() - 2, this.getHeight() - 2, false);
        }

        int getRow() {
            return this.row;
        }

        int getColumn() {
            return this.column;
        }

        boolean valueChanged() {
            if (ProfilerTableHover.this.table.getRowCount() <= this.row) {
                return true;
            }
            if (ProfilerTableHover.this.table.getColumnCount() <= this.column) {
                return true;
            }
            Object v = ProfilerTableHover.this.table.getValueAt(this.row, this.column);
            if (v == null && this.value == null) {
                return false;
            }
            if (v != null && this.value != null) {
                return !v.equals(this.value);
            }
            return true;
        }
    }

    private class Paranoid
    implements TableModelListener,
    KeyListener,
    ComponentListener,
    HierarchyListener,
    HierarchyBoundsListener,
    FocusListener,
    PropertyChangeListener {
        private final Painter painter;
        private Component focusOwner;

        Paranoid(Painter painter) {
            this.painter = painter;
        }

        void install() {
            this.focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (this.focusOwner != null) {
                this.focusOwner.addKeyListener(this);
                if (ProfilerTableHover.this.table.equals(this.focusOwner)) {
                    ProfilerTableHover.this.table.addFocusListener(this);
                }
            }
            ProfilerTableHover.this.table.getModel().addTableModelListener(this);
            ProfilerTableHover.this.table.addComponentListener(this);
            ProfilerTableHover.this.table.addHierarchyListener(this);
            ProfilerTableHover.this.table.addHierarchyBoundsListener(this);
        }

        void deinstall() {
            if (this.focusOwner != null) {
                this.focusOwner.removeKeyListener(this);
                if (ProfilerTableHover.this.table.equals(this.focusOwner)) {
                    ProfilerTableHover.this.table.removeFocusListener(this);
                }
                this.focusOwner = null;
            }
            ProfilerTableHover.this.table.getModel().removeTableModelListener(this);
            ProfilerTableHover.this.table.removeComponentListener(this);
            ProfilerTableHover.this.table.removeHierarchyListener(this);
            ProfilerTableHover.this.table.removeHierarchyBoundsListener(this);
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (this.painter.valueChanged()) {
                final int row = this.painter.getRow();
                final int column = this.painter.getColumn();
                ProfilerTableHover.this.hidePopup();
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ Paranoid this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        this.this$1.ProfilerTableHover.this.checkPopup(row, column, null);
                    }
                });
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            ProfilerTableHover.this.hidePopup();
        }

        @Override
        public void keyPressed(KeyEvent e) {
            ProfilerTableHover.this.hidePopup();
        }

        @Override
        public void keyReleased(KeyEvent e) {
            ProfilerTableHover.this.hidePopup();
        }

        @Override
        public void componentResized(ComponentEvent e) {
            ProfilerTableHover.this.hidePopup();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            ProfilerTableHover.this.hidePopup();
        }

        @Override
        public void componentShown(ComponentEvent e) {
            ProfilerTableHover.this.hidePopup();
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            ProfilerTableHover.this.hidePopup();
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            ProfilerTableHover.this.hidePopup();
        }

        @Override
        public void ancestorMoved(HierarchyEvent e) {
            ProfilerTableHover.this.hidePopup();
        }

        @Override
        public void ancestorResized(HierarchyEvent e) {
            ProfilerTableHover.this.hidePopup();
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            ProfilerTableHover.this.hidePopup();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ProfilerTableHover.this.hidePopup();
        }
    }

    private class AWT
    implements AWTEventListener {
        private AWT() {
        }

        void install() {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 16L);
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 32L);
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 131072L);
        }

        void deinstall() {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }

        @Override
        public void eventDispatched(AWTEvent e) {
            if (ProfilerTableHover.this.popup == null) {
                return;
            }
            if (!(e instanceof MouseEvent)) {
                return;
            }
            MouseEvent me = (MouseEvent)e;
            if (this.isIgnoreEvent(me)) {
                return;
            }
            if (me.getID() == 503 && this.overPopup(me)) {
                return;
            }
            if (!this.overPopup(me)) {
                ProfilerTableHover.this.hidePopup();
            } else if (this.isForwardEvent(me)) {
                Point popupPoint = ProfilerTableHover.this.popupLocation;
                ProfilerTableHover.this.hidePopup();
                this.forwardEvent(me, popupPoint);
            }
        }

        private boolean overPopup(MouseEvent e) {
            if (ProfilerTableHover.this.popupRect == null) {
                return false;
            }
            Point p = e.getPoint();
            SwingUtilities.convertPointToScreen(p, e.getComponent());
            return ProfilerTableHover.this.popupRect.contains(p);
        }

        private boolean isIgnoreEvent(MouseEvent e) {
            int eventID = e.getID();
            return eventID == 504 || eventID == 505;
        }

        private boolean isForwardEvent(MouseEvent e) {
            int eventID = e.getID();
            return eventID == 501 || eventID == 502 || eventID == 507;
        }

        private void forwardEvent(MouseEvent e, Point popupPoint) {
            Point p = e.getPoint();
            p.translate(popupPoint.x, popupPoint.y);
            SwingUtilities.convertPointFromScreen(p, ProfilerTableHover.this.table);
            ProfilerTableHover.this.forwardPoint = new Point(p.x - 1, p.y - 1);
            MouseWheelEvent we = e instanceof MouseWheelEvent ? (MouseWheelEvent)e : null;
            MouseEvent ee = we != null ? new MouseWheelEvent((Component)ProfilerTableHover.this.table, e.getID(), e.getWhen(), e.getModifiers(), p.x, p.y, e.getClickCount(), e.isPopupTrigger(), we.getScrollType(), we.getScrollAmount(), we.getWheelRotation()) : new MouseEvent(ProfilerTableHover.this.table, e.getID(), e.getWhen(), e.getModifiers(), p.x, p.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
            ProfilerTableHover.this.table.dispatchEvent(ee);
            if (e.getID() == 501) {
                ee = new MouseEvent(ProfilerTableHover.this.table, 502, e.getWhen() + 1L, e.getModifiers(), p.x, p.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
                ProfilerTableHover.this.table.dispatchEvent(ee);
            }
        }
    }
}

