/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components.treetable;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.JTableHeader;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.components.JTreeTable;

public class JTreeTablePanel
extends JPanel {
    CustomTreeTableViewport treeTableViewport;
    protected JPanel scrollBarPanel;
    protected JScrollBar scrollBar;
    protected JScrollPane treeTableScrollPane;
    protected JTreeTable treeTable;
    private int invisibleRowsCount = -1;

    public JTreeTablePanel(JTreeTable treeTable) {
        super(new BorderLayout());
        this.treeTable = treeTable;
        this.initComponents();
        this.hookHeaderColumnResize();
        this.hookScrollBarValueChange();
        this.hookTreeCollapsedExpanded();
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L && JTreeTablePanel.this.isShowing()) {
                    JTreeTablePanel.this.updateScrollBar(true);
                }
            }
        });
    }

    public void clearBorders() {
        this.treeTableScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.treeTableScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
    }

    public void setCorner(String key, Component corner) {
        this.treeTableScrollPane.setCorner(key, corner);
    }

    public JScrollPane getScrollPane() {
        return this.treeTableScrollPane;
    }

    private void hookHeaderColumnResize() {
        this.treeTable.getTableHeader().getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
                JTreeTablePanel.this.treeTableViewport.repaint();
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
                JTreeTablePanel.this.treeTableViewport.repaint();
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
                JTreeTablePanel.this.treeTableViewport.repaint();
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
                JTreeTablePanel.this.treeTableViewport.repaint();
                JTreeTablePanel.this.updateScrollBar(true);
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
    }

    private void hookScrollBarValueChange() {
        this.scrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(final AdjustmentEvent e) {
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        this.this$1.JTreeTablePanel.this.treeTable.setTreeCellOffsetX(e.getValue());
                        if (!e.getValueIsAdjusting()) {
                            this.this$1.JTreeTablePanel.this.updateScrollBar(false);
                        }
                    }
                });
            }
        });
    }

    private void hookTreeCollapsedExpanded() {
        this.treeTable.getTree().addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                this.updateSB();
            }

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                this.updateSB();
            }

            private void updateSB() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JTreeTablePanel.this.updateScrollBar(false);
                    }
                });
            }
        });
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createEmptyBorder());
        this.treeTableScrollPane = new JScrollPane(22, 31);
        this.treeTableViewport = new CustomTreeTableViewport(this.treeTable);
        this.treeTableScrollPane.setViewport(this.treeTableViewport);
        final JScrollBar vScrollBar = this.treeTableScrollPane.getVerticalScrollBar();
        vScrollBar.getModel().addChangeListener(new ChangeListener(){
            final /* synthetic */ JTreeTablePanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                Component c = this.this$0.treeTableViewport.getView();
                vScrollBar.setEnabled(this.this$0.isEnabled() && vScrollBar.getVisibleAmount() < vScrollBar.getMaximum());
            }
        });
        vScrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (!e.getValueIsAdjusting()) {
                    JTreeTablePanel.this.updateScrollBar(false);
                }
            }
        });
        this.scrollBar = new JScrollBar(0);
        this.scrollBar.setUnitIncrement(10);
        this.scrollBarPanel = new JPanel(new BorderLayout());
        this.scrollBarPanel.add((Component)this.scrollBar, "West");
        this.treeTable.setTreeCellOffsetX(0);
        this.scrollBarPanel.setVisible(false);
        this.scrollBar.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                JTreeTablePanel.scroll(JTreeTablePanel.this.scrollBar, e);
            }
        });
        MouseWheelListener[] listeners = this.treeTableScrollPane.getMouseWheelListeners();
        if (listeners != null && listeners.length == 1) {
            final MouseWheelListener listener = listeners[0];
            this.treeTableScrollPane.removeMouseWheelListener(listener);
            this.treeTableScrollPane.addMouseWheelListener(new MouseWheelListener(){
                final /* synthetic */ JTreeTablePanel this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                    if (JTreeTablePanel.onlyShift(e) && this.this$0.treeTable.columnAtPoint(e.getPoint()) == 0) {
                        JTreeTablePanel.scroll(this.this$0.scrollBar, e);
                    } else {
                        listener.mouseWheelMoved(e);
                    }
                    this.this$0.treeTable.mouseWheelMoved(e);
                }
            });
        }
        this.add((Component)this.treeTableScrollPane, "Center");
        this.add((Component)this.scrollBarPanel, "South");
    }

    private static void scroll(JScrollBar scroller, MouseWheelEvent event) {
        if (event.getScrollType() == 0) {
            int direction;
            int unitsToScroll = event.getUnitsToScroll();
            int n = direction = unitsToScroll < 0 ? -1 : 1;
            if (unitsToScroll != 0) {
                int increment = scroller.getUnitIncrement(direction);
                int oldValue = scroller.getValue();
                int newValue = oldValue + increment * unitsToScroll;
                if (oldValue != (newValue = Math.max(Math.min(newValue, scroller.getMaximum() - scroller.getVisibleAmount()), scroller.getMinimum()))) {
                    scroller.setValue(newValue);
                }
            }
            event.consume();
        }
    }

    private static boolean onlyShift(MouseEvent e) {
        return e.isShiftDown() && !e.isAltDown() && !e.isAltGraphDown() && !e.isControlDown() && !e.isMetaDown();
    }

    private void updateScrollBar(boolean updateWidth) {
        int lastInvisibleRow;
        int firstInvisibleRow;
        if (!this.isShowing()) {
            return;
        }
        boolean refreshScrollBar = false;
        JTree tree = this.treeTable.getTree();
        Point viewPos = this.treeTableViewport.getViewPosition();
        int viewHeight = this.treeTableViewport.getHeight();
        TreePath firstVisiblePath = tree.getClosestPathForLocation(viewPos.x, viewPos.y);
        TreePath lastVisiblePath = tree.getClosestPathForLocation(viewPos.x, viewPos.y + viewHeight - 1);
        int firstVisibleRow = tree.getRowForPath(firstVisiblePath);
        int lastVisibleRow = tree.getRowForPath(lastVisiblePath);
        if (firstVisibleRow < 0) {
            return;
        }
        Rectangle size = new Rectangle();
        for (int row = firstVisibleRow; row <= lastVisibleRow; ++row) {
            size.add(tree.getRowBounds(row));
        }
        int treeWidth = size.width + 3;
        int columnWidth = this.treeTable.getColumnModel().getColumn(0).getWidth();
        int treeOffset = this.treeTable.getTreeCellOffsetX();
        int maximum = Math.max(treeWidth - columnWidth, treeOffset);
        if (this.scrollBarPanel.isVisible() && maximum <= 0 && (firstInvisibleRow = lastVisibleRow + 1) <= (lastInvisibleRow = Math.min(lastVisibleRow + this.getInvisibleRowsCount(), this.treeTable.getRowCount() - 1))) {
            size = new Rectangle();
            for (int row = firstInvisibleRow; row <= lastInvisibleRow; ++row) {
                size.add(tree.getRowBounds(row));
            }
            size.width += 3;
            int maximum2 = Math.max(size.width - columnWidth, treeOffset);
            if (maximum2 > 0) {
                treeWidth = size.width;
                maximum = maximum2;
            }
        }
        if (maximum <= 0) {
            if (this.scrollBarPanel.isVisible()) {
                this.treeTable.setTreeCellOffsetX(0);
                this.scrollBarPanel.setVisible(false);
                refreshScrollBar = true;
            }
        } else {
            int value = treeOffset;
            int extent = treeWidth;
            if (!this.scrollBarPanel.isVisible()) {
                this.scrollBarPanel.setVisible(true);
                refreshScrollBar = true;
            }
            this.scrollBar.setValues(value, extent, 0, maximum + extent);
        }
        if (updateWidth) {
            Dimension dim = this.scrollBar.getPreferredSize();
            dim.width = this.treeTable.getColumnModel().getColumn(0).getWidth();
            this.scrollBar.setPreferredSize(dim);
            this.scrollBar.setBlockIncrement((int)((float)this.scrollBar.getModel().getExtent() * 0.95f));
            refreshScrollBar = true;
        }
        if (refreshScrollBar) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JTreeTablePanel.this.scrollBar.invalidate();
                    JTreeTablePanel.this.validate();
                    JTreeTablePanel.this.repaint();
                }
            });
        }
    }

    private int getInvisibleRowsCount() {
        if (this.invisibleRowsCount == -1) {
            this.invisibleRowsCount = (int)Math.ceil((float)this.scrollBar.getPreferredSize().height / (float)this.treeTable.getRowHeight());
        }
        return this.invisibleRowsCount;
    }

    private static class CustomTreeTableViewport
    extends JViewport {
        private JTableHeader tableHeader;

        public CustomTreeTableViewport(JTreeTable treeTable) {
            this.setView(treeTable);
            this.setBackground(treeTable.getBackground());
            this.tableHeader = treeTable.getTableHeader();
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            this.paintVerticalLines(g);
        }

        private void paintVerticalLines(Graphics g) {
            Component view = this.getView();
            int linesTop = view == null ? 0 : view.getHeight();
            int linesBottom = this.getHeight() - 1;
            if (linesTop > 0 && linesTop <= linesBottom) {
                g.setColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
                int columnCount = this.tableHeader.getColumnModel().getColumnCount();
                for (int i = 0; i < columnCount; ++i) {
                    Rectangle cellRect = this.tableHeader.getHeaderRect(i);
                    int cellX = cellRect.x + cellRect.width - 1;
                    g.drawLine(cellX, linesTop, cellX, linesBottom);
                }
            }
        }
    }
}

