/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.lock;

import java.io.File;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.lock.LockParams;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class LockAction
extends ContextAction {
    private static final Logger LOG = Logger.getLogger(LockAction.class.getName());

    @Override
    protected int getDirectoryEnabledStatus() {
        return 0;
    }

    @Override
    protected int getFileEnabledStatus() {
        return 86008;
    }

    @Override
    protected String getBaseName(Node[] activatedNodes) {
        return "CTL_Lock_Title";
    }

    @Override
    protected boolean enable(Node[] nodes) {
        if (super.enable(nodes)) {
            Context ctx = this.getCachedContext(nodes);
            FileStatusCache cache = Subversion.getInstance().getStatusCache();
            for (File f : ctx.getFiles()) {
                FileInformation status = cache.getCachedStatus(f);
                if (status != null && (status.getStatus() & 0x2000) != 0) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        Context ctx = this.getContext(nodes);
        File[] roots = ctx.getFiles();
        LinkedList<File> unlocked = new LinkedList<File>();
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        for (File f : roots) {
            FileInformation status = cache.getStatus(f);
            if ((status.getStatus() & 0x2000) != 0) continue;
            unlocked.add(f);
        }
        if (unlocked.isEmpty()) {
            return;
        }
        final LockParams lock = new LockParams(cache.containsFiles(new HashSet<File>(unlocked), 32768, true));
        if (lock.show()) {
            SVNUrl url;
            final File[] files = unlocked.toArray(new File[0]);
            try {
                url = SvnUtils.getRepositoryRootUrl(files[0]);
            }
            catch (SVNClientException ex) {
                LOG.log(Level.INFO, "No url for {0}", files[0]);
                return;
            }
            new SvnProgressSupport(this){
                final /* synthetic */ LockAction this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                protected void perform() {
                    try {
                        boolean cont;
                        SvnClient client = Subversion.getInstance().getClient(url, (SvnProgressSupport)this);
                        HashMap<File, String> relativePaths = new HashMap<File, String>(files.length);
                        for (File f : files) {
                            String path = SvnUtils.getRelativePath(f);
                            if (path == null) continue;
                            relativePaths.put(f, path);
                        }
                        boolean force = lock.isForce();
                        String msg = lock.getLockMessage();
                        do {
                            LockedFilesListener list;
                            cont = false;
                            boolean resumeAuth = true;
                            do {
                                list = new LockedFilesListener(relativePaths);
                                client.addNotifyListener(list);
                                client.lock(files, msg, force);
                                if (!list.isAuthError() || !(resumeAuth = SvnClientExceptionHandler.handleAuth(url))) break;
                                client.removeNotifyListener(list);
                                client = Subversion.getInstance().getClient(url, (SvnProgressSupport)this);
                            } while (resumeAuth);
                            if (!resumeAuth) break;
                            client.removeNotifyListener(list);
                            if (force || list.lockedFiles.isEmpty() || this.lockedByOther(client, list.lockedFiles).isEmpty()) continue;
                            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(LockAction.class, (String)"MSG_LockAction.lockedFiles.description"), NbBundle.getMessage(LockAction.class, (String)"MSG_LockAction.lockedFiles.title"), 0, 2);
                            if (NotifyDescriptor.YES_OPTION != DialogDisplayer.getDefault().notify((NotifyDescriptor)nd)) continue;
                            force = true;
                            cont = true;
                        } while (cont);
                        Subversion.getInstance().getStatusCache().refreshAsync(files);
                    }
                    catch (SVNClientException ex) {
                        SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, false);
                    }
                }

                private Collection<File> lockedByOther(SvnClient client, Set<File> lockedFiles) throws SVNClientException {
                    ISVNStatus[] statuses;
                    LinkedList<File> lockedByOtherFiles = new LinkedList<File>();
                    for (ISVNStatus status : statuses = client.getStatus(lockedFiles.toArray(new File[0]))) {
                        if (status.getLockOwner() != null) continue;
                        lockedByOtherFiles.add(status.getFile());
                    }
                    return lockedByOtherFiles;
                }
            }.start(Subversion.getInstance().getRequestProcessor(url), url, NbBundle.getMessage(LockAction.class, (String)"LBL_Lock_Progress"));
        }
    }

    private static class LockedFilesListener
    implements ISVNNotifyListener {
        private String msg;
        private final Map<File, String> relativePaths;
        private final Set<File> lockedFiles = new HashSet<File>();
        private boolean authError;

        public LockedFilesListener(Map<File, String> relativePaths) {
            this.relativePaths = relativePaths;
        }

        public void setCommand(int i) {
        }

        public void logCommandLine(String string) {
        }

        public void logMessage(String string) {
        }

        public void logError(String error) {
            if (error != null) {
                if (error.contains("is already locked")) {
                    this.msg = error;
                } else if (SvnClientExceptionHandler.isAuthentication(error)) {
                    this.authError = true;
                }
            }
        }

        public void logRevision(long l, String string) {
        }

        public void logCompleted(String string) {
        }

        public void onNotify(File file, SVNNodeKind svnnk) {
            String relPath;
            if (this.msg != null && (relPath = this.relativePaths.get(file)) != null && this.msg.contains(MessageFormat.format("Path ''{0}'' is already locked", relPath))) {
                this.lockedFiles.add(file);
            }
        }

        private boolean isAuthError() {
            return this.authError;
        }
    }
}

