/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.SingleSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.multitabs.TabDisplayer;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;

public final class Controller
implements MouseListener {
    private List<ActionListener> actionListenerList;
    private final SingleSelectionModel selectionModel = new DefaultSingleSelectionModel();
    private final TabDataModel tabModel;
    private final TabDisplayer displayer;

    public Controller(final TabDisplayer displayer) {
        this.displayer = displayer;
        this.tabModel = displayer.getModel();
        displayer.attach(this);
        this.selectionModel.addChangeListener(new ChangeListener(){
            final /* synthetic */ Controller this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                displayer.setSelectedIndex(this.this$0.getSelectedIndex());
            }
        });
    }

    SingleSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public TabDataModel getTabModel() {
        return this.tabModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addActionListener(ActionListener al) {
        Controller controller = this;
        synchronized (controller) {
            if (this.actionListenerList == null) {
                this.actionListenerList = new ArrayList<ActionListener>(5);
            }
            this.actionListenerList.add(al);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeActionListener(ActionListener al) {
        Controller controller = this;
        synchronized (controller) {
            if (this.actionListenerList != null) {
                this.actionListenerList.remove(al);
                if (this.actionListenerList.isEmpty()) {
                    this.actionListenerList = null;
                }
            }
        }
    }

    public void addSelectionChangeListener(ChangeListener listener) {
        this.selectionModel.addChangeListener(listener);
    }

    public void removeSelectionChangeListener(ChangeListener listener) {
        this.selectionModel.removeChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postActionEvent(TabActionEvent event) {
        List<ActionListener> list;
        Controller controller = this;
        synchronized (controller) {
            if (this.actionListenerList == null) {
                return;
            }
            list = Collections.unmodifiableList(this.actionListenerList);
        }
        for (ActionListener l : list) {
            l.actionPerformed((ActionEvent)event);
        }
    }

    public void setSelectedIndex(int index) {
        this.selectionModel.setSelectedIndex(index);
    }

    public int getSelectedIndex() {
        return this.selectionModel.getSelectedIndex();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Point p = e.getPoint();
        p = SwingUtilities.convertPoint(e.getComponent(), p, this.displayer);
        TabData tab = this.displayer.getTabAt(p);
        if (null == tab) {
            return;
        }
        int tabIndex = this.tabModel.indexOf(tab);
        if (e.getClickCount() > 1 && e.getButton() == 1) {
            TabActionEvent tae = new TabActionEvent((Object)this.displayer, "maximize", tabIndex);
            this.postActionEvent(tae);
        } else if (e.getButton() == 2) {
            TabActionEvent tae = new TabActionEvent((Object)this.displayer, "close", tabIndex);
            this.postActionEvent(tae);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void maybeShowPopup(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            return;
        }
        Point p = e.getPoint();
        p = SwingUtilities.convertPoint(e.getComponent(), p, this.displayer);
        TabData tab = this.displayer.getTabAt(p);
        if (null == tab) {
            return;
        }
        int tabIndex = this.tabModel.indexOf(tab);
        TabActionEvent tae = new TabActionEvent((Object)this, "popup", tabIndex, e);
        this.postActionEvent(tae);
    }
}

