/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.properties.propertymap;

import net.infonode.properties.base.Property;
import net.infonode.properties.base.exception.CantRemoveValueException;
import net.infonode.properties.propertymap.PropertyMapImpl;
import net.infonode.properties.propertymap.value.PropertyValue;
import net.infonode.properties.propertymap.value.SimplePropertyValue;
import net.infonode.properties.types.PropertyGroupProperty;
import net.infonode.properties.util.PropertyValueHandler;

public class PropertyMapValueHandler
implements PropertyValueHandler {
    public static final PropertyMapValueHandler INSTANCE = new PropertyMapValueHandler();

    private PropertyMapValueHandler() {
    }

    @Override
    public Object getValue(Property property, Object object) {
        PropertyMapImpl propertyMap = (PropertyMapImpl)object;
        PropertyValue value = propertyMap.getValueWithDefault(property);
        return value == null ? null : value.getWithDefault(propertyMap);
    }

    @Override
    public void setValue(Property property, Object object, Object value) {
        ((PropertyMapImpl)object).setValue(property, new SimplePropertyValue(value));
    }

    @Override
    public boolean getValueIsRemovable(Property property, Object object) {
        return !(property instanceof PropertyGroupProperty);
    }

    @Override
    public void removeValue(Property property, Object object) {
        if (property instanceof PropertyGroupProperty) {
            throw new CantRemoveValueException(property);
        }
        ((PropertyMapImpl)object).removeValue(property);
    }

    @Override
    public boolean getValueIsSet(Property property, Object object) {
        return property instanceof PropertyGroupProperty || ((PropertyMapImpl)object).valueIsSet(property);
    }
}

