/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

geodesic gray scale erosion of an image


Geodesic erosion operates on a "marker" image and a "mask" image.
The marker image is eroded using an elementary structuring element
(neighborhood of radius one using only the face connected neighbors).
The resulting image is then compared with the mask image. The output
image is the pixelwise maximum of the eroded marker image and the mask
image.

Geodesic erosion is run either one iteration or until convergence. In
the convergence case, the filter is equivalent to "reconstruction by
erosion". This filter is implemented to handle both scenarios. The
one iteration case is multi-threaded. The convergence case is
delegated to another instance of the same filter (but configured to
run a single iteration).

The marker image must be greater than or equal to the mask image (on a
pixel by pixel basis).

Geodesic morphology is described in Chapter 6 of Pierre Soille's book
"Morphological Image Analysis: Principles and Applications", Second
Edition, Springer, 2003.

A noniterative version of this algorithm can be found in the ReconstructionByErosionImageFilter . This noniterative solution is much faster than the implementation
provided here. All ITK filters that previously used GrayscaleGeodesicErodeImageFilter as part of their implementation have been converted to use the ReconstructionByErosionImageFilter . The GrayscaleGeodesicErodeImageFilter is maintained for backward compatibility.


See:
 MorphologyImageFilter , GrayscaleErodeImageFilter , GrayscaleFunctionErodeImageFilter , BinaryErodeImageFilter , ReconstructionByErosionImageFilter

 itk::simple::GrayscaleGeodesicErode for the procedural interface

 itk::GrayscaleGeodesicErodeImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkGrayscaleGeodesicErodeImageFilter.h
*/
public class GrayscaleGeodesicErodeImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected GrayscaleGeodesicErodeImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.GrayscaleGeodesicErodeImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(GrayscaleGeodesicErodeImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(GrayscaleGeodesicErodeImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::GrayscaleGeodesicErodeImageFilter::~GrayscaleGeodesicErodeImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_GrayscaleGeodesicErodeImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::GrayscaleGeodesicErodeImageFilter::GrayscaleGeodesicErodeImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  GrayscaleGeodesicErodeImageFilter() {
    this(SimpleITKJNI.new_GrayscaleGeodesicErodeImageFilter(), true);
  }

  /**
Self&amp; itk::simple::GrayscaleGeodesicErodeImageFilter::SetRunOneIteration(bool RunOneIteration)

Set/Get whether the filter should run one iteration or until
convergence. When run to convergence, this filter is equivalent to
"reconstruction by erosion". Default is off.

*/
public  void setRunOneIteration(boolean RunOneIteration) {
    SimpleITKJNI.GrayscaleGeodesicErodeImageFilter_setRunOneIteration(swigCPtr, this, RunOneIteration);
  }

  /**
Self&amp; itk::simple::GrayscaleGeodesicErodeImageFilter::RunOneIterationOn()

Set the value of RunOneIteration to true or false respectfully.

*/
public  void runOneIterationOn() {
    SimpleITKJNI.GrayscaleGeodesicErodeImageFilter_runOneIterationOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::GrayscaleGeodesicErodeImageFilter::RunOneIterationOff()
*/
public  void runOneIterationOff() {
    SimpleITKJNI.GrayscaleGeodesicErodeImageFilter_runOneIterationOff(swigCPtr, this);
  }

  /**
bool itk::simple::GrayscaleGeodesicErodeImageFilter::GetRunOneIteration() const

Set/Get whether the filter should run one iteration or until
convergence. When run to convergence, this filter is equivalent to
"reconstruction by erosion". Default is off.

*/
public  boolean getRunOneIteration() {
    return SimpleITKJNI.GrayscaleGeodesicErodeImageFilter_getRunOneIteration(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::GrayscaleGeodesicErodeImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  void setFullyConnected(boolean FullyConnected) {
    SimpleITKJNI.GrayscaleGeodesicErodeImageFilter_setFullyConnected(swigCPtr, this, FullyConnected);
  }

  /**
Self&amp; itk::simple::GrayscaleGeodesicErodeImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public  void fullyConnectedOn() {
    SimpleITKJNI.GrayscaleGeodesicErodeImageFilter_fullyConnectedOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::GrayscaleGeodesicErodeImageFilter::FullyConnectedOff()
*/
public  void fullyConnectedOff() {
    SimpleITKJNI.GrayscaleGeodesicErodeImageFilter_fullyConnectedOff(swigCPtr, this);
  }

  /**
bool itk::simple::GrayscaleGeodesicErodeImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  boolean getFullyConnected() {
    return SimpleITKJNI.GrayscaleGeodesicErodeImageFilter_getFullyConnected(swigCPtr, this);
  }

  /**
std::string itk::simple::GrayscaleGeodesicErodeImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.GrayscaleGeodesicErodeImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::GrayscaleGeodesicErodeImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.GrayscaleGeodesicErodeImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::GrayscaleGeodesicErodeImageFilter::Execute(const Image &amp;image1, const Image &amp;image2)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2) {
    return new Image(SimpleITKJNI.GrayscaleGeodesicErodeImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

}
