/***************************************************************************
                          kbeardiroperator.cpp  -  description
                             -------------------
    begin                : Mon Jun 26 2000
    copyright            : (C) 2000 by Bjrn Sahlstrm
    email                : bjorn.sahlstrom@mail.bip.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "kbeardiroperator.h"
#include "kbearftpview.h"
#include "kbearfileiconview.h"
#include "kbearfiledetailview.h"
#include "kbear.h"
#include <kopenwith.h>
#include <krun.h>
//-----------------------------------------------
KBearDirOperator::KBearDirOperator( KBearFtpView* ftpView, const KURL& url,
									 QWidget *parent, const char* name)
    : KDirOperator( url, parent, name),
    p_myFtpView(ftpView), homeURL( QDir::homeDirPath())
{
	myConfig = p_myFtpView->myApp()->config();
	connect( p_myFtpView->myApp(), SIGNAL(viewSettingsChanged( bool, bool, bool )),
						this, SLOT(slotViewSettingsChanged( bool, bool, bool ) ) );
	connect( fileReader(), SIGNAL( started( const QString& )), this, SLOT( slotListingStarted()));
	connect( this, SIGNAL( finishedLoading()), this, SLOT( slotListingCompleted()));
	
	setupExtraActions();
	setupActionMenus();
	readConfig( myConfig, "View Settings" );
//	setFocusPolicy( QWidget::ClickFocus );
}
//-----------------------------------------------
KBearDirOperator::~KBearDirOperator() {
}
//-----------------------------------------------
void KBearDirOperator::activatedMenu( const KFileViewItem* item ) {
	if( p_myFtpView->myApp()->isInTopLevelMode() )
		p_myFtpView->myApp()->slotSetActiveView( p_myFtpView );
	if ( item ) {
		activatedItem = (KFileViewItem*)item;
		// currently shred is only possible on local file system
		shredAction->setEnabled( fileReader()->url().isLocalFile() );
		// no reason to be able to select browse without an item
//		browserAction->setEnabled( true );
		openAction->setEnabled( true );
		openWithAction->setEnabled( true );
		fileActionMenu->popup( QCursor::pos() );
	}
	else {
		openAction->setEnabled( false );
		openWithAction->setEnabled( false );
//		browserAction->setEnabled( false );
		((KActionMenu*)actionCollection()->action("popupMenu"))->popup( QCursor::pos() );
	}
}
//-----------------------------------------------
void KBearDirOperator::rereadDir(){
	emit rereadDir( url().path( 1 ) );
	QApplication::sendPostedEvents();
	KDirOperator::rereadDir();
}
//-----------------------------------------------
void KBearDirOperator::slotHome() {
    setURL( homeURL, true);
}
//-----------------------------------------------
void KBearDirOperator::setHomeURL( const KURL& url ){
	homeURL = url;
}
//-----------------------------------------------
void KBearDirOperator::slotDelete(){
	QStringList strList;
	QList<KFileViewItem>* fileList = (QList<KFileViewItem>*)view()->selectedItems();
	for( unsigned int i = 0; i < fileList->count(); i++)
		strList << fileList->at( i )->urlString();

	int answer = KMessageBox::questionYesNoList( this,
						i18n("Do you really want to delete the file(s) ?"),
						strList, i18n("Delete") );
	if( answer == KMessageBox::Yes ) {
		KURL::List urlList( strList );
		KIO::DeleteJob* deleteJob = KIO::del( urlList, false, false );
		connect( deleteJob, SIGNAL( result( KIO::Job*) ), this, SLOT( slotDeleteFinished( KIO::Job* ) ) );
		p_myFtpView->slotStatusMsg( 0, i18n("Deleting file(s)") );
	}
}
//-----------------------------------------------
void KBearDirOperator::slotShred(){
	QStringList strList;
	QList<KFileViewItem>* fileList = (QList<KFileViewItem>*)view()->selectedItems();
	for( unsigned int i = 0; i < fileList->count(); i++)
		strList << fileList->at( i )->urlString();

	int answer = KMessageBox::questionYesNoList( this,
						i18n("Do you really want to delete the file(s) ?"),
						strList, i18n("Delete") );
	if( answer == KMessageBox::Yes ) {
		KURL::List urlList( strList );
		KIO::DeleteJob* shredJob = KIO::del( urlList, true, false );
		connect( shredJob, SIGNAL( result( KIO::Job*) ), this, SLOT( slotDeleteFinished( KIO::Job* ) ) );
		p_myFtpView->slotStatusMsg( 0, i18n("Shredding file(s)") );
	}
}
//-----------------------------------------------
void KBearDirOperator::slotDeleteFinished( KIO::Job* /*job*/ ){
	p_myFtpView->slotStatusMsg( 0, i18n( "No Operation in Progress" ) );
/*
	if ( job->error() ) // if KIO error
		job->showErrorDialog( this ); // display error message
	else
*/
//		rereadDir();
}
//-----------------------------------------------
void KBearDirOperator::slotProperties(){
	KPropertiesDialog* propDlg;
	propDlg = new KPropertiesDialog( activatedItem );
	connect( propDlg, SIGNAL( applied() ), this, SLOT(rereadDir() ) );
}
//-----------------------------------------------
void KBearDirOperator::stop(){
	fileReader()->stop();
	QTimer::singleShot(200, this, SLOT(resetCursor()));
	stopAction->setEnabled( false );
	emit finishedLoading();// stop wheel animation
}
//-----------------------------------------------
bool KBearDirOperator::setCurrentItem( const QString& fileName, bool caseSensitive ) {
	const KFileViewItem *item = 0L;
	((KFileView*)view())->clearSelection(); // clear selection so it will be cleared if no hit
	if ( fileName.isNull() ) // can't search for an empty string
		return false;
	// I assume no wildcards at first
	item = static_cast<KFileViewItem*>(fileReader()->findByName( fileName ));
	if( ! item ) { // if no item found whithout wildcards, check with wildcards here							
		QRegExp myRegExp( fileName, false, true );
		myRegExp.setCaseSensitive( caseSensitive );
		KFileViewItemList itemList = *( view()->items() );
		KFileViewItemListIterator it( itemList );
		for( ; (it.current());++it) {
			if( myRegExp.find( (*it)->name(), 0 ) != -1 ) {
				item = (*it);
				break;
			}		
		}
	}
	if ( item ) {// found!!!!
		KFileView* v = (KFileView*)view();
		v->setSelected( item, true );
		v->setCurrentItem( QString::null, item );
		v->ensureItemVisible( item );
		return true;
	}
	return false;
}
//-----------------------------------------------
void KBearDirOperator::setupExtraActions() {
	myConfig->setGroup("View Settings");

	//this is ugly, but I have to replace the old reloadAction so I can force an update of the treeview
	KAction* reloadAction = actionCollection()->action("reload");
	actionCollection()->remove( reloadAction );
	reloadAction = KStdAction::redisplay( this, SLOT( rereadDir() ), actionCollection(), "reload");
	reloadAction->setText( i18n("Reload") );
	//-------------------------------		
	myHomeAction = KStdAction::home( this, SLOT( slotHome() ), actionCollection(), "homeDir" );
	myHomeAction->setText(i18n("Home directory"));
	
	QIconSet iconSet( KGlobal::iconLoader()->loadIcon( "stop", KIcon::Small ), BarIcon("stop") );
	stopAction = new KAction( i18n("&Stop loading directory"), iconSet,0,
				 				this, SLOT( stop() ), actionCollection(), "stop" );
	stopAction->setEnabled( false );
	
	//these two actions are in an exclusive group
	detailedListAction = new KToggleAction( i18n("&Detailed listview"), QIconSet(BarIcon("view_detailed")),0,
				 				this, SLOT( slotSetDetailedListViewMode() ), actionCollection(), "detailed list" );
	detailedListAction->setExclusiveGroup( "viewGroup" );

	iconViewAction = new KToggleAction( i18n("&Icon view"), QIconSet(BarIcon("view_icon")),0,
				 				this, SLOT( slotSetIconViewMode() ), actionCollection(), "icon view" );
	iconViewAction->setExclusiveGroup( "viewGroup" );

	treeViewAction = new KToggleAction( i18n("Directory &tree"), QIconSet(BarIcon("view_tree")),0,
				 				this, SLOT( slotToggleTreeView() ), actionCollection(), "tree view"  );

	largeViewAction = new KToggleAction( i18n("&Large Icons"), 0,
				 				this, SLOT( slotViewLarge() ), actionCollection(), "large view"  );
	largeViewAction->setChecked( false );
	largeViewAction->setExclusiveGroup( "icon size" );

	mediumViewAction = new KToggleAction( i18n("&Medium Icons"), 0,
				 				this, SLOT( slotViewMedium() ), actionCollection(), "medium view"  );
	mediumViewAction->setChecked( true );
	mediumViewAction->setExclusiveGroup( "icon size" );

	smallViewAction = new KToggleAction( i18n("&Small Icons"), 0,
				 				this, SLOT( slotViewSmall() ), actionCollection(), "small view"  );
	smallViewAction->setChecked( false );
	smallViewAction->setExclusiveGroup( "icon size" );

	bottomTextAction = new KToggleAction( i18n("Text at the &bottom"), 0,
				 				this, SLOT( slotTextBottom() ), actionCollection(), "bottom text"  );
	bottomTextAction->setChecked( true );
	bottomTextAction->setExclusiveGroup( "icon text pos" );

	rightTextAction = new KToggleAction( i18n("Text at the &right"), 0,
				 				this, SLOT( slotTextRight() ), actionCollection(), "right text"  );
	rightTextAction->setChecked( false );
	rightTextAction->setExclusiveGroup( "icon text pos" );
	
	flowEastAction = new KToggleAction( i18n("Arrange l&eft to right"), 0,
				 				this, SLOT( slotFlowEast() ), actionCollection(), "left to right"  );
	flowEastAction->setChecked( true );
	flowEastAction->setExclusiveGroup( "icon flow" );

	flowSouthAction = new KToggleAction( i18n("Arrange t&op to bottom"), 0,
				 				this, SLOT( slotFlowSouth() ), actionCollection(), "top to bottom"  );
	flowSouthAction->setChecked( false );
	flowSouthAction->setExclusiveGroup( "icon flow" );
	
	truncateTextAction = new KToggleAction( i18n("&Truncate item text"), 0,
				 				this, SLOT( slotTextTruncate() ), actionCollection(), "truncate text"  );
	truncateTextAction->setChecked( true );
	truncateTextAction->setExclusiveGroup( "icon text length" );
	
	wordWrapTextAction = new KToggleAction( i18n("&Wordwrap item text"), 0,
				 				this, SLOT( slotTextWordWrap() ), actionCollection(), "wordwrap text"  );
	wordWrapTextAction->setChecked( false );
	wordWrapTextAction->setExclusiveGroup( "icon text length" );
	
	arrangeItemsAction = new KAction( i18n("Arrange items in &grid"), 0,
				 				this, SLOT( slotArrangeItemsInGrid() ), actionCollection(), "arrange items" );
	
	iconModeActionMenu = new KActionMenu( i18n("Icon &Mode..."), actionCollection(), "icon mode menu");
	
	//connect some actions with slots and signals
	connect( iconViewAction, SIGNAL( toggled(bool)), SLOT(slotToggleIconModeActionMenu()));
	connect( detailedListAction, SIGNAL( toggled(bool)), SLOT(slotToggleIconModeActionMenu()));
	connect( actionCollection()->action("show hidden"), SIGNAL( toggled(bool)), SIGNAL(showHidden( bool )));
	
	// Setup the FileActionMenu and it's action
	fileActionMenu = new KActionMenu( i18n("File Menu"), actionCollection(), "filePopupMenu" );
	deleteAction = new KAction( i18n("&Delete"), 0,
				 				this, SLOT( slotDelete() ), actionCollection(), "delete" );
	shredAction = new KAction( i18n("&Shred"), 0,
				 				this, SLOT( slotShred() ), actionCollection(), "shred" );
	propertiesAction = new KAction( i18n("&Properties"), 0,
				 				this, SLOT( slotProperties() ), actionCollection(), "file properties" );

	openAction = KStdAction::open( this, SLOT( slotOpen() ), actionCollection() , "open" );	
	openWithAction = new KAction( i18n("Open With..."), 0,
				 				this, SLOT( slotOpenWith() ), actionCollection(), "open with" );

	//Set Whats this text for the actions
	actionCollection()->action("up")->setWhatsThis( i18n("This button moves you up one step in the directory tree.") );
	actionCollection()->action("back")->setWhatsThis( i18n("This button moves you one step back in history list.") );
	actionCollection()->action("forward")->setWhatsThis( i18n("This button moves you one step forward in history list.") );
	reloadAction->setWhatsThis( i18n("This button reloads current directory.") );
	actionCollection()->action("mkdir")->setWhatsThis( i18n("This button creates a new directory in current directory.") );
	stopAction->setWhatsThis( i18n("This button stops loading the directory.") );
	detailedListAction->setWhatsThis( i18n("This button change the view to detailed list mode.") );
	iconViewAction->setWhatsThis( i18n("This button change the view to icon mode.") );
	treeViewAction->setWhatsThis( i18n("This button toggles the directory tree.") );
	myHomeAction->setWhatsThis( i18n("This button moves you to your home directory\n\n"
															"On a remote host this will be your start up directory.") );

    // insert them into the actionCollection
	actionCollection()->insert( reloadAction );
	actionCollection()->insert( stopAction );
	actionCollection()->insert( myHomeAction );
   actionCollection()->insert( detailedListAction );
	actionCollection()->insert( iconViewAction );
	actionCollection()->insert( treeViewAction );

	actionCollection()->insert( iconModeActionMenu );
	actionCollection()->insert( smallViewAction );
	actionCollection()->insert( mediumViewAction );
   actionCollection()->insert( largeViewAction );
	actionCollection()->insert( bottomTextAction );
	actionCollection()->insert( rightTextAction );
	actionCollection()->insert( flowEastAction );
	actionCollection()->insert( flowSouthAction );
	actionCollection()->insert( truncateTextAction );
	actionCollection()->insert( wordWrapTextAction );
	actionCollection()->insert( arrangeItemsAction );
	
	actionCollection()->insert( fileActionMenu );
	actionCollection()->insert( deleteAction );
	actionCollection()->insert( shredAction );
	actionCollection()->insert( propertiesAction );
	actionCollection()->insert( openAction );
	actionCollection()->insert( openWithAction );
}
//-----------------------------------------------

void KBearDirOperator::setupActionMenus() {
////////////////////////////////////////////////////////////
//	this is really ugly but I have to rebuild the menus, so what else can I do ????
	KAction* tmp = actionCollection()->action("detailed view");
	KActionMenu* viewMenu = (KActionMenu*)actionCollection()->action("view menu");
	viewMenu->remove( tmp );
	tmp = actionCollection()->action("short view");
	viewMenu->remove( tmp );
	tmp = actionCollection()->action("separator");
	viewMenu->remove( tmp );
	tmp = actionCollection()->action("separate dirs");
	viewMenu->remove( tmp );
	tmp = actionCollection()->action("show hidden");
	viewMenu->remove( tmp );
	KActionMenu* actMenu = (KActionMenu*)actionCollection()->action("popupMenu");
	tmp = actionCollection()->action("up");
	actMenu->remove( tmp );
	tmp = actionCollection()->action("back");
	actMenu->remove( tmp );
	tmp = actionCollection()->action("forward");
	actMenu->remove( tmp );
	tmp = actionCollection()->action("home");
	actMenu->remove( tmp );
	tmp = actionCollection()->action("separator");
	actMenu->remove( tmp );
	tmp = actionCollection()->action("mkdir");
	actMenu->remove( tmp );
	tmp = actionCollection()->action("separator");
	actMenu->remove( tmp );
	tmp = actionCollection()->action("sorting menu");
	actMenu->remove( tmp );
	tmp = actionCollection()->action("separator");
	actMenu->remove( tmp );
	tmp = actionCollection()->action("view menu");
	actMenu->remove( tmp );
////////////////////////////////////////////////////////////	
	// first fill the submenus for action menu (iconMode and view)
	iconModeActionMenu->insert( largeViewAction );
	iconModeActionMenu->insert( mediumViewAction );
	iconModeActionMenu->insert( smallViewAction );
	iconModeActionMenu->insert( actionCollection()->action("separator") );
	iconModeActionMenu->insert( bottomTextAction );
	iconModeActionMenu->insert( rightTextAction );
	iconModeActionMenu->insert( actionCollection()->action("separator") );
	iconModeActionMenu->insert( flowEastAction );
	iconModeActionMenu->insert( flowSouthAction );
	iconModeActionMenu->insert( actionCollection()->action("separator") );
	iconModeActionMenu->insert( truncateTextAction );
	iconModeActionMenu->insert( wordWrapTextAction );
	iconModeActionMenu->insert( actionCollection()->action("separator") );
	iconModeActionMenu->insert( arrangeItemsAction );
	//by default we start up in detailed mode so we don't want to show this
	iconModeActionMenu->setEnabled( false );

   viewMenu->insert( detailedListAction );
	viewMenu->insert( iconViewAction );
	viewMenu->insert( actionCollection()->action("separator") );
	viewMenu->insert( treeViewAction );
	viewMenu->insert( actionCollection()->action("separator") );
	viewMenu->insert( actionCollection()->action("show hidden") );
	
	// now plug everything into the popupmenu
	actMenu->insert( actionCollection()->action("mkdir"));
	actMenu->insert( actionCollection()->action("separator"));
	actMenu->insert( actionCollection()->action("up"));
	actMenu->insert( actionCollection()->action("back"));
	actMenu->insert( actionCollection()->action("forward"));
	actMenu->insert( myHomeAction );
	actMenu->insert( actionCollection()->action("reload"));
	actMenu->insert( actionCollection()->action("separator"));
	actMenu->insert( stopAction );
	actMenu->insert( actionCollection()->action("separator"));
	actMenu->insert( p_myFtpView->myApp()->actionCollection()->action("paste") );
	actMenu->insert( actionCollection()->action("separator"));
	actMenu->insert( p_myFtpView->myApp()->actionCollection()->action("select all") );
	actMenu->insert( actionCollection()->action("separator"));
	actMenu->insert( p_myFtpView->myApp()->actionCollection()->action("find") );
	actMenu->insert( actionCollection()->action("separator"));
	actMenu->insert( iconModeActionMenu );
	actMenu->insert( actionCollection()->action("sorting menu"));
	actMenu->insert( actionCollection()->action("separator"));
	actMenu->insert( actionCollection()->action("view menu"));
	
	//setup the file action menu, this is the menu that pops up when rightclickin a file
	fileActionMenu->insert( openAction );
	fileActionMenu->insert( openWithAction );
	fileActionMenu->insert( actionCollection()->action("separator"));
	fileActionMenu->insert( p_myFtpView->myApp()->actionCollection()->action("cut") );
	fileActionMenu->insert( p_myFtpView->myApp()->actionCollection()->action("copy") );
	fileActionMenu->insert( p_myFtpView->myApp()->actionCollection()->action("paste") );
	fileActionMenu->insert( actionCollection()->action("separator"));
	fileActionMenu->insert( p_myFtpView->myApp()->actionCollection()->action("select all") );
	fileActionMenu->insert( actionCollection()->action("separator"));
	fileActionMenu->insert( p_myFtpView->myApp()->actionCollection()->action("find") );
	fileActionMenu->insert( actionCollection()->action("separator"));
	fileActionMenu->insert( deleteAction );
	fileActionMenu->insert( shredAction );
	fileActionMenu->insert( actionCollection()->action("separator"));
	fileActionMenu->insert( propertiesAction );
	fileActionMenu->insert( actionCollection()->action("separator"));
	fileActionMenu->insert( actionCollection()->action("mkdir"));
	fileActionMenu->insert( actionCollection()->action("separator"));
	fileActionMenu->insert( actionCollection()->action("sorting menu"));
	fileActionMenu->insert( actionCollection()->action("separator"));
	fileActionMenu->insert( actionCollection()->action("view menu"));
}
//-----------------------------------------------
void KBearDirOperator::slotOpen(){
	KURL::List urlList = p_myFtpView->myHighlightedItems();
	for( KURL::List::Iterator it = urlList.begin(); it != urlList.end(); ++it )
		(void)new KRun( *it );
}
//-----------------------------------------------
void KBearDirOperator::slotOpenWith(){
	KOpenWithHandler::getOpenWithHandler()
				->displayOpenWithDialog ( p_myFtpView->myHighlightedItems() );
}
//-----------------------------------------------
void KBearDirOperator::slotViewLarge(){
	((KBearFileIconView*)view())->setIconSize( KIcon::SizeLarge );
	((KBearFileIconView*)view())->arrangeItemsInGrid();
	largeViewAction->setChecked( true );
}
//-----------------------------------------------
void KBearDirOperator::slotViewMedium(){
	((KBearFileIconView*)view())->setIconSize( KIcon::SizeMedium );
	((KBearFileIconView*)view())->arrangeItemsInGrid();
	mediumViewAction->setChecked( true );
}
//-----------------------------------------------
void KBearDirOperator::slotViewSmall(){
	((KBearFileIconView*)view())->setIconSize( KIcon::SizeSmall );
	((KBearFileIconView*)view())->arrangeItemsInGrid();
	smallViewAction->setChecked( true );
}
//-----------------------------------------------
void KBearDirOperator::slotTextBottom(){
    ((KBearFileIconView*)view())->setItemTextPos( QIconView::Bottom );
	bottomTextAction->setChecked( true );
}
//-----------------------------------------------
void KBearDirOperator::slotTextRight(){
    ((KBearFileIconView*)view())->setItemTextPos( QIconView::Right );
	rightTextAction->setChecked( true );
}
//-----------------------------------------------
void KBearDirOperator::slotFlowEast(){
    ((KBearFileIconView*)view())->setHScrollBarMode( QIconView::AlwaysOff );
    ((KBearFileIconView*)view())->setVScrollBarMode( QIconView::Auto );
    ((KBearFileIconView*)view())->setArrangement( QIconView::LeftToRight );
	flowEastAction->setChecked( true );
}
//-----------------------------------------------
void KBearDirOperator::slotFlowSouth(){
    ((KBearFileIconView*)view())->setVScrollBarMode( QIconView::AlwaysOff );
    ((KBearFileIconView*)view())->setHScrollBarMode( QIconView::Auto );
    ((KBearFileIconView*)view())->setArrangement( QIconView::TopToBottom );
	flowSouthAction->setChecked( true );
}
//-----------------------------------------------
void KBearDirOperator::slotTextWordWrap(){
	((KBearFileIconView*)view())->setWordWrapIconText( true );
	wordWrapTextAction->setChecked( true );
}
//-----------------------------------------------
void KBearDirOperator::slotTextTruncate(){
	((KBearFileIconView*)view())->setWordWrapIconText( false );
	truncateTextAction->setChecked( true );
}
//-----------------------------------------------
void KBearDirOperator::slotArrangeItemsInGrid(){
	((KBearFileIconView*)view())->arrangeItemsInGrid();
}
//-----------------------------------------------
void KBearDirOperator::slotToggleIconModeActionMenu(){
	// set iconmode menu enabled if view is in icon mode else disabled
	iconModeActionMenu->setEnabled( iconViewAction->isChecked() );
}
//-----------------------------------------------
void KBearDirOperator::slotToggleTreeView(){
	emit showTreeView( treeViewAction->isChecked() );
}
//-----------------------------------------------
void KBearDirOperator::slotSetDetailedListViewMode(){
	if( detailedListAction->isChecked() ) {
		KFileView* v = new KBearFileDetailView( this,"DetailView" );
		setView( v );
		((KFileView*)view())->setViewMode( KFileView::All );
		((KFileView*)view())->setSelectionMode( KFile::Extended );
		connect( ((KBearFileDetailView*)view()), SIGNAL(dropped(KURL::List)),
							p_myFtpView,SLOT(dropped(KURL::List)));
	}
	else
		detailedListAction->setChecked( true );
}
//-----------------------------------------------
void KBearDirOperator::slotSetIconViewMode(){
	if( iconViewAction->isChecked() )  {
 		setView( new KBearFileIconView( this,"IconView" ) );
		((KFileView*)view())->setViewMode( KFileView::All );
		((KFileView*)view())->setSelectionMode( KFile::Extended );
		connect( ((KBearFileIconView*)view()), SIGNAL(dropped(KURL::List)),
						p_myFtpView,SLOT(dropped(KURL::List)));
	}
	else
		iconViewAction->setChecked( true );
}
//-----------------------------------------------
void KBearDirOperator::readConfig( KConfig* config, const QString& group ) {
	config->setGroup( group );
	KDirOperator::readConfig( config, group );
	slotViewSettingsChanged( config->readBoolEntry( "Show DetailView", true ),
													!config->readBoolEntry( "Show DetailView", true ),
													config->readBoolEntry( "Show TreeView", true ));
}
//-----------------------------------------------
void KBearDirOperator::saveConfig( KConfig* config, const QString& group ) {
	config->setGroup( "General Options" );
	if( config->readBoolEntry("Run Time Settings", true ) ) {
		config->setGroup( group );
		KDirOperator::saveConfig( config, group );
		config->writeEntry( "Show DetailView", detailedListAction->isChecked() );
		config->writeEntry( "Show TreeView", treeViewAction->isChecked() );
	}
}
//-----------------------------------------------
/** Called when @ref KBear::viewSettingsChanged() signal is emitted */
void KBearDirOperator::slotViewSettingsChanged( bool detailMode, bool iconMode, bool showTree ){
	if( ! detailedListAction->isChecked() && detailMode )
		detailedListAction->activate();
	else if( ! iconViewAction->isChecked() && iconMode )
		iconViewAction->activate();
	if( treeViewAction->isChecked() != showTree )
		treeViewAction->activate();
}
//-----------------------------------------------
void KBearDirOperator::slotListingStarted() {
	stopAction->setEnabled( true );
}
//-----------------------------------------------
void KBearDirOperator::slotListingCompleted() {
	stopAction->setEnabled( false );
}
//-----------------------------------------------
