/***************************************************************************
 *   Copyright (C) 2008 by Tobias Koenig <tokoe@kde.org>                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/

#include <QtCore/QCoreApplication>
#include <QtDBus/QDBusConnection>
#include <QtDBus/QDBusError>

#include "searchqueryiteratorinterface.h"

#include "queryservertest.h"

TestObject::TestObject( const QString &query, QObject *parent )
  : QObject( parent )
{
  mSearch = new org::freedesktop::Akonadi::Search( "org.freedesktop.Akonadi.Search", "/Search", QDBusConnection::sessionBus(), this );

  const QString queryPath = mSearch->createQuery( query );

  mQuery = new org::freedesktop::Akonadi::SearchQuery( "org.freedesktop.Akonadi.Search", queryPath, QDBusConnection::sessionBus(), this );

  const QString iteratorPath = mQuery->allHits();

  org::freedesktop::Akonadi::SearchQueryIterator *iterator =
    new org::freedesktop::Akonadi::SearchQueryIterator( "org.freedesktop.Akonadi.Search", iteratorPath,
                                                        QDBusConnection::sessionBus(), this );
  while ( iterator->next() ) {
    QString data = iterator->currentUri();
    qDebug("  %s", qPrintable( data ) );
  }

  iterator->close();

  connect( mQuery, SIGNAL( hitsChanged( const QMap<QString, double>& ) ),
           this, SLOT( hitsChanged( const QMap<QString, double>& ) ) );
  connect( mQuery, SIGNAL( hitsChanged( const QMap<QString, double>& ) ),
           this, SLOT( hitsRemoved( const QMap<QString, double>& ) ) );

  mQuery->start();
}

TestObject::~TestObject()
{
  mQuery->stop();
  mQuery->close();
}

void TestObject::hitsChanged( const QMap<QString, double> &hits )
{
  qDebug( "New hits:" );
  QMapIterator<QString, double> it( hits );
  while ( it.hasNext() ) {
    it.next();
    qDebug( "  %s: %f", qPrintable( it.key() ), it.value() );
  }
}

void TestObject::hitsRemoved( const QMap<QString, double> &hits )
{
  qDebug( "Removed hits:" );
  QMapIterator<QString, double> it( hits );
  while ( it.hasNext() ) {
    it.next();
    qDebug( "  %s: %f", qPrintable( it.key() ), it.value() );
  }
}

int main( int argc, char **argv )
{
  QCoreApplication app( argc, argv );

/*
  if ( argc != 2 ) {
    qDebug( "usage: queryservertest query" );
    return 1;
  }

  new TestObject( QString::fromLatin1( argv[ 1 ] ) );
*/
  QString query( "prefix nco:<http://www.semanticdesktop.org/ontologies/2007/03/22/nco#> select ?result where { ?result a nco:PersonContact . ?result nco:nameGiven ?n . FILTER REGEX(STR(?n), 'Tobias') . }" );
  TestObject *test = new TestObject( query );


  int retval = app.exec();

  delete test;

  return retval;
}

#include "queryservertest.moc"
