//Auto-generated by kalyptus. DO NOT EDIT.
namespace Soprano {
    using Soprano;
    using System;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  \class Serializer serializer.h Soprano/Serializer
    ///  \brief Soprano.Serializer defines the interface for a Soprano RDF serializer plugin.
    ///  Each serializer plugin may support multiple RDF serializations (supportedSerializations()).
    ///  \section Usage
    ///  Using a Serializer is straightforward. One starts by getting a plugin that supports the requested
    ///  RDF data serialization:
    ///  <pre>
    ///  Soprano.Serializer s = Soprano.PluginManager.Instance().DiscoverSerializerForSerialization( Soprano.SerializationRdfXml );
    ///  </pre>
    ///  Then serializing RDF data is done in a single method call which writes the serialized data to a QTextStream:
    ///  <pre>
    ///  QTextStream stream( stdout );
    ///  s.Serialize( model.ListStatements(), stream, Soprano.SerializationRdfXml );
    ///  </pre>
    ///  \sa \ref soprano_writing_plugins
    ///  \author Sebastian Trueg <trueg@kde.org>
    ///      </remarks>        <short>    \class Serializer serializer.</short>
    [SmokeClass("Soprano::Serializer")]
    public abstract class Serializer : Soprano.Plugin, Soprano.Error.IErrorCache {
        protected Serializer(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(Serializer), this);
        }
        // Error lastError(); >>>> NOT CONVERTED
        // void setError(const Error& arg1); >>>> NOT CONVERTED
        /// <remarks>
        ///  The serialiazation types supported by this serializer.
        ///  \return A combination of Soprano.RdfSerialization types. If
        ///  the list contains Soprano.SerializationUser the serializer 
        ///  supports additional RDF serialiazations not
        ///  officially supported by %Soprano.
        ///          </remarks>        <short>    The serialiazation types supported by this serializer.</short>
        [SmokeMethod("supportedSerializations() const")]
        public abstract uint SupportedSerializations();
        /// <remarks>
        ///  A serializer can support additional RDF serializations that are not defined in Soprano.RdfSerialization.
        ///  In that case supportedSerializations() has to include Soprano.SerializationUser.
        ///  The default implementation returns an empty list.
        ///  \return A list of supported user RDF serializations.
        ///          </remarks>        <short>    A serializer can support additional RDF serializations that are not defined in Soprano.RdfSerialization.</short>
        [SmokeMethod("supportedUserSerializations() const")]
        public virtual List<string> SupportedUserSerializations() {
            return (List<string>) interceptor.Invoke("supportedUserSerializations", "supportedUserSerializations() const", typeof(List<string>));
        }
        /// <remarks>
        ///  Check if a plugin supports a specific serialization.
        ///  \param s The requested serialization.
        ///  \param userSerialization If serialization is set to Soprano.SerializationUser this parameter specifies the
        ///        requested serialization. It allows the extension of the %Soprano Serializer interface with new
        ///        RDF serializations that are not officially supported by %Soprano.
        ///  \return <pre>true</pre> if the serializer is able to parse RDF data encoded
        ///  in serialization s, <pre>false</pre> otherwise.
        ///          </remarks>        <short>    Check if a plugin supports a specific serialization.</short>
        public bool SupportsSerialization(Soprano.RdfSerialization s, string userSerialization) {
            return (bool) interceptor.Invoke("supportsSerialization$$", "supportsSerialization(Soprano::RdfSerialization, const QString&) const", typeof(bool), typeof(Soprano.RdfSerialization), s, typeof(string), userSerialization);
        }
        public bool SupportsSerialization(Soprano.RdfSerialization s) {
            return (bool) interceptor.Invoke("supportsSerialization$", "supportsSerialization(Soprano::RdfSerialization) const", typeof(bool), typeof(Soprano.RdfSerialization), s);
        }
        /// <remarks>
        ///  Serialize a list of statements.
        ///  \param it An iterator containing the statements to be serialized.
        ///  \param stream The stream the serialized data should be written to.
        ///  \param serialization The encoding to be used.
        ///  \param userSerialization If serialization is set to Soprano.SerializationUser this parameter specifies the
        ///        serialization to use. It allows the extension of the %Soprano Serializer interface with new
        ///        RDF serializations that are not officially supported by %Soprano.
        ///  \return <pre>true</pre> if the %serialization was successful,  false otherwise.
        ///          </remarks>        <short>    Serialize a list of statements.</short>
        [SmokeMethod("serialize(Soprano::StatementIterator, QTextStream&, Soprano::RdfSerialization, const QString&) const")]
        public abstract bool Serialize(Soprano.StatementIterator it, QTextStream stream, Soprano.RdfSerialization serialization, string userSerialization);
        public Serializer(string name) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Serializer$", "Serializer(const QString&)", typeof(void), typeof(string), name);
        }
        /// <remarks>
        ///  Get the last error that occured in the current thread.
        ///              </remarks>        <short>    Get the last error that occured in the current thread.</short>
        /// <remarks>
        ///  Reset the error for the current thread to no error.
        ///              </remarks>        <short>    Reset the error for the current thread to no error.</short>
        protected void ClearError() {
            interceptor.Invoke("clearError", "clearError() const", typeof(void));
        }
        /// <remarks>
        ///  Set the last occured error. This method is const to allow setting
        ///  of errors in all types of methods. The last error is as such a 
        ///  mutable property.
        ///              </remarks>        <short>    Set the last occured error.</short>
        /// <remarks>
        ///  Convenience method to set simple string error messages with a default
        ///  error code ErrorUnknown.
        ///              </remarks>        <short>    Convenience method to set simple string error messages with a default  error code ErrorUnknown.</short>
        protected void SetError(string errorMessage, int code) {
            interceptor.Invoke("setError$$", "setError(const QString&, int) const", typeof(void), typeof(string), errorMessage, typeof(int), code);
        }
        protected void SetError(string errorMessage) {
            interceptor.Invoke("setError$", "setError(const QString&) const", typeof(void), typeof(string), errorMessage);
        }
    }
}
