/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import org.qtproject.qt5.android.QtInputEventDispatcher;
import org.qtproject.qt5.android.QtNative;

public class QtLayout
extends ViewGroup {
    private GestureDetector m_gestureDetector;
    private Runnable m_startApplicationRunnable;
    private int m_bottomDisplayFrame = -1;
    private QtInputEventDispatcher inputEventDispatcher;

    public QtLayout(Context context, Runnable runnable) {
        super(context);
        this.m_startApplicationRunnable = runnable;
        this.initializeGestureDetector(context);
        this.inputEventDispatcher = QtNative.getInputEventDispatcher();
    }

    public QtLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initializeGestureDetector(context);
        this.inputEventDispatcher = QtNative.getInputEventDispatcher();
    }

    public QtLayout(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.initializeGestureDetector(context);
        this.inputEventDispatcher = QtNative.getInputEventDispatcher();
    }

    private void initializeGestureDetector(Context context) {
        this.m_gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public void onLongPress(MotionEvent motionEvent) {
                if (motionEvent.getSource() == 8194 || motionEvent.getToolType(0) == 3) {
                    return;
                }
                QtLayout.this.inputEventDispatcher.onLongPress(motionEvent, QtLayout.this.getId());
            }
        });
        this.m_gestureDetector.setIsLongpressEnabled(true);
    }

    private void handleSizeChanged(int n, int n2, int n3, int n4) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((Activity)this.getContext()).getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        Rect rect = new Rect();
        ((Activity)this.getContext()).getWindow().getDecorView().getWindowVisibleDisplayFrame(rect);
        if (this.m_bottomDisplayFrame != rect.bottom || n4 == -1) {
            this.m_bottomDisplayFrame = rect.bottom;
            QtNative.setApplicationDisplayMetrics(displayMetrics.widthPixels, displayMetrics.heightPixels, n, n2, displayMetrics.xdpi, displayMetrics.ydpi, displayMetrics.scaledDensity, displayMetrics.density, displayMetrics.heightPixels == n2 || displayMetrics.heightPixels == n2 + rect.top || this.m_bottomDisplayFrame > displayMetrics.heightPixels + rect.top);
        }
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        this.handleSizeChanged(n, n2, n3, n4);
        if (this.m_startApplicationRunnable != null) {
            this.m_startApplicationRunnable.run();
            this.m_startApplicationRunnable = null;
        }
    }

    protected void onMeasure(int n, int n2) {
        int n3 = this.getChildCount();
        int n4 = 0;
        int n5 = 0;
        this.measureChildren(n, n2);
        for (int i = 0; i < n3; ++i) {
            View view = this.getChildAt(i);
            if (view.getVisibility() == 8) continue;
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            int n6 = layoutParams.x + view.getMeasuredWidth();
            int n7 = layoutParams.y + view.getMeasuredHeight();
            n5 = Math.max(n5, n6);
            n4 = Math.max(n4, n7);
        }
        n4 = Math.max(n4, this.getSuggestedMinimumHeight());
        n5 = Math.max(n5, this.getSuggestedMinimumWidth());
        this.setMeasuredDimension(QtLayout.resolveSize((int)n5, (int)n), QtLayout.resolveSize((int)n4, (int)n2));
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2, 0, 0);
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        int n5 = this.getChildCount();
        for (int i = 0; i < n5; ++i) {
            View view = this.getChildAt(i);
            if (view.getVisibility() == 8) continue;
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            int n6 = layoutParams.x;
            int n7 = layoutParams.y;
            view.layout(n6, n7, n6 + view.getMeasuredWidth(), n7 + view.getMeasuredHeight());
        }
        this.handleSizeChanged(n3, n4, 0, -1);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams;
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new LayoutParams(layoutParams);
    }

    public void moveChild(View view, int n) {
        if (view == null) {
            return;
        }
        if (this.indexOfChild(view) == -1) {
            return;
        }
        this.detachViewFromParent(view);
        this.requestLayout();
        this.invalidate();
        this.attachViewToParent(view, n, view.getLayoutParams());
    }

    public void setLayoutParams(View view, ViewGroup.LayoutParams layoutParams, boolean bl) {
        boolean bl2;
        if (view == null) {
            return;
        }
        if (!this.checkLayoutParams(layoutParams)) {
            return;
        }
        boolean bl3 = bl2 = this == view.getParent();
        if (bl2) {
            view.setLayoutParams(layoutParams);
            if (bl) {
                this.invalidate();
            }
        } else {
            this.addView(view, layoutParams);
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        return true;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        this.inputEventDispatcher.onTouchEvent(motionEvent, this.getId());
        this.m_gestureDetector.onTouchEvent(motionEvent);
        return true;
    }

    public boolean onTrackballEvent(MotionEvent motionEvent) {
        this.inputEventDispatcher.onCommonEvent(motionEvent, this.getId());
        return true;
    }

    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        return this.inputEventDispatcher.sendGenericMotionEvent(motionEvent, this.getId());
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        public int x;
        public int y;

        public LayoutParams(int n, int n2, int n3, int n4) {
            super(n, n2);
            this.x = n3;
            this.y = n4;
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }
    }
}

