/*
 * Decompiled with CFR 0.152.
 */
package org.libsdl.app;

import android.app.Activity;
import android.content.Context;
import android.media.AudioDeviceCallback;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.AudioTrack;
import android.os.Build;
import android.os.Process;
import android.util.Log;
import java.util.Arrays;

public class SDLAudioManager {
    protected static final String TAG = "SDLAudio";
    protected static AudioTrack mAudioTrack;
    protected static AudioRecord mAudioRecord;
    protected static Context mContext;
    private static final int[] NO_DEVICES;
    private static AudioDeviceCallback mAudioDeviceCallback;

    public static void initialize() {
        mAudioTrack = null;
        mAudioRecord = null;
        mAudioDeviceCallback = null;
        if (Build.VERSION.SDK_INT >= 24) {
            mAudioDeviceCallback = new AudioDeviceCallback(){

                public void onAudioDevicesAdded(AudioDeviceInfo[] audioDeviceInfoArray) {
                    Arrays.stream(audioDeviceInfoArray).forEach(audioDeviceInfo -> SDLAudioManager.addAudioDevice(audioDeviceInfo.isSink(), audioDeviceInfo.getId()));
                }

                public void onAudioDevicesRemoved(AudioDeviceInfo[] audioDeviceInfoArray) {
                    Arrays.stream(audioDeviceInfoArray).forEach(audioDeviceInfo -> SDLAudioManager.removeAudioDevice(audioDeviceInfo.isSink(), audioDeviceInfo.getId()));
                }
            };
        }
    }

    public static void setContext(Context context) {
        mContext = context;
        if (context != null) {
            SDLAudioManager.registerAudioDeviceCallback();
        }
    }

    public static void release(Context context) {
        SDLAudioManager.unregisterAudioDeviceCallback(context);
    }

    protected static String getAudioFormatString(int n) {
        switch (n) {
            case 3: {
                return "8-bit";
            }
            case 2: {
                return "16-bit";
            }
            case 4: {
                return "float";
            }
        }
        return Integer.toString(n);
    }

    protected static int[] open(boolean bl, int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        Log.v((String)TAG, (String)("Opening " + (bl ? "capture" : "playback") + ", requested " + n4 + " frames of " + n3 + " channel " + SDLAudioManager.getAudioFormatString(n2) + " audio at " + n + " Hz"));
        if (Build.VERSION.SDK_INT < 21 && n3 > 2) {
            n3 = 2;
        }
        if (Build.VERSION.SDK_INT < 22) {
            if (n < 8000) {
                n = 8000;
            } else if (n > 48000) {
                n = 48000;
            }
        }
        if (n2 == 4) {
            int n9 = n8 = bl ? 23 : 21;
            if (Build.VERSION.SDK_INT < n8) {
                n2 = 2;
            }
        }
        switch (n2) {
            case 3: {
                n7 = 1;
                break;
            }
            case 2: {
                n7 = 2;
                break;
            }
            case 4: {
                n7 = 4;
                break;
            }
            default: {
                Log.v((String)TAG, (String)("Requested format " + n2 + ", getting ENCODING_PCM_16BIT"));
                n2 = 2;
                n7 = 2;
            }
        }
        if (bl) {
            switch (n3) {
                case 1: {
                    n6 = 16;
                    break;
                }
                case 2: {
                    n6 = 12;
                    break;
                }
                default: {
                    Log.v((String)TAG, (String)("Requested " + n3 + " channels, getting stereo"));
                    n3 = 2;
                    n6 = 12;
                    break;
                }
            }
        } else {
            switch (n3) {
                case 1: {
                    n6 = 4;
                    break;
                }
                case 2: {
                    n6 = 12;
                    break;
                }
                case 3: {
                    n6 = 28;
                    break;
                }
                case 4: {
                    n6 = 204;
                    break;
                }
                case 5: {
                    n6 = 220;
                    break;
                }
                case 6: {
                    n6 = 252;
                    break;
                }
                case 7: {
                    n6 = 1276;
                    break;
                }
                case 8: {
                    if (Build.VERSION.SDK_INT >= 23) {
                        n6 = 6396;
                        break;
                    }
                    Log.v((String)TAG, (String)("Requested " + n3 + " channels, getting 5.1 surround"));
                    n3 = 6;
                    n6 = 252;
                    break;
                }
                default: {
                    Log.v((String)TAG, (String)("Requested " + n3 + " channels, getting stereo"));
                    n3 = 2;
                    n6 = 12;
                }
            }
        }
        int n10 = n7 * n3;
        n8 = bl ? AudioRecord.getMinBufferSize((int)n, (int)n6, (int)n2) : AudioTrack.getMinBufferSize((int)n, (int)n6, (int)n2);
        n4 = Math.max(n4, (n8 + n10 - 1) / n10);
        int[] nArray = new int[4];
        if (bl) {
            if (mAudioRecord == null) {
                mAudioRecord = new AudioRecord(0, n, n6, n2, n4 * n10);
                if (mAudioRecord.getState() != 1) {
                    Log.e((String)TAG, (String)"Failed during initialization of AudioRecord");
                    mAudioRecord.release();
                    mAudioRecord = null;
                    return null;
                }
                if (Build.VERSION.SDK_INT >= 24 && n5 != 0) {
                    mAudioRecord.setPreferredDevice(SDLAudioManager.getOutputAudioDeviceInfo(n5));
                }
                mAudioRecord.startRecording();
            }
            nArray[0] = mAudioRecord.getSampleRate();
            nArray[1] = mAudioRecord.getAudioFormat();
            nArray[2] = mAudioRecord.getChannelCount();
        } else {
            if (mAudioTrack == null) {
                mAudioTrack = new AudioTrack(3, n, n6, n2, n4 * n10, 1);
                if (mAudioTrack.getState() != 1) {
                    Log.e((String)TAG, (String)"Failed during initialization of Audio Track");
                    mAudioTrack.release();
                    mAudioTrack = null;
                    return null;
                }
                if (Build.VERSION.SDK_INT >= 24 && n5 != 0) {
                    mAudioTrack.setPreferredDevice(SDLAudioManager.getInputAudioDeviceInfo(n5));
                }
                mAudioTrack.play();
            }
            nArray[0] = mAudioTrack.getSampleRate();
            nArray[1] = mAudioTrack.getAudioFormat();
            nArray[2] = mAudioTrack.getChannelCount();
        }
        nArray[3] = n4;
        Log.v((String)TAG, (String)("Opening " + (bl ? "capture" : "playback") + ", got " + nArray[3] + " frames of " + nArray[2] + " channel " + SDLAudioManager.getAudioFormatString(nArray[1]) + " audio at " + nArray[0] + " Hz"));
        return nArray;
    }

    private static AudioDeviceInfo getInputAudioDeviceInfo(int n) {
        if (Build.VERSION.SDK_INT >= 24) {
            AudioManager audioManager = (AudioManager)mContext.getSystemService("audio");
            return Arrays.stream(audioManager.getDevices(1)).filter(audioDeviceInfo -> audioDeviceInfo.getId() == n).findFirst().orElse(null);
        }
        return null;
    }

    private static AudioDeviceInfo getOutputAudioDeviceInfo(int n) {
        if (Build.VERSION.SDK_INT >= 24) {
            AudioManager audioManager = (AudioManager)mContext.getSystemService("audio");
            return Arrays.stream(audioManager.getDevices(2)).filter(audioDeviceInfo -> audioDeviceInfo.getId() == n).findFirst().orElse(null);
        }
        return null;
    }

    private static void registerAudioDeviceCallback() {
        if (Build.VERSION.SDK_INT >= 24) {
            AudioManager audioManager = (AudioManager)mContext.getSystemService("audio");
            audioManager.registerAudioDeviceCallback(mAudioDeviceCallback, null);
        }
    }

    private static void unregisterAudioDeviceCallback(Context context) {
        if (Build.VERSION.SDK_INT >= 24) {
            AudioManager audioManager = (AudioManager)context.getSystemService("audio");
            audioManager.unregisterAudioDeviceCallback(mAudioDeviceCallback);
        }
    }

    public static int[] getAudioOutputDevices() {
        if (Build.VERSION.SDK_INT >= 24) {
            AudioManager audioManager = (AudioManager)mContext.getSystemService("audio");
            return Arrays.stream(audioManager.getDevices(2)).mapToInt(AudioDeviceInfo::getId).toArray();
        }
        return NO_DEVICES;
    }

    public static int[] getAudioInputDevices() {
        if (Build.VERSION.SDK_INT >= 24) {
            AudioManager audioManager = (AudioManager)mContext.getSystemService("audio");
            return Arrays.stream(audioManager.getDevices(1)).mapToInt(AudioDeviceInfo::getId).toArray();
        }
        return NO_DEVICES;
    }

    public static int[] audioOpen(int n, int n2, int n3, int n4, int n5) {
        return SDLAudioManager.open(false, n, n2, n3, n4, n5);
    }

    public static void audioWriteFloatBuffer(float[] fArray) {
        if (mAudioTrack == null) {
            Log.e((String)TAG, (String)"Attempted to make audio call with uninitialized audio!");
            return;
        }
        if (Build.VERSION.SDK_INT < 21) {
            Log.e((String)TAG, (String)"Attempted to make an incompatible audio call with uninitialized audio! (floating-point output is supported since Android 5.0 Lollipop)");
            return;
        }
        int n = 0;
        while (n < fArray.length) {
            int n2 = mAudioTrack.write(fArray, n, fArray.length - n, 0);
            if (n2 > 0) {
                n += n2;
                continue;
            }
            if (n2 == 0) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            Log.w((String)TAG, (String)"SDL audio: error return from write(float)");
            return;
        }
    }

    public static void audioWriteShortBuffer(short[] sArray) {
        if (mAudioTrack == null) {
            Log.e((String)TAG, (String)"Attempted to make audio call with uninitialized audio!");
            return;
        }
        int n = 0;
        while (n < sArray.length) {
            int n2 = mAudioTrack.write(sArray, n, sArray.length - n);
            if (n2 > 0) {
                n += n2;
                continue;
            }
            if (n2 == 0) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            Log.w((String)TAG, (String)"SDL audio: error return from write(short)");
            return;
        }
    }

    public static void audioWriteByteBuffer(byte[] byArray) {
        if (mAudioTrack == null) {
            Log.e((String)TAG, (String)"Attempted to make audio call with uninitialized audio!");
            return;
        }
        int n = 0;
        while (n < byArray.length) {
            int n2 = mAudioTrack.write(byArray, n, byArray.length - n);
            if (n2 > 0) {
                n += n2;
                continue;
            }
            if (n2 == 0) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            Log.w((String)TAG, (String)"SDL audio: error return from write(byte)");
            return;
        }
    }

    public static int[] captureOpen(int n, int n2, int n3, int n4, int n5) {
        return SDLAudioManager.open(true, n, n2, n3, n4, n5);
    }

    public static int captureReadFloatBuffer(float[] fArray, boolean bl) {
        if (Build.VERSION.SDK_INT < 23) {
            return 0;
        }
        return mAudioRecord.read(fArray, 0, fArray.length, bl ? 0 : 1);
    }

    public static int captureReadShortBuffer(short[] sArray, boolean bl) {
        if (Build.VERSION.SDK_INT < 23) {
            return mAudioRecord.read(sArray, 0, sArray.length);
        }
        return mAudioRecord.read(sArray, 0, sArray.length, bl ? 0 : 1);
    }

    public static int captureReadByteBuffer(byte[] byArray, boolean bl) {
        if (Build.VERSION.SDK_INT < 23) {
            return mAudioRecord.read(byArray, 0, byArray.length);
        }
        return mAudioRecord.read(byArray, 0, byArray.length, bl ? 0 : 1);
    }

    public static void audioClose() {
        if (mAudioTrack != null) {
            mAudioTrack.stop();
            mAudioTrack.release();
            mAudioTrack = null;
        }
    }

    public static void captureClose() {
        if (mAudioRecord != null) {
            mAudioRecord.stop();
            mAudioRecord.release();
            mAudioRecord = null;
        }
    }

    public static void audioSetThreadPriority(boolean bl, int n) {
        try {
            if (bl) {
                Thread.currentThread().setName("SDLAudioC" + n);
            } else {
                Thread.currentThread().setName("SDLAudioP" + n);
            }
            Process.setThreadPriority((int)-16);
        }
        catch (Exception exception) {
            Log.v((String)TAG, (String)("modify thread properties failed " + exception.toString()));
        }
    }

    public static void requestPermission(String string, int n) {
        if (Build.VERSION.SDK_INT < 23) {
            SDLAudioManager.nativePermissionResult(n, true);
            return;
        }
        Activity activity = (Activity)mContext;
        if (activity.checkSelfPermission(string) != 0) {
            activity.requestPermissions(new String[]{string}, n);
        } else {
            SDLAudioManager.nativePermissionResult(n, true);
        }
    }

    public static native int nativeSetupJNI();

    public static native void removeAudioDevice(boolean var0, int var1);

    public static native void addAudioDevice(boolean var0, int var1);

    public static native void nativePermissionResult(int var0, boolean var1);

    static {
        NO_DEVICES = new int[0];
        System.loadLibrary("SDL2");
    }
}

