/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.gnu.crypto.jce;

import gnu.crypto.jce.GnuCrypto;
import gnu.crypto.jce.spec.TMMHParameterSpec;
import gnu.crypto.jce.spec.UMac32ParameterSpec;
import gnu.crypto.mac.IMac;
import gnu.crypto.mac.MacFactory;
import gnu.crypto.prng.IRandom;
import gnu.crypto.prng.PRNGFactory;
import gnu.crypto.util.Util;
import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Iterator;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class TestOfMac
implements Testlet {
    public void test(TestHarness harness) {
        this.setUp();
        this.testUnknownMac(harness);
        this.testEquality(harness);
        this.testCloneability(harness);
    }

    public void testUnknownMac(TestHarness harness) {
        harness.checkPoint("testUnknownMac");
        try {
            Mac.getInstance("Godot", "GNU-CRYPTO");
            harness.fail("testUnknownMac()");
        }
        catch (Exception x) {
            harness.check(true);
        }
    }

    public void testEquality(TestHarness harness) {
        harness.checkPoint("testEquality");
        IMac gnu = null;
        Mac jce = null;
        byte[] in = this.getClass().getName().getBytes();
        HashMap<String, Object> attrib = new HashMap<String, Object>();
        Iterator it = MacFactory.getNames().iterator();
        while (it.hasNext()) {
            int i;
            String macName = (String)it.next();
            UMac32ParameterSpec params = null;
            if (macName.equalsIgnoreCase("UMAC32")) {
                byte[] nonce = new byte[16];
                i = 0;
                while (i < nonce.length) {
                    nonce[i] = (byte)i;
                    ++i;
                }
                params = new UMac32ParameterSpec(nonce);
                attrib.put("gnu.crypto.umac.nonce.material", nonce);
            } else if (macName.equalsIgnoreCase("TMMH16")) {
                IRandom rand = PRNGFactory.getInstance((String)"md");
                rand.init(new HashMap());
                Integer tagLen = new Integer(4);
                params = new TMMHParameterSpec(rand, tagLen);
                attrib.put("gnu.crypto.mac.tmmh.keystream", rand.clone());
                attrib.put("gnu.crypto.mac.tmmh.tag.length", tagLen);
            }
            try {
                gnu = MacFactory.getInstance((String)macName);
                harness.check(gnu != null, "MacFactory.getInstance(" + macName + ")");
            }
            catch (InternalError x) {
                harness.fail("MacFactory.getInstance(" + macName + "): " + String.valueOf(x));
            }
            try {
                jce = Mac.getInstance(macName, "GNU-CRYPTO");
                harness.check(jce != null, "Mac.getInstance()");
            }
            catch (Exception x) {
                harness.debug(x);
                harness.fail("Mac.getInstance(" + macName + "): " + String.valueOf(x));
            }
            byte[] kb = null;
            kb = macName.equalsIgnoreCase("UMAC32") || macName.equalsIgnoreCase("UHASH32") ? new byte[16] : new byte[gnu.macSize()];
            i = 0;
            while (i < kb.length) {
                kb[i] = (byte)i;
                ++i;
            }
            attrib.put("gnu.crypto.mac.key.material", kb);
            try {
                gnu.init(attrib);
                if (macName.equalsIgnoreCase("TMMH16")) {
                    jce.init(null, (AlgorithmParameterSpec)params);
                } else {
                    jce.init(new SecretKeySpec(kb, macName), (AlgorithmParameterSpec)params);
                }
            }
            catch (Exception x) {
                harness.debug(x);
                harness.fail("Mac.getInstance(" + macName + "): " + String.valueOf(x));
            }
            gnu.update(in, 0, in.length);
            byte[] ba1 = gnu.digest();
            byte[] ba2 = jce.doFinal(in);
            harness.check(Util.areEqual((byte[])ba1, (byte[])ba2), "testEquality(" + macName + ")");
        }
    }

    public void testCloneability(TestHarness harness) {
        harness.checkPoint("testCloneability");
        byte[] abc = "abc".getBytes();
        byte[] in = this.getClass().getName().getBytes();
        Iterator it = MacFactory.getNames().iterator();
        while (it.hasNext()) {
            String macName = (String)it.next();
            try {
                int i;
                UMac32ParameterSpec params = null;
                if (macName.equalsIgnoreCase("UMAC32")) {
                    byte[] nonce = new byte[16];
                    i = 0;
                    while (i < nonce.length) {
                        nonce[i] = (byte)i;
                        ++i;
                    }
                    params = new UMac32ParameterSpec(nonce);
                } else if (macName.equalsIgnoreCase("TMMH16")) {
                    IRandom rand = PRNGFactory.getInstance((String)"md");
                    rand.init(new HashMap());
                    Integer tagLen = new Integer(4);
                    params = new TMMHParameterSpec(rand, tagLen);
                }
                Mac mac1 = Mac.getInstance(macName, "GNU-CRYPTO");
                byte[] kb = null;
                kb = macName.equalsIgnoreCase("UMAC32") || macName.equalsIgnoreCase("UHASH32") ? new byte[16] : new byte[mac1.getMacLength()];
                i = 0;
                while (i < kb.length) {
                    kb[i] = (byte)i;
                    ++i;
                }
                if (macName.equalsIgnoreCase("TMMH16")) {
                    mac1.init(null, (AlgorithmParameterSpec)params);
                } else {
                    mac1.init(new SecretKeySpec(kb, macName), (AlgorithmParameterSpec)params);
                }
                mac1.update(abc);
                Mac mac2 = (Mac)mac1.clone();
                byte[] ba1 = mac1.doFinal(in);
                byte[] ba2 = mac2.doFinal(in);
                harness.check(Util.areEqual((byte[])ba1, (byte[])ba2), "testCloneability(" + macName + ")");
            }
            catch (Exception x) {
                harness.debug(x);
                harness.fail("testCloneability(" + macName + "): " + String.valueOf(x));
            }
        }
    }

    private void setUp() {
        Security.addProvider((Provider)new GnuCrypto());
    }
}

