/**
 * Global variables

 * Copyright (C) 2003  Shawn Betts
 * Copyright (C) 2004  Sylvain Beucler
 * Copyright (C) 1997, 1998, 1999, 2002, 2003  Seth A. Robinson

 * This file is part of GNU FreeDink

 * GNU FreeDink is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.

 * GNU FreeDink is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.

 * $Header: /cvsroot/dink/dink/src/globals.h,v 1.5 2004/01/16 19:55:45 Beuc Exp $
 */

#include <time.h>
#include "structures.h"
#include "constants.h"
#include "typedefs.h"

extern struct player_short_info short_play;
extern UINT midi_id;
extern /*bool*/int g_b_no_write_ini;
extern /*bool*/int no_cheat;
extern int last_saved_game;
extern /*bool*/int g_b_kill_app; /* if true, will close app as soon as the message pump is empty */
extern int dinkspeed;
extern int last_cd;
extern char current_map[255];
extern int regcode, mycode;
extern time_t time_start;
extern /*bool*/int item_screen;
extern /*bool*/int midi_active;
extern char dversion_string[];
extern char dinkpath[200];
extern UINT CD_ID;
extern int map_vision;
extern int flub_mode;
extern unsigned short decipher_savegame;
extern int draw_map_tiny;
extern char last_debug[200];
extern int walk_off_screen;

/* extern char cbuf[64000]; */

extern /*bool*/int cd_inserted;
extern int burn_revision;
extern /*bool*/int abort_this_flip;
extern struct show_bmp_t showb;
extern int keep_mouse;
extern int mcc, sound_support;
extern struct attackinfo_struct bow;
extern struct soundstruct soundinfo[NUM_SOUNDBANKS + 1];
extern int screenlock;
extern struct talk_struct talk;
extern char last_midi[15];
extern char midi_cur[20];
extern char midi_last[20];
extern int *pvision, *plife, *presult, *pspeed, *ptiming, *plifemax, *pexper,
  *pmap, *pstrength, *pcur_weapon, *pcur_magic, *pdefense, *pgold, *pmagic,
  *plevel, *plast_text, *pmagic_level;
extern int *pupdate_status, *pmissile_target, *penemy_sprite, *pmagic_cost,
  *pmissle_source;
extern int flife, fexp, fstrength, fdefense, fgold, fmagic, fmagic_level,
  flifemax, fraise, last_magic_draw;
extern int fcur_weapon, fcur_magic;
extern int mbase_timing;
extern struct idata id[MAX_IDATA];


extern DWORD mold;


extern int item_timer;
extern int item_pic;


extern int mbase_count;
extern /*bool*/int no_transition;
extern struct seth_sound ssound[MAX_SOUNDS];
extern int push_active;
extern TTF_Font *lf;
extern /*bool*/int turn_on_plane;
extern TTF_Font *hfont;
extern TTF_Font *hfont_small;
extern int stop_entire_game;
extern /*bool*/int in_enabled;
extern char *in_string;
extern /*bool*/int first_frame;
extern /*bool*/int no_running_main;
extern struct call_back callback[MAX_CALLBACKS];
extern char *rbuf[MAX_SPRITES];	/* pointers to buffers we may need */
extern struct refinfo *rinfo[MAX_SPRITES]; /* Execution graph frames, back-linked via proc_return (pointing to caller) */
extern int process_warp;
extern /*bool*/int process_upcycle;
extern /*bool*/int process_downcycle;
extern DWORD cycle_clock;
extern int cycle_script;
extern int *in_int;
extern int in_x, in_y;
extern int sp_brain;
extern int returnint;
extern char returnstring[200];
extern int sp_speed;
extern char slist[10][200];
extern long nlist[10];
extern int process_count;
extern struct rect sp_alt;
extern int hard_tile;
extern /*bool*/int sp_screenmatch;
extern char in_temp[200];
extern int in_command;
extern int in_finish;
extern int in_onflag;
extern int in_max;
extern int in_huh;
extern char in_default[200];
extern int in_master;
extern /*bool*/int sound_on;
extern char dir[80];
extern /*bool*/int please_wait;
extern int show_dot;
extern int plane_process;
extern struct hit_map hm;
extern struct sprite_index *sequence_index;
extern int last_sprite_added;
extern DWORD timer;
extern char *command_line;
extern /*bool*/int dinkedit;
extern int base_timing;
extern int weapon_script;
extern int magic_script;


extern int sp_mode;
extern int fps, fps_final;
extern int last_sprite_created;
extern int move_screen;
extern /*bool*/int move_gonna;
extern int move_counter;
extern int m1x, m1y;
extern int m2x, m2y;
extern int m3x, m3y;
extern int playx;
extern /*bool*/int windowed;
extern int playl;
extern /*bool*/int mouse1;
extern int cur_sprite;
extern int playy;
extern int cur_map, cur_tile;
extern struct seth_joy sjoy;
extern DWORD thisTickCount, lastTickCount;
extern DWORD timecrap;
extern struct rect math, box_crap, box_real;
extern int sz, sy, x_offset, y_offset;


extern int mode;


extern struct sequence *seq;
extern struct map_info map;
extern struct small_map pam;

/* extern SDL_Surface *     lpDDSOne;       // Offscreen surface 1 */
extern SDL_Surface *lpDDSTwo; /* Offscreen surface 2 */
extern SDL_Surface *lpDDSTrick;	/* Offscreen surface 2 */
extern SDL_Surface *lpDDSTrick2; /* Offscreen surface 2 */
extern /*bool*/int trig_man;
extern /*bool*/int total_trigger;
extern /*bool*/int debug_mode; /* Whether additional debug information should be print */


extern struct pic_info *k; /* Sprite data */
extern struct player_info play;


extern SDL_Surface *lpDDSPrimary; /* DirectDraw primary surface */
extern SDL_Surface *lpDDSBack; /* DirectDraw back surface */


extern SDL_Surface *tiles[TILE_SCREENS]; /* Game pieces */
extern SDL_Surface *game[MAX_GAME]; /* Game pieces */


extern struct sp *spr; /* max sprite control systems at once */


extern SDL_Color pe[256];
extern SDL_Color real_pal[256];


extern /*BOOL*/int app_active; /* is application active? */


extern BYTE torusColors[256]; /* Marks the colors used in the torus */


extern SDL_Joystick *jinfo;
extern /*bool*/int joystick;
extern struct hardness hmap;
extern struct rect tilerect[TILE_SCREENS];


extern struct wait_for_button_t wait;


void init_sprites ();


extern int fps_average;



extern /*bool*/int initFail (char mess[200]);
extern void move (int u, int amount, char kind, char kindy);
extern void draw_box (struct rect box, int color);
extern void run_through_tag_list_push (int h);
extern void random_blood (int mx, int my, int h);
extern int check_if_move_is_legal (int u);
extern void change_dir_to_diag (int *dir);
extern int hurt_thing (int h, int damage, int special);
extern int but_timer;
extern int water_timer;
extern /*bool*/int fire_forward;
extern int fire_flip;

/* extern const NUM_SOUND_EFFECTS = 10; */
extern int fps_show;



extern /*BOOL*/int InitSound ();
extern /*BOOL*/int DestroySound (void);
extern /*BOOL*/int DSDisable (void);
extern /*BOOL*/int DSEnable ();


extern int drawthistime;
extern int x;
extern int y;
extern struct rect rc;
extern int winoffset;
extern int winoffsetx;


extern int cx;
extern int cy;
extern int speed;

extern Mix_Music *music_data;
extern char *g_fontdir;

extern struct mouse_status_t mouse_status;
