/**
 * Sound support

 * Copyright (C) 2003  Shawn Betts
 * Copyright (C) 2003, 2004  Sylvain Beucler
 * Copyright (C) 1997, 1998, 1999, 2002, 2003  Seth A. Robinson

 * This file is part of GNU FreeDink

 * GNU FreeDink is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.

 * GNU FreeDink is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.

 * $Header: /cvsroot/dink/dink/src/audio.c,v 1.3 2004/01/16 19:55:45 Beuc Exp $
 */

#include "dink.h"

/*
* DestroySound
*
* Undoes everything that was done in a InitSound call
*/

/*BOOL*/int
DestroySound (void)
{
  return 1;

  /* SABETTS: todo */
/*     DWORD       idxKill; */


/*     for( idxKill = 0; idxKill < max_sounds; idxKill++ ) */
/*     { */
/*         SoundDestroyEffect( idxKill ); */
/*     } */


/*     DSDisable(); */
/*     return TRUE; */

}				/* DestroySound */


/*
  * SoundDestroyEffect
  *
  * Frees up resources associated with a sound effect
*/

/*BOOL*/int
SoundDestroyEffect (int sound)
{
  Mix_FreeChunk (ssound[sound].sound);
  return 1;
}				/* SoundDestryEffect */


/*
  * SoundLoadEffect
  *
  * Initializes a sound effect by loading the WAV file from a resource
*/

/*BOOL SoundLoadEffect( int sound)
{
if (lpDS && lpSoundEffects[sound] == NULL && *szSoundEffects[sound])
   {

//
//  use DSLoadSoundBuffer (in ..\misc\dsutil.c) to load
//  a sound from a resource.
//

lpSoundEffects[sound] = DSLoadSoundBuffer(lpDS, szSoundEffects[sound]);
if (lpSoundEffects[sound] == NULL) Msg("Damn, got a null one for sound %d.",sound);

   }
  return lpSoundEffects[sound] != NULL;

} */


void
SoundLoadBanks (void)
{
  /* SABETTS: SDL_mixer does all this */
/*      HRESULT ddsound; */

/*      lpDS->DuplicateSoundBuffer (ssound[1].sound, &bowsound); */


/*      for (int i = 1; i <= num_soundbanks; i++) { */


/*              if (lpDS && soundbank[i] == NULL) */
/*              { */
/*                      // */
/*                      //  use DSLoadSoundBuffer (in ..\misc\dsutil.c) to load */
/*                      //  a sound from a resource. */
/*                      // */

/*                      ddsound = */
/*                              lpDS->DuplicateSoundBuffer (ssound[1].sound, */
/*                                                          &soundbank[i]); */
/*                      if (ddsound != DS_OK) */
/*                              Msg ("Couldn't load soundbank %d.", i); */
/*              } */

/*      } */

}


/*BOOL*/int
InitSound ()
{
/* UNREFERENCED  int idx; */

  /* Msg (("initting sound")); */
/*      DSBUFFERDESC dsBD; */
/*      IDirectSoundBuffer *lpPrimary; */

/*      DSEnable (hwndOwner); */

  if (Mix_OpenAudio (MIX_DEFAULT_FREQUENCY, MIX_DEFAULT_FORMAT, 1, 1024) ==
      -1)
    {
      Msg (("Mix_OpenAudio: %s", Mix_GetError ()));
      return 0;
    }

  /* Allocate 16 channels to play effects to */
  Mix_AllocateChannels (16);

  /* Set the music volume to 50% */
  Mix_VolumeMusic (MIX_MAX_VOLUME / 2);

/* if (lpDS == NULL) { */
/* Msg( ("lpds wasn't initted in dsenable!")); */
/* return FALSE; */
/*       } */
/*
 * Load all sounds -- any that can't load for some reason will have NULL
 * pointers instead of valid SOUNDEFFECT data, and we will know not to
 * play them later on.
 */


/*       for( idx = 0; idx < NUM_SOUND_EFFECTS; idx++ ) */
/*         { */
/*         if (SoundLoadEffect(idx)) */
/*         { */
/*         DSBCAPS  caps; */

/*         caps.dwSize = sizeof(caps); */
/*         lpSoundEffects[idx]->GetCaps(&caps); */

/*         if (caps.dwFlags & DSBCAPS_LOCHARDWARE) */
/*         Msg(( "Sound effect %s in hardware", szSoundEffects[idx])); */
/*         else */
/*         Msg(( "Sound effect %s in software", szSoundEffects[idx])); */
/*         } */
/*         else */
/*         { */
/*         Msg(( "cant load sound effect %s", szSoundEffects[idx])); */
/*         } */
/*         } */


  CreateBufferFromWaveFile ("gold.wav", 1);

  SoundLoadBanks ();

     /*
      * get the primary buffer and start it playing
      *
      * by playing the primary buffer, DirectSound knows to keep the
      * mixer active, even though we are not making any noise.
      */

/*      ZeroMemory (&dsBD, sizeof (DSBUFFERDESC)); */
/*      dsBD.dwSize = sizeof (dsBD); */
/*      dsBD.dwFlags = DSBCAPS_PRIMARYBUFFER; */

/*      if (SUCCEEDED (lpDS->CreateSoundBuffer (&dsBD, &lpPrimary, NULL))) { */
/*              if (!SUCCEEDED (lpPrimary->Play (0, 0, DSBPLAY_LOOPING))) { */
/*                      Msg( ("Unable to play Primary sound buffer")); */
/*                      return FALSE; */
/*              } */
/*              return TRUE; */
/*              //  IDirectSoundBuffer_Release(lpPrimary); */
/*      } else { */
/*              return FALSE; */
/*              // TRACE("Unable to create Primary sound buffer"); */
/*      } */

  return 1;

}

/* InitSound */




/*bool*/int
nothing_playing (void)
{
  return 1;
  /* SABETTS: todo */
/*      //int crap = (mciSendString("status MUSIC offset", NULL, 0, NULL)); */
/*      //int crap =  (mciSendString("play MUSIC from 0", NULL, 0, g_hWnd)); */
/*      DWORD dwReturn; */
/*      MCI_OPEN_PARMS mciOpenParms; */
/*      MCI_PLAY_PARMS mciPlayParms; */
/*      MCI_STATUS_PARMS mciStatusParms; */
/*      MCI_SEQ_SET_PARMS mciSeqSetParms; */
/*      // Open the device by specifying the device and filename. */
/*      // MCI will attempt to choose the MIDI mapper as the output port. */

/*      //MCI_STATUS_LENGTH */
/*      mciStatusParms.dwItem = MCI_STATUS_MODE; */
/*      if (dwReturn = mciSendCommand (midi_id, MCI_STATUS, */
/*                                     MCI_STATUS_ITEM, */
/*                                     (DWORD) (LPVOID) & mciStatusParms)) { */

/*              Msg( ("Error reading status from midi mapper!")); */
/*              return (false); */
/*              //mciSendCommand(midi_id, MCI_CLOSE, 0, NULL);      */
/*      } */
/*      //      return (dwReturn); */




/*      if (mciStatusParms.dwReturn == MCI_MODE_PLAY) */
/*              return (true); */
/*      else */
/*              return (false); */
}


void
init_midi (void)
{
  /* SDL needs nothing here */

}



DWORD
playMIDIFile (char *lpszMIDIFileName)
{
  /* Stop whatever is playing before we play something else. */
  Mix_HaltMusic ();

  if (music_data)
    Mix_FreeMusic (music_data);

  music_data = Mix_LoadMUS (lpszMIDIFileName);

  if (music_data == NULL)
    {
      Msg (("Unable to play '%s': %s", lpszMIDIFileName, Mix_GetError ()));
      return 0;
    }

  Mix_PlayMusic (music_data, 1);

  return 0;
}



BOOL
PlayMidi (char *sFileName)
{
  char buf[256];
  char crap[256];

  /* no midi stuff right now */
  if (sound_on == 0)
    return 1;

  process_string (sFileName);
  Msg (("Processed to %s", sFileName));

  if (compare (last_midi, sFileName))
    {
      if (nothing_playing ())
	{
	  Msg (("I think %s is already playing, I should skip it it...",
		sFileName));
	  return (0);
	}

    }

  sprintf (crap, "sound/%s", sFileName);
  if (exist (crap))
    {

    }
  else
    {
      sprintf (crap, "../dink/sound/%s", sFileName);
      if (!exist (crap))
	{
	  Msg (("Error playing midi %s, doesn't exist in any dir.",
		sFileName));
	  return (0);
	}

    }

  strcpy (last_midi, sFileName);
  playMIDIFile (crap);
  return (1);

  sprintf (buf, "open %s type sequencer alias MUSIC", crap);
  return 1;
}


void
check_midi (void)
{
  char hold[20];

  if (!midi_active)
    return;
  if (map.music[*pmap] != 0)
    {

      if (map.music[*pmap] == -1)
	{

	}

      if (map.music[*pmap] > 1000)
	{

	  if (cd_inserted)
	    {
	      if (map.music[*pmap] - 1000 == last_cd)
		if (cdplaying ())
		  return;

	    }
	  else
	    {

	      sprintf (hold, "%d.mid", map.music[*pmap] - 1000);
	      PlayMidi (hold);
	    }
	  return;
	}
      /* there is music associated with this screen */
      sprintf (hold, "%d.mid", map.music[*pmap]);
      PlayMidi (hold);
    }


}


BOOL PauseMidi ()
{
  Mix_PauseMusic ();

  /* Yahoo! */
  return 1;
}


BOOL
ResumeMidi ()
{
  /* Resume midi */
/* if (mciSendString ("play MUSIC notify", NULL, 0, g_hWnd) != 0) { */
/* return (FALSE); */
/* } */
  Mix_ResumeMusic ();

  /* Yahoo! */
  return 1;
}



BOOL StopMidi ()
{

  /* SABETTS: todo */
/* playMIDIFile (g_hWnd, ""); */

  Mix_HaltMusic ();

  /* Yahoo! */
  return 1;
}



BOOL ReplayMidi ()
{
  Mix_RewindMusic ();
  /* Yahoo! */
  return 1;
}

BOOL CreateBufferFromWaveFile (char *FileName, DWORD dwBuf)
{
  /* Open the wave file        */
  char crap[150];

  sprintf (crap, "sound/%s", FileName);

  Msg (("loading %s...", crap));
  process_string (crap);
  Msg (("Processed to %s...", crap));
  if (!exist (crap))
    {
      sprintf (crap, "../dink/sound/%s", FileName);
      process_string (crap);
    }


  ssound[dwBuf].sound = Mix_LoadWAV (crap);

  if (ssound[dwBuf].sound == NULL)
    {
      Msg (("Error loading %s", FileName));
      return 0;
    }

  return 1;
}


/*bool*/int
cdplaying (void)
{
  return 0;
  /* SABETTS: todo */
/* //int crap = (mciSendString("status MUSIC offset", NULL, 0, NULL)); */
/* //int crap =  (mciSendString("play MUSIC from 0", NULL, 0, g_hWnd)); */
/* DWORD dwReturn; */
/* MCI_OPEN_PARMS mciOpenParms; */
/* MCI_PLAY_PARMS mciPlayParms; */
/* MCI_STATUS_PARMS mciStatusParms; */
/* MCI_SEQ_SET_PARMS mciSeqSetParms; */
/* // Open the device by specifying the device and filename. */
/* // MCI will attempt to choose the MIDI mapper as the output port. */

/* //MCI_STATUS_LENGTH */


/* //Msg(("Trying to play returned %d ",mciSendCommand(CD_ID, MCI_PLAY, 0, NULL))); */

/* mciStatusParms.dwItem = MCI_STATUS_CURRENT_TRACK; */
/* if (dwReturn = mciSendCommand (CD_ID, MCI_STATUS, */
/* MCI_STATUS_ITEM, */
/* (DWORD) (LPVOID) & mciStatusParms)) { */
/* Msg( ("Error reading status from midi mapper!")); */
/* return (false); */
/* //mciSendCommand(midi_id, MCI_CLOSE, 0, NULL);      */
/* } */
/* //      return (dwReturn); */
/* Msg( ("Mode returned %d..", mciStatusParms.dwReturn)); */

/* if (mciStatusParms.dwReturn != last_cd) */
/* return (false); */
/* else */
/* return (true); */

}

/* thing to play the midi */











DWORD
killcd (BYTE bTrack)
{
  return 1;
  /* SABETTS: todo */
/* DWORD dwReturn; */
/* MCI_OPEN_PARMS mciOpenParms; */
/* MCI_SET_PARMS mciSetParms; */
/* MCI_PLAY_PARMS mciPlayParms; */
/* // Open the CD audio device by specifying the device name. */
/* mciOpenParms.lpstrDeviceType = "cdaudio"; */
/* if (dwReturn = mciSendCommand (NULL, MCI_OPEN, */
/* MCI_OPEN_TYPE, */
/* (DWORD) (LPVOID) & mciOpenParms)) { */
/* // Failed to open device. Don't close it; just return error. */
/* return (dwReturn); */
/* } */
/* // The device opened successfully; get the device ID. */
/* CD_ID = mciOpenParms.wDeviceID; */
/* // Set the time format to track/minute/second/frame (TMSF). */
/* mciSetParms.dwTimeFormat = MCI_FORMAT_TMSF; */
/* if (dwReturn = mciSendCommand (CD_ID, MCI_SET, */
/* MCI_SET_TIME_FORMAT, */
/* (DWORD) (LPVOID) & mciSetParms)) { */
/* mciSendCommand (CD_ID, MCI_CLOSE, 0, NULL); */
/* return (dwReturn); */
/* }                       // Begin playback from the given track and play until the beginning  */
/* // of the next track. The window procedure function for the parent  */
/* // window will be notified with an MM_MCINOTIFY message when  */
/* // playback is complete. Unless the play command fails, the window  */
/* // procedure closes the device.    mciPlayParms.dwFrom = 0L; */
/* mciPlayParms.dwTo = 0L; */
/* mciPlayParms.dwFrom = MCI_MAKE_TMSF (bTrack, 0, 0, 0); */
/* mciPlayParms.dwTo = MCI_MAKE_TMSF (bTrack + 1, 0, 0, 0); */
/* mciPlayParms.dwCallback = (DWORD) hWndNotify; */
/* if (dwReturn = mciSendCommand (CD_ID, MCI_STOP, */
/* MCI_FROM | MCI_TO | MCI_NOTIFY, */
/* (DWORD) (LPVOID) & mciPlayParms)) { */
/* mciSendCommand (CD_ID, MCI_CLOSE, 0, NULL); */
/* return (dwReturn); */
/* } */
/* return (0L); */

/* mciSendCommand (CD_ID, MCI_CLOSE, 0, NULL); */


}



DWORD
PlayCD (BYTE bTrack)
{
  return 0;
  /* SABETTS: todo */

/* DWORD dwReturn; */
/* MCI_OPEN_PARMS mciOpenParms; */
/* MCI_SET_PARMS mciSetParms; */
/* MCI_PLAY_PARMS mciPlayParms; */
/* //    killcd(g_hWnd, 1);   */
/* // Open the CD audio device by specifying the device name. */
/* if (CD_ID != midi_id) { */
/* //turn off CD before we try to play a track */
/* mciSendCommand (CD_ID, MCI_CLOSE, 0, NULL); */
/* } */

/* last_cd = bTrack; */

/* mciOpenParms.lpstrDeviceType = "cdaudio"; */
/* if (dwReturn = mciSendCommand (NULL, MCI_OPEN, */
/* MCI_OPEN_TYPE, */
/* (DWORD) (LPVOID) & mciOpenParms)) { */
/* // Failed to open device. Don't close it; just return error. */
/* Msg( ("Couldn't open CD music...")); */
/* return (dwReturn); */
/* } */
/* // The device opened successfully; get the device ID. */

/* playMIDIFile (g_hWnd, ""); */
/* CD_ID = mciOpenParms.wDeviceID; */
/* //mciSendCommand(CD_ID, MCI_STOP, 0, NULL);    */

/* // Set the time format to track/minute/second/frame (TMSF). */
/* mciSetParms.dwTimeFormat = MCI_FORMAT_TMSF; */
/* if (dwReturn = mciSendCommand (CD_ID, MCI_SET, */
/* MCI_SET_TIME_FORMAT, */
/* (DWORD) (LPVOID) & mciSetParms)) { */
/* mciSendCommand (CD_ID, MCI_CLOSE, 0, NULL); */
/* return (dwReturn); */
/* }                       // Begin playback from the given track and play until the beginning  */
/* // of the next track. The window procedure function for the parent  */
/* // window will be notified with an MM_MCINOTIFY message when  */
/* // playback is complete. Unless the play command fails, the window  */
/* // procedure closes the device.    mciPlayParms.dwFrom = 0L; */
/* mciPlayParms.dwTo = 0L; */
/* mciPlayParms.dwFrom = MCI_MAKE_TMSF (bTrack, 0, 0, 0); */
/* mciPlayParms.dwTo = MCI_MAKE_TMSF (bTrack + 1, 0, 0, 0); */
/* mciPlayParms.dwCallback = (DWORD) hWndNotify; */
/* if (dwReturn = mciSendCommand (CD_ID, MCI_PLAY, */
/* MCI_FROM | MCI_TO | MCI_NOTIFY, */
/* (DWORD) (LPVOID) & mciPlayParms)) { */
/* mciSendCommand (CD_ID, MCI_CLOSE, 0, NULL); */
/* return (dwReturn); */
/* } */
/* return (0L); */




}



DWORD
getCDTrackStartTimes (void)
{
  return 0;
  /* SABETTS: todo */
/* UINT wDeviceID; */
/* int i, iNumTracks; */

/* cd_inserted = false; */
/* DWORD dwReturn; */
/* DWORD dwPosition; */
/* DWORD *pMem; */
/* char szTempString[64]; */
/* char szTimeString[512] = "\0";  // room for 20 tracks */
/* MCI_OPEN_PARMS mciOpenParms; */
/* MCI_SET_PARMS mciSetParms; */
/* MCI_STATUS_PARMS mciStatusParms; */
/* // Open the device by specifying the device name. */


/* Msg( ("Opening cd..")); */
/* mciOpenParms.lpstrDeviceType = "cdaudio"; */
/* if (dwReturn = mciSendCommand (NULL, MCI_OPEN, */
/* MCI_OPEN_TYPE, */
/* (DWORD) (LPVOID) & mciOpenParms)) { */
/* // Failed to open device.  */
/* // Don't close device; just return error.     */
/* char error[200]; */

/* mciGetErrorString (dwReturn, error, 200); */
/* Msg( (":  %s", error)); */
/* return (dwReturn); */
/* } */
/* // The device opened successfully; get the device ID. */

/* Msg( ("Get id..")); */

/* wDeviceID = mciOpenParms.wDeviceID; */
/* // Set the time format to minute/second/frame (MSF) format.  */
/* mciSetParms.dwTimeFormat = MCI_FORMAT_MSF; */
/* if (dwReturn = mciSendCommand (wDeviceID, MCI_SET, */
/* MCI_SET_TIME_FORMAT, */
/* (DWORD) (LPVOID) & mciSetParms)) { */
/* mciSendCommand (wDeviceID, MCI_CLOSE, 0, NULL); */
/* return (dwReturn); */
/* }                       // Get the number of tracks;  */
/* // limit to number that can be displayed (20). */
/* mciStatusParms.dwItem = MCI_STATUS_NUMBER_OF_TRACKS; */
/* if (dwReturn = mciSendCommand (wDeviceID, MCI_STATUS, */
/* MCI_STATUS_ITEM, */
/* (DWORD) (LPVOID) & mciStatusParms)) { */
/* Msg( ("Error reading cd 44.")); */
/* mciSendCommand (wDeviceID, MCI_CLOSE, 0, NULL); */
/* return (dwReturn); */
/* } */

/* iNumTracks = mciStatusParms.dwReturn; */

/* if (iNumTracks == (1000 - 981)) { */
/* cd_inserted = true; */
/* //log_path(false); */
/* } else { */
/* mciSendCommand (wDeviceID, MCI_CLOSE, 0, NULL); */
/* return (dwReturn); */
/* } */

/* iNumTracks = min (iNumTracks, 20); */
/* // Allocate memory to hold starting positions. */
/* pMem = (DWORD *) LocalAlloc (LPTR, iNumTracks * sizeof (DWORD)); */
/* if (pMem == NULL) { */
/* mciSendCommand (wDeviceID, MCI_CLOSE, 0, NULL); */
/* return (-1); */
/* } */
/* // For each track, get and save the starting location and */
/* // build a string containing starting locations. */
/* for (i = 1; i <= iNumTracks; i++) { */
/* mciStatusParms.dwItem = MCI_STATUS_LENGTH; */
/* mciStatusParms.dwTrack = i; */
/* if (dwReturn = mciSendCommand (wDeviceID, */
/* MCI_STATUS, */
/* MCI_STATUS_ITEM | MCI_TRACK, */
/* (DWORD) (LPVOID) & */
/* mciStatusParms)) { */
/* mciSendCommand (wDeviceID, MCI_CLOSE, 0, NULL); */
/* return (dwReturn); */
/* } */
/* pMem[i - 1] = mciStatusParms.dwReturn; */
/* wsprintf (szTempString, */
/* "Track %2d - %02d:%02d:%02d\n", i, */
/* MCI_MSF_MINUTE (pMem[i - 1]), */
/* MCI_MSF_SECOND (pMem[i - 1]), */
/* MCI_MSF_FRAME (pMem[i - 1])); */
/* lstrcat (szTimeString, szTempString); */
/* } */
/* // Use MessageBox to display starting times. */
/* //MessageBox(g_hWnd, szTimeString,  */
/* //  "Track Starting Position", MB_ICONINFORMATION); */
/* // Free memory and close the device.    */


/* if ((MCI_MSF_MINUTE (pMem[12 - 1]) == 1) */
/* && (MCI_MSF_SECOND (pMem[12 - 1]) == 10)) { */
/* //registered! */
/* regcode = mycode; */
/* sound_support = mcc; */

/* } */

/* if ((MCI_MSF_MINUTE (pMem[12 - 1]) == 1) */
/* && (MCI_MSF_SECOND (pMem[12 - 1]) == 12)) { */
/* //registered! */
/* regcode = mycode; */
/* sound_support = mcc; */

/* } else { */


/* //Msg(("Not Regged! %d M %d", MCI_MSF_SECOND(pMem[12-1]), MCI_MSF_MINUTE(pMem[12-1]) )); */
/* } */

/* LocalFree ((HANDLE) pMem); */
/* if (dwReturn = mciSendCommand (wDeviceID, MCI_CLOSE, 0, NULL)) { */
/* return (dwReturn); */
/* } */
/* return (0L); */
}

BOOL
playing (int sound)
{
  int i;

  if (sound >= MAX_SOUNDS)
    return 0;

  /* Check all channels to see if it is playing the sound */
  for (i = 0; i < Mix_AllocateChannels (-1); i++)
    {
      if (Mix_GetChunk (i) == ssound[sound].sound)
	return 1;
    }


  return 0;
}

int
get_pan (int h)
{

  int pan = 0;

  int x1 = 320;


  /* uncomment to allow math to be done from Dink's current location */
  /* x1 = spr[1].x; */


  if (spr[h].active)
    {
      if (spr[h].x > x1)
	pan += (spr[h].x - x1) * 6;
      if (x1 > spr[h].x)
	pan -= (x1 - spr[h].x) * 6;

    }


  if (pan > 10000)
    pan = 10000;
  if (pan < -10000)
    pan = -10000;


  return (pan);


}



int
get_vol (int h)
{

  int pan = 0;
  int pan2 = 0;

  if (spr[h].active)
    {
      if (spr[h].x > spr[1].x)
	pan -= (spr[h].x - spr[1].x) * 4;


      if (spr[1].x > spr[h].x)
	pan -= (spr[1].x - spr[h].x) * 4;


      if (spr[h].y > spr[1].y)
	pan2 -= (spr[h].y - spr[1].y) * 4;

      if (spr[1].y > spr[h].y)
	pan2 -= (spr[1].y - spr[h].y) * 4;


      /* Msg(("pan %d, pan2 %d", pan, pan2)); */

      if (pan2 < pan)
	pan = pan2;

    }


  if (pan > -100)
    pan = 0;

  if (pan < -10000)
    pan = -10000;


  return (pan);


}


void
kill_repeat_sounds (void)
{
  Mix_HaltChannel (-1);
}


void
kill_repeat_sounds_all (void)
{
  Mix_HaltChannel (-1);
}


void
update_sound (void)
{
  /* SABETTS: todo */
/* unsigned long crap; */

/* if (!sound_on) */
/* return; */

/* for (int i = 1; i <= num_soundbanks; i++) { */
/* if (soundinfo[i].repeat) */
/* if (soundinfo[i].owner != 0) { */

/* if ((spr[soundinfo[i].owner].sound == */
/* 0) | (soundinfo[i].owner == 0) */

/* | (spr[soundinfo[i].owner].active == */
/* false)) { */
/* soundbank[i]->Stop (); */
/* //Msg(("Killed bank %d", i));      */
/* //Msg(("REPEAT Sound %d playing.. owner is %d.", i,soundinfo[i].owner)); */
/* soundinfo[i].owner = 0; */
/* soundinfo[i].repeat = 0; */
/* } else { */
/* soundbank[i]-> */
/* SetPan (get_pan */
/* (soundinfo[i].owner)); */
/* soundbank[i]-> */
/* SetVolume (get_vol */
/* (soundinfo[i]. */
/* owner)); */

/* } */
/* } */

/* soundbank[i]->GetStatus (&crap); */
/* if (crap == DSBSTATUS_PLAYING) { */
/* { */
/* //Msg(("Sound %d playing.. owner is %d.", i,soundinfo[i].owner)); */
/* if (soundinfo[i].owner != 0) { */

/* if (spr[soundinfo[i].owner].active == */
/* false) { */
/* //Msg(("Killed bank %d", i));      */

/* soundbank[i]->Stop (); */

/* } else { */
/* soundbank[i]-> */
/* SetPan (get_pan */
/* (soundinfo[i]. */
/* owner)); */
/* soundbank[i]-> */
/* SetVolume (get_vol */
/* (soundinfo */
/* [i]. */
/* owner)); */
/* } */

/* } */
/* } */
/* } */
/* } */

}

int
SoundPlayEffect (int sound, int min, int plus, int sound3d, /*bool*/int repeat)
{
  int channel;

  channel = Mix_PlayChannel (-1, ssound[sound].sound, repeat ? -1 : 0);

  if (channel == -1)
    {
      Msg (("Error playing sound %d\n", sound));
      return 0;
    }
  /* return a non-zero channel */
  return channel + 1;


}				/* SoundPlayEffect */

BOOL
SoundStopEffect (int sound)
{
  return 1;
  /* SABETTS: todo */
/* HRESULT dsrval; */

/* if (!lpDS || !ssound[sound].sound) { */
/* return FALSE; */
/* } */

/* dsrval = ssound[sound].sound->Stop (); */

/* return SUCCEEDED (dsrval); */

}				/* SoundStopEffect */


/*BOOL*/int
DSEnable ()
{
  return 1;
/* HRESULT dsrval; */
/* BOOL bUseDSound; */

/* bUseDSound = TRUE; */
/* //GetProfileInt("FoxBear", "use_dsound", bWantSound); */

/* if (!bUseDSound) { */
/* lpDS = NULL; */
/* Msg( ("Aborting sound init")); */
/* return TRUE; */
/* } */

/* if (lpDS != NULL) { */
/* Msg( ("DSEnable, already enabled")); */
/* return TRUE; */
/* } */

/* dsrval = DirectSoundCreate (NULL, &lpDS, NULL); */

/* if (dsrval != DS_OK) { */

/* if (dsrval == DSERR_INVALIDPARAM) */
/* TRACE ("DSERR_INVALIDPARAM"); */
/* if (dsrval == DSERR_ALLOCATED) */
/* TRACE ("DSERR_ALLOCATED"); */
/* if (dsrval == DSERR_OUTOFMEMORY) */
/* TRACE ("DSERR_OUTOFMEMORY"); */
/* if (dsrval == DSERR_NODRIVER) */
/* TRACE ("DSERR_NODRIVER"); */

/* TRACE ("DirectSoundCreate FAILED"); */
/* return FALSE; */
/* } */


/* dsrval = lpDS->SetCooperativeLevel (hwnd, DSSCL_NORMAL); */

/* if (dsrval != DS_OK) { */
/* DSDisable (); */
/* Msg( ("SetCooperativeLevel FAILED")); */
/* return FALSE; */
/* } */

/* return TRUE; */

}				/* DSEnable */
