/*
 * Decompiled with CFR 0.152.
 */
package vncviewer;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Event;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import vncviewer.Dialog;
import vncviewer.OptionsDialogCallback;

class OptionsDialog
extends Dialog {
    OptionsDialogCallback cb;
    GridBagLayout mainGB;
    GridBagConstraints mainGBC;
    GridBagLayout panelGB;
    GridBagConstraints panelGBC;
    Panel panel;
    Checkbox autoSelect;
    Checkbox fullColour;
    CheckboxGroup encodingGroup;
    Checkbox zrle;
    Checkbox hextile;
    Checkbox raw;
    Checkbox viewOnly;
    Checkbox acceptClipboard;
    Checkbox sendClipboard;
    Checkbox shared;
    Checkbox useLocalCursor;
    Button okButton;
    Button cancelButton;

    public OptionsDialog(OptionsDialogCallback optionsDialogCallback) {
        super(false);
        this.cb = optionsDialogCallback;
        this.setTitle("VNC Viewer: Connection Options");
        this.mainGB = new GridBagLayout();
        this.setLayout(this.mainGB);
        this.mainGBC = new GridBagConstraints();
        this.mainGBC.gridwidth = 0;
        this.mainGBC.anchor = 17;
        this.mainGBC.ipadx = 2;
        this.mainGBC.ipady = 2;
        this.startPanel("Format and Encoding:");
        this.autoSelect = this.addCheckbox("Auto select");
        this.fullColour = this.addCheckbox("Full colour");
        this.encodingGroup = new CheckboxGroup();
        this.zrle = this.addRadioCheckbox("ZRLE", this.encodingGroup);
        this.hextile = this.addRadioCheckbox("Hextile", this.encodingGroup);
        this.raw = this.addRadioCheckbox("Raw", this.encodingGroup);
        this.startPanel("Inputs:");
        this.viewOnly = this.addCheckbox("View only (ignore mouse & keyboard)");
        this.acceptClipboard = this.addCheckbox("Accept clipboard from server");
        this.sendClipboard = this.addCheckbox("Send clipboard to server");
        this.startPanel("Misc:");
        this.shared = this.addCheckbox("Shared (don't disconnect other viewers)");
        this.useLocalCursor = this.addCheckbox("Render cursor locally");
        Panel panel = new Panel();
        this.okButton = new Button("OK");
        panel.add(this.okButton);
        this.cancelButton = new Button("Cancel");
        panel.add(this.cancelButton);
        this.add(panel);
        this.pack();
    }

    public void initDialog() {
        if (this.cb != null) {
            this.cb.setOptions();
        }
        this.zrle.setEnabled(!this.autoSelect.getState());
        this.hextile.setEnabled(!this.autoSelect.getState());
        this.raw.setEnabled(!this.autoSelect.getState());
    }

    void startPanel(String string) {
        this.panelGB = new GridBagLayout();
        this.panel = new Panel(this.panelGB);
        this.mainGB.setConstraints(this.panel, this.mainGBC);
        this.add(this.panel);
        this.panelGBC = new GridBagConstraints();
        this.panelGBC.gridwidth = 0;
        this.panelGBC.anchor = 17;
        this.panelGBC.ipadx = 2;
        this.panelGBC.ipady = 2;
        Label label = new Label(string);
        this.panelGB.setConstraints(label, this.panelGBC);
        this.panel.add(label);
    }

    Checkbox addCheckbox(String string) {
        Checkbox checkbox = new Checkbox(string);
        this.panelGB.setConstraints(checkbox, this.panelGBC);
        this.panel.add(checkbox);
        return checkbox;
    }

    Checkbox addRadioCheckbox(String string, CheckboxGroup checkboxGroup) {
        Checkbox checkbox = new Checkbox(string, checkboxGroup, false);
        this.panelGB.setConstraints(checkbox, this.panelGBC);
        this.panel.add(checkbox);
        return checkbox;
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.okButton) {
            this.ok = true;
            if (this.cb != null) {
                this.cb.getOptions();
            }
            this.endDialog();
        } else if (event.target == this.cancelButton) {
            this.ok = false;
            this.endDialog();
        } else if (event.target == this.autoSelect) {
            this.zrle.setEnabled(!this.autoSelect.getState());
            this.hextile.setEnabled(!this.autoSelect.getState());
            this.raw.setEnabled(!this.autoSelect.getState());
        }
        return true;
    }
}

