/* rygel-item-creator.c generated by valac 0.10.0, the Vala compiler
 * generated from rygel-item-creator.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <libgupnp/gupnp.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <gst/gst.h>


#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_ITEM_CREATOR (rygel_item_creator_get_type ())
#define RYGEL_ITEM_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_CREATOR, RygelItemCreator))
#define RYGEL_ITEM_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_CREATOR, RygelItemCreatorClass))
#define RYGEL_IS_ITEM_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_CREATOR))
#define RYGEL_IS_ITEM_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_CREATOR))
#define RYGEL_ITEM_CREATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_CREATOR, RygelItemCreatorClass))

typedef struct _RygelItemCreator RygelItemCreator;
typedef struct _RygelItemCreatorClass RygelItemCreatorClass;
typedef struct _RygelItemCreatorPrivate RygelItemCreatorPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelContentDirectoryPrivate RygelContentDirectoryPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelItemCreatorRunData RygelItemCreatorRunData;
typedef struct _RygelItemCreatorParseArgsData RygelItemCreatorParseArgsData;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelItemCreatorFetchContainerData RygelItemCreatorFetchContainerData;

#define RYGEL_TYPE_IMAGE_ITEM (rygel_image_item_get_type ())
#define RYGEL_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_IMAGE_ITEM, RygelImageItem))
#define RYGEL_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_IMAGE_ITEM, RygelImageItemClass))
#define RYGEL_IS_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_IMAGE_ITEM))
#define RYGEL_IS_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_IMAGE_ITEM))
#define RYGEL_IMAGE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_IMAGE_ITEM, RygelImageItemClass))

typedef struct _RygelImageItem RygelImageItem;
typedef struct _RygelImageItemClass RygelImageItemClass;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;

#define RYGEL_TYPE_PHOTO_ITEM (rygel_photo_item_get_type ())
#define RYGEL_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItem))
#define RYGEL_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItemClass))
#define RYGEL_IS_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PHOTO_ITEM))
#define RYGEL_IS_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PHOTO_ITEM))
#define RYGEL_PHOTO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItemClass))

typedef struct _RygelPhotoItem RygelPhotoItem;
typedef struct _RygelPhotoItemClass RygelPhotoItemClass;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;

typedef enum  {
	RYGEL_ITEM_CREATOR_ERROR_PARSE
} RygelItemCreatorError;
#define RYGEL_ITEM_CREATOR_ERROR rygel_item_creator_error_quark ()
struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelItemCreator {
	GObject parent_instance;
	RygelItemCreatorPrivate * priv;
	char* container_id;
	char* elements;
	GUPnPDIDLLiteItem* didl_item;
	RygelMediaItem* item;
};

struct _RygelItemCreatorClass {
	GObjectClass parent_class;
};

struct _RygelItemCreatorPrivate {
	RygelContentDirectory* content_dir;
	GUPnPServiceAction* action;
	GUPnPDIDLLiteWriter* didl_writer;
	GUPnPDIDLLiteParser* didl_parser;
	GCancellable* _cancellable;
};

struct _RygelContentDirectory {
	GUPnPService parent_instance;
	RygelContentDirectoryPrivate * priv;
	char* feature_list;
	RygelHTTPServer* http_server;
	RygelMediaContainer* root_container;
	GCancellable* cancellable;
	guint32 system_update_id;
};

struct _RygelContentDirectoryClass {
	GUPnPServiceClass parent_class;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	char* id;
	char* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const char* property);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	char* date;
	char* mime_type;
	char* dlna_profile;
	gint64 size;
	gboolean place_holder;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const char* uri);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const char* uri, const char* protocol, const char* import_uri, GError** error);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const char* uri, const char* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelItemCreatorRunData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemCreator* self;
	char* message;
	RygelMediaContainer* container;
	RygelMediaItem* _tmp0_;
	RygelMediaItem* _tmp1_;
	GList* resources;
	GUPnPProtocolInfo* info;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	GUPnPDIDLLiteObject* _tmp5_;
	GError * err;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
struct _RygelItemCreatorParseArgsData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemCreator* self;
	GError * _inner_error_;
};

struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	char* (*to_string) (RygelSearchExpression* self);
};

struct _RygelItemCreatorFetchContainerData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemCreator* self;
	RygelMediaContainer* result;
	RygelMediaObject* media_object;
	RygelRelationalExpression* expression;
	char* _tmp0_;
	char* _tmp1_;
	guint total_matches;
	RygelMediaObjects* _result_;
	RygelMediaObject* _tmp2_;
	char* _tmp3_;
	RygelMediaObject* _tmp4_;
	RygelMediaObject* _tmp5_;
	gboolean _tmp6_;
	RygelMediaObject* _tmp7_;
	GError * _inner_error_;
};


static GPatternSpec* rygel_item_creator_comment_pattern;
static GPatternSpec* rygel_item_creator_comment_pattern = NULL;
static gpointer rygel_item_creator_parent_class = NULL;
static RygelStateMachineIface* rygel_item_creator_rygel_state_machine_parent_iface = NULL;

GQuark rygel_item_creator_error_quark (void);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_item_creator_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
#define RYGEL_ITEM_CREATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_ITEM_CREATOR, RygelItemCreatorPrivate))
enum  {
	RYGEL_ITEM_CREATOR_DUMMY_PROPERTY,
	RYGEL_ITEM_CREATOR_CANCELLABLE
};
RygelItemCreator* rygel_item_creator_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelItemCreator* rygel_item_creator_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
static void rygel_item_creator_real_run_data_free (gpointer _data);
static void rygel_item_creator_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_item_creator_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_item_creator_real_run_co (RygelItemCreatorRunData* data);
static void rygel_item_creator_parse_args (RygelItemCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_item_creator_parse_args_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error);
static void _lambda7_ (GUPnPDIDLLiteItem* didl_item, RygelItemCreator* self);
static void __lambda7__gupnp_didl_lite_parser_item_available (GUPnPDIDLLiteParser* _sender, GUPnPDIDLLiteItem* item, gpointer self);
static void rygel_item_creator_fetch_container (RygelItemCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static RygelMediaContainer* rygel_item_creator_fetch_container_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error);
static RygelMediaItem* rygel_item_creator_create_item (RygelItemCreator* self, const char* id, RygelMediaContainer* parent, const char* title, const char* upnp_class, GError** error);
static char* rygel_item_creator_get_generic_mime_type (RygelItemCreator* self);
void rygel_media_container_add_item (RygelMediaContainer* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_media_container_add_item_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void _g_list_free_g_object_unref (GList* self);
GUPnPDIDLLiteObject* rygel_media_object_serialize (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
static void rygel_item_creator_conclude (RygelItemCreator* self);
static void rygel_item_creator_handle_error (RygelItemCreator* self, GError* _error_);
static void rygel_item_creator_parse_args_data_free (gpointer _data);
static void rygel_item_creator_parse_args_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_item_creator_parse_args_co (RygelItemCreatorParseArgsData* data);
GQuark rygel_content_directory_error_quark (void);
static void rygel_item_creator_fetch_container_data_free (gpointer _data);
static void rygel_item_creator_fetch_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_item_creator_fetch_container_co (RygelItemCreatorFetchContainerData* data);
RygelRelationalExpression* rygel_relational_expression_new (void);
RygelRelationalExpression* rygel_relational_expression_construct (GType object_type);
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_relational_expression_get_type (void) G_GNUC_CONST;
void rygel_media_container_search (RygelMediaContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
RygelMediaObjects* rygel_media_container_search_finish (RygelMediaContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
void rygel_media_container_find_object (RygelMediaContainer* self, const char* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
GType rygel_image_item_get_type (void) G_GNUC_CONST;
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_video_item_get_type (void) G_GNUC_CONST;
#define RYGEL_IMAGE_ITEM_UPNP_CLASS "object.item.imageItem"
RygelImageItem* rygel_image_item_new (const char* id, RygelMediaContainer* parent, const char* title, const char* upnp_class);
RygelImageItem* rygel_image_item_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, const char* upnp_class);
#define RYGEL_PHOTO_ITEM_UPNP_CLASS "object.item.imageItem.photo"
RygelPhotoItem* rygel_photo_item_new (const char* id, RygelMediaContainer* parent, const char* title, const char* upnp_class);
RygelPhotoItem* rygel_photo_item_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, const char* upnp_class);
GType rygel_photo_item_get_type (void) G_GNUC_CONST;
#define RYGEL_VIDEO_ITEM_UPNP_CLASS "object.item.videoItem"
RygelVideoItem* rygel_video_item_new (const char* id, RygelMediaContainer* parent, const char* title, const char* upnp_class);
RygelVideoItem* rygel_video_item_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, const char* upnp_class);
#define RYGEL_AUDIO_ITEM_UPNP_CLASS "object.item.audioItem"
RygelAudioItem* rygel_audio_item_new (const char* id, RygelMediaContainer* parent, const char* title, const char* upnp_class);
RygelAudioItem* rygel_audio_item_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, const char* upnp_class);
#define RYGEL_MUSIC_ITEM_UPNP_CLASS "object.item.audioItem.musicTrack"
RygelMusicItem* rygel_music_item_new (const char* id, RygelMediaContainer* parent, const char* title, const char* upnp_class);
RygelMusicItem* rygel_music_item_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, const char* upnp_class);
GType rygel_music_item_get_type (void) G_GNUC_CONST;
static void rygel_item_creator_finalize (GObject* obj);
static void rygel_item_creator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void rygel_item_creator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



GQuark rygel_item_creator_error_quark (void) {
	return g_quark_from_static_string ("rygel_item_creator_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 49 "rygel-item-creator.vala"
RygelItemCreator* rygel_item_creator_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
#line 469 "rygel-item-creator.c"
	RygelItemCreator * self;
	RygelContentDirectory* _tmp0_;
	GUPnPServiceAction* _tmp1_;
	GUPnPDIDLLiteWriter* _tmp2_;
	GUPnPDIDLLiteParser* _tmp3_;
#line 49 "rygel-item-creator.vala"
	g_return_val_if_fail (content_dir != NULL, NULL);
#line 49 "rygel-item-creator.vala"
	g_return_val_if_fail (action != NULL, NULL);
#line 49 "rygel-item-creator.vala"
	self = (RygelItemCreator*) g_object_new (object_type, NULL);
#line 51 "rygel-item-creator.vala"
	self->priv->content_dir = (_tmp0_ = _g_object_ref0 (content_dir), _g_object_unref0 (self->priv->content_dir), _tmp0_);
#line 52 "rygel-item-creator.vala"
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, content_dir->cancellable);
#line 53 "rygel-item-creator.vala"
	self->priv->action = (_tmp1_ = action, action = NULL, _tmp1_);
#line 54 "rygel-item-creator.vala"
	self->priv->didl_writer = (_tmp2_ = gupnp_didl_lite_writer_new (NULL), _g_object_unref0 (self->priv->didl_writer), _tmp2_);
#line 55 "rygel-item-creator.vala"
	self->priv->didl_parser = (_tmp3_ = gupnp_didl_lite_parser_new (), _g_object_unref0 (self->priv->didl_parser), _tmp3_);
#line 491 "rygel-item-creator.c"
	return self;
}


#line 49 "rygel-item-creator.vala"
RygelItemCreator* rygel_item_creator_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
#line 49 "rygel-item-creator.vala"
	return rygel_item_creator_construct (RYGEL_TYPE_ITEM_CREATOR, content_dir, action);
#line 500 "rygel-item-creator.c"
}


static void rygel_item_creator_real_run_data_free (gpointer _data) {
	RygelItemCreatorRunData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (RygelItemCreatorRunData, data);
}


static void rygel_item_creator_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemCreator * self;
	RygelItemCreatorRunData* _data_;
	self = (RygelItemCreator*) base;
	_data_ = g_slice_new0 (RygelItemCreatorRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_creator_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_creator_real_run_data_free);
	_data_->self = g_object_ref (self);
	rygel_item_creator_real_run_co (_data_);
}


static void rygel_item_creator_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelItemCreatorRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_item_creator_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemCreatorRunData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_item_creator_real_run_co (data);
}


#line 62 "rygel-item-creator.vala"
static void _lambda7_ (GUPnPDIDLLiteItem* didl_item, RygelItemCreator* self) {
#line 540 "rygel-item-creator.c"
	GUPnPDIDLLiteItem* _tmp0_;
#line 62 "rygel-item-creator.vala"
	g_return_if_fail (didl_item != NULL);
#line 63 "rygel-item-creator.vala"
	self->didl_item = (_tmp0_ = _g_object_ref0 (didl_item), _g_object_unref0 (self->didl_item), _tmp0_);
#line 546 "rygel-item-creator.c"
}


#line 62 "rygel-item-creator.vala"
static void __lambda7__gupnp_didl_lite_parser_item_available (GUPnPDIDLLiteParser* _sender, GUPnPDIDLLiteItem* item, gpointer self) {
#line 552 "rygel-item-creator.c"
	_lambda7_ (item, self);
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


static gboolean rygel_item_creator_real_run_co (RygelItemCreatorRunData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 40:
		goto _state_40;
		case 41:
		goto _state_41;
	}
	_state_0:
	{
#line 60 "rygel-item-creator.vala"
		rygel_item_creator_parse_args (data->self, NULL, NULL);
#line 62 "rygel-item-creator.vala"
		g_signal_connect_object (data->self->priv->didl_parser, "item-available", (GCallback) __lambda7__gupnp_didl_lite_parser_item_available, data->self, 0);
#line 65 "rygel-item-creator.vala"
		gupnp_didl_lite_parser_parse_didl (data->self->priv->didl_parser, data->self->elements, &data->_inner_error_);
#line 582 "rygel-item-creator.c"
		if (data->_inner_error_ != NULL) {
			goto __catch53_g_error;
		}
#line 66 "rygel-item-creator.vala"
		if (data->self->didl_item == NULL) {
#line 588 "rygel-item-creator.c"
			data->message = g_strdup (_ ("No items in DIDL-Lite from client: '%s'"));
			data->_inner_error_ = g_error_new (RYGEL_ITEM_CREATOR_ERROR, RYGEL_ITEM_CREATOR_ERROR_PARSE, data->message, data->self->elements);
			{
				_g_free0 (data->message);
				goto __catch53_g_error;
			}
			_g_free0 (data->message);
		}
		data->_state_ = 40;
		rygel_item_creator_fetch_container (data->self, rygel_item_creator_run_ready, data);
		return FALSE;
		_state_40:
		data->container = rygel_item_creator_fetch_container_finish (data->self, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			goto __catch53_g_error;
		}
		data->_tmp0_ = rygel_item_creator_create_item (data->self, gupnp_didl_lite_object_get_id ((GUPnPDIDLLiteObject*) data->self->didl_item), data->container, gupnp_didl_lite_object_get_title ((GUPnPDIDLLiteObject*) data->self->didl_item), gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) data->self->didl_item), &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			_g_object_unref0 (data->container);
			goto __catch53_g_error;
		}
#line 74 "rygel-item-creator.vala"
		data->self->item = (data->_tmp1_ = data->_tmp0_, _g_object_unref0 (data->self->item), data->_tmp1_);
#line 612 "rygel-item-creator.c"
		data->resources = gupnp_didl_lite_object_get_resources ((GUPnPDIDLLiteObject*) data->self->didl_item);
#line 80 "rygel-item-creator.vala"
		if (data->resources != NULL) {
#line 616 "rygel-item-creator.c"
			data->info = _g_object_ref0 (gupnp_didl_lite_resource_get_protocol_info ((GUPnPDIDLLiteResource*) g_list_nth (data->resources, (guint) 0)->data));
#line 83 "rygel-item-creator.vala"
			if (data->info != NULL) {
#line 84 "rygel-item-creator.vala"
				if (gupnp_protocol_info_get_dlna_profile (data->info) != NULL) {
#line 85 "rygel-item-creator.vala"
					data->self->item->dlna_profile = (data->_tmp2_ = g_strdup (gupnp_protocol_info_get_dlna_profile (data->info)), _g_free0 (data->self->item->dlna_profile), data->_tmp2_);
#line 624 "rygel-item-creator.c"
				}
#line 88 "rygel-item-creator.vala"
				if (gupnp_protocol_info_get_mime_type (data->info) != NULL) {
#line 89 "rygel-item-creator.vala"
					data->self->item->mime_type = (data->_tmp3_ = g_strdup (gupnp_protocol_info_get_mime_type (data->info)), _g_free0 (data->self->item->mime_type), data->_tmp3_);
#line 630 "rygel-item-creator.c"
				}
			}
			_g_object_unref0 (data->info);
		}
#line 94 "rygel-item-creator.vala"
		if (data->self->item->mime_type == NULL) {
#line 95 "rygel-item-creator.vala"
			data->self->item->mime_type = (data->_tmp4_ = rygel_item_creator_get_generic_mime_type (data->self), _g_free0 (data->self->item->mime_type), data->_tmp4_);
#line 639 "rygel-item-creator.c"
		}
#line 98 "rygel-item-creator.vala"
		data->self->item->place_holder = TRUE;
#line 643 "rygel-item-creator.c"
		data->_state_ = 41;
		rygel_media_container_add_item (data->container, data->self->item, rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self), rygel_item_creator_run_ready, data);
		return FALSE;
		_state_41:
#line 100 "rygel-item-creator.vala"
		rygel_media_container_add_item_finish (data->container, data->_res_, &data->_inner_error_);
#line 650 "rygel-item-creator.c"
		if (data->_inner_error_ != NULL) {
			__g_list_free_g_object_unref0 (data->resources);
			_g_object_unref0 (data->container);
			goto __catch53_g_error;
		}
#line 101 "rygel-item-creator.vala"
		data->_tmp5_ = rygel_media_object_serialize ((RygelMediaObject*) data->self->item, data->self->priv->didl_writer, data->self->priv->content_dir->http_server, &data->_inner_error_);
#line 658 "rygel-item-creator.c"
		_g_object_unref0 (data->_tmp5_);
		if (data->_inner_error_ != NULL) {
			__g_list_free_g_object_unref0 (data->resources);
			_g_object_unref0 (data->container);
			goto __catch53_g_error;
		}
#line 104 "rygel-item-creator.vala"
		rygel_item_creator_conclude (data->self);
#line 667 "rygel-item-creator.c"
		__g_list_free_g_object_unref0 (data->resources);
		_g_object_unref0 (data->container);
	}
	goto __finally53;
	__catch53_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		{
#line 106 "rygel-item-creator.vala"
			rygel_item_creator_handle_error (data->self, data->err);
#line 679 "rygel-item-creator.c"
			_g_error_free0 (data->err);
		}
	}
	__finally53:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void rygel_item_creator_parse_args_data_free (gpointer _data) {
	RygelItemCreatorParseArgsData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (RygelItemCreatorParseArgsData, data);
}


static void rygel_item_creator_parse_args (RygelItemCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemCreatorParseArgsData* _data_;
	_data_ = g_slice_new0 (RygelItemCreatorParseArgsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_creator_parse_args);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_creator_parse_args_data_free);
	_data_->self = g_object_ref (self);
	rygel_item_creator_parse_args_co (_data_);
}


static void rygel_item_creator_parse_args_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error) {
	RygelItemCreatorParseArgsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_item_creator_parse_args_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemCreatorParseArgsData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_item_creator_parse_args_co (data);
}


static gboolean rygel_item_creator_parse_args_co (RygelItemCreatorParseArgsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
#line 112 "rygel-item-creator.vala"
	gupnp_service_action_get (data->self->priv->action, "ContainerID", G_TYPE_STRING, &data->self->container_id, "Elements", G_TYPE_STRING, &data->self->elements, NULL);
#line 115 "rygel-item-creator.vala"
	if (data->self->elements == NULL) {
#line 748 "rygel-item-creator.c"
		data->_inner_error_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _ ("'Elements' argument missing."));
		{
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
	} else {
#line 118 "rygel-item-creator.vala"
		if (g_pattern_match_string (rygel_item_creator_comment_pattern, data->self->elements)) {
#line 766 "rygel-item-creator.c"
			data->_inner_error_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _ ("Comments not allowed in XML"));
			{
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
		}
	}
#line 123 "rygel-item-creator.vala"
	if (data->self->container_id == NULL) {
#line 785 "rygel-item-creator.c"
		data->_inner_error_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, _ ("No such object"));
		{
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void rygel_item_creator_fetch_container_data_free (gpointer _data) {
	RygelItemCreatorFetchContainerData* data;
	data = _data;
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (RygelItemCreatorFetchContainerData, data);
}


static void rygel_item_creator_fetch_container (RygelItemCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemCreatorFetchContainerData* _data_;
	_data_ = g_slice_new0 (RygelItemCreatorFetchContainerData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_creator_fetch_container);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_creator_fetch_container_data_free);
	_data_->self = g_object_ref (self);
	rygel_item_creator_fetch_container_co (_data_);
}


static RygelMediaContainer* rygel_item_creator_fetch_container_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error) {
	RygelMediaContainer* result;
	RygelItemCreatorFetchContainerData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_item_creator_fetch_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemCreatorFetchContainerData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_item_creator_fetch_container_co (data);
}


static gboolean rygel_item_creator_fetch_container_co (RygelItemCreatorFetchContainerData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 42:
		goto _state_42;
		case 43:
		goto _state_43;
	}
	_state_0:
	data->media_object = NULL;
#line 133 "rygel-item-creator.vala"
	if (_vala_strcmp0 (data->self->container_id, "DLNA.ORG_AnyContainer") == 0) {
#line 868 "rygel-item-creator.c"
		data->expression = rygel_relational_expression_new ();
#line 135 "rygel-item-creator.vala"
		((RygelSearchExpression*) data->expression)->op = GINT_TO_POINTER (GUPNP_SEARCH_CRITERIA_OP_DERIVED_FROM);
#line 136 "rygel-item-creator.vala"
		((RygelSearchExpression*) data->expression)->operand1 = (data->_tmp0_ = g_strdup ("upnp:createClass"), _g_free0 (((RygelSearchExpression*) data->expression)->operand1), data->_tmp0_);
#line 137 "rygel-item-creator.vala"
		((RygelSearchExpression*) data->expression)->operand2 = (data->_tmp1_ = g_strdup (gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) data->self->didl_item)), _g_free0 (((RygelSearchExpression*) data->expression)->operand2), data->_tmp1_);
#line 876 "rygel-item-creator.c"
		data->_state_ = 42;
		rygel_media_container_search (data->self->priv->content_dir->root_container, (RygelSearchExpression*) data->expression, (guint) 0, (guint) 1, rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self), rygel_item_creator_fetch_container_ready, data);
		return FALSE;
		_state_42:
		data->_result_ = rygel_media_container_search_finish (data->self->priv->content_dir->root_container, data->_res_, &data->total_matches, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_rygel_search_expression_unref0 (data->expression);
			_g_object_unref0 (data->media_object);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
#line 147 "rygel-item-creator.vala"
		if (gee_collection_get_size ((GeeCollection*) data->_result_) > 0) {
#line 148 "rygel-item-creator.vala"
			data->media_object = (data->_tmp2_ = (RygelMediaObject*) gee_abstract_list_get ((GeeAbstractList*) data->_result_, 0), _g_object_unref0 (data->media_object), data->_tmp2_);
#line 149 "rygel-item-creator.vala"
			data->self->container_id = (data->_tmp3_ = g_strdup (data->media_object->id), _g_free0 (data->self->container_id), data->_tmp3_);
#line 903 "rygel-item-creator.c"
		}
		_g_object_unref0 (data->_result_);
		_rygel_search_expression_unref0 (data->expression);
	} else {
		data->_state_ = 43;
		rygel_media_container_find_object (data->self->priv->content_dir->root_container, data->self->container_id, rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self), rygel_item_creator_fetch_container_ready, data);
		return FALSE;
		_state_43:
		data->_tmp4_ = rygel_media_container_find_object_finish (data->self->priv->content_dir->root_container, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->media_object);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
#line 152 "rygel-item-creator.vala"
		data->media_object = (data->_tmp5_ = data->_tmp4_, _g_object_unref0 (data->media_object), data->_tmp5_);
#line 929 "rygel-item-creator.c"
	}
#line 157 "rygel-item-creator.vala"
	if (data->media_object == NULL) {
#line 157 "rygel-item-creator.vala"
		data->_tmp6_ = TRUE;
#line 935 "rygel-item-creator.c"
	} else {
#line 157 "rygel-item-creator.vala"
		data->_tmp6_ = !RYGEL_IS_MEDIA_CONTAINER (data->media_object);
#line 939 "rygel-item-creator.c"
	}
#line 157 "rygel-item-creator.vala"
	if (data->_tmp6_) {
#line 943 "rygel-item-creator.c"
		data->_inner_error_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, _ ("No such object"));
		{
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->media_object);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
	}
	data->result = _g_object_ref0 ((data->_tmp7_ = data->media_object, RYGEL_IS_MEDIA_CONTAINER (data->_tmp7_) ? ((RygelMediaContainer*) data->_tmp7_) : NULL));
	_g_object_unref0 (data->media_object);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	_g_object_unref0 (data->media_object);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


#line 165 "rygel-item-creator.vala"
static void rygel_item_creator_conclude (RygelItemCreator* self) {
#line 986 "rygel-item-creator.c"
	char* didl;
#line 165 "rygel-item-creator.vala"
	g_return_if_fail (self != NULL);
#line 167 "rygel-item-creator.vala"
	didl = gupnp_didl_lite_writer_get_string (self->priv->didl_writer);
#line 170 "rygel-item-creator.vala"
	gupnp_service_action_set (self->priv->action, "ObjectID", G_TYPE_STRING, ((RygelMediaObject*) self->item)->id, "Result", G_TYPE_STRING, didl, NULL);
#line 173 "rygel-item-creator.vala"
	gupnp_service_action_return (self->priv->action);
#line 174 "rygel-item-creator.vala"
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
#line 998 "rygel-item-creator.c"
	_g_free0 (didl);
}


#line 177 "rygel-item-creator.vala"
static void rygel_item_creator_handle_error (RygelItemCreator* self, GError* _error_) {
#line 177 "rygel-item-creator.vala"
	g_return_if_fail (self != NULL);
#line 178 "rygel-item-creator.vala"
	if (_error_->domain == RYGEL_CONTENT_DIRECTORY_ERROR) {
#line 179 "rygel-item-creator.vala"
		gupnp_service_action_return_error (self->priv->action, (guint) _error_->code, _error_->message);
#line 1011 "rygel-item-creator.c"
	} else {
#line 181 "rygel-item-creator.vala"
		gupnp_service_action_return_error (self->priv->action, (guint) 701, _error_->message);
#line 1015 "rygel-item-creator.c"
	}
#line 184 "rygel-item-creator.vala"
	g_warning (_ ("Failed to create item under '%s': %s"), self->container_id, _error_->message);
#line 188 "rygel-item-creator.vala"
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
#line 1021 "rygel-item-creator.c"
}


#line 191 "rygel-item-creator.vala"
static char* rygel_item_creator_get_generic_mime_type (RygelItemCreator* self) {
#line 1027 "rygel-item-creator.c"
	char* result = NULL;
#line 191 "rygel-item-creator.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 192 "rygel-item-creator.vala"
	if (RYGEL_IS_IMAGE_ITEM (self->item)) {
#line 1033 "rygel-item-creator.c"
		result = g_strdup ("image");
#line 193 "rygel-item-creator.vala"
		return result;
#line 1037 "rygel-item-creator.c"
	} else {
#line 194 "rygel-item-creator.vala"
		if (RYGEL_IS_VIDEO_ITEM (self->item)) {
#line 1041 "rygel-item-creator.c"
			result = g_strdup ("video");
#line 195 "rygel-item-creator.vala"
			return result;
#line 1045 "rygel-item-creator.c"
		} else {
			result = g_strdup ("audio");
#line 197 "rygel-item-creator.vala"
			return result;
#line 1050 "rygel-item-creator.c"
		}
	}
}


#line 201 "rygel-item-creator.vala"
static RygelMediaItem* rygel_item_creator_create_item (RygelItemCreator* self, const char* id, RygelMediaContainer* parent, const char* title, const char* upnp_class, GError** error) {
#line 1058 "rygel-item-creator.c"
	RygelMediaItem* result = NULL;
	const char* _tmp0_;
	GQuark _tmp1_;
	GError * _inner_error_ = NULL;
#line 201 "rygel-item-creator.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 201 "rygel-item-creator.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 201 "rygel-item-creator.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 201 "rygel-item-creator.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 201 "rygel-item-creator.vala"
	g_return_val_if_fail (upnp_class != NULL, NULL);
#line 1073 "rygel-item-creator.c"
	_tmp0_ = upnp_class;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp1_ == g_quark_from_string (RYGEL_IMAGE_ITEM_UPNP_CLASS))
	switch (0) {
		default:
		{
			result = (RygelMediaItem*) rygel_image_item_new (id, parent, title, RYGEL_IMAGE_ITEM_UPNP_CLASS);
#line 207 "rygel-item-creator.vala"
			return result;
#line 1083 "rygel-item-creator.c"
		}
	} else if (_tmp1_ == g_quark_from_string (RYGEL_PHOTO_ITEM_UPNP_CLASS))
	switch (0) {
		default:
		{
			result = (RygelMediaItem*) rygel_photo_item_new (id, parent, title, RYGEL_PHOTO_ITEM_UPNP_CLASS);
#line 209 "rygel-item-creator.vala"
			return result;
#line 1092 "rygel-item-creator.c"
		}
	} else if (_tmp1_ == g_quark_from_string (RYGEL_VIDEO_ITEM_UPNP_CLASS))
	switch (0) {
		default:
		{
			result = (RygelMediaItem*) rygel_video_item_new (id, parent, title, RYGEL_VIDEO_ITEM_UPNP_CLASS);
#line 211 "rygel-item-creator.vala"
			return result;
#line 1101 "rygel-item-creator.c"
		}
	} else if (_tmp1_ == g_quark_from_string (RYGEL_AUDIO_ITEM_UPNP_CLASS))
	switch (0) {
		default:
		{
			result = (RygelMediaItem*) rygel_audio_item_new (id, parent, title, RYGEL_AUDIO_ITEM_UPNP_CLASS);
#line 213 "rygel-item-creator.vala"
			return result;
#line 1110 "rygel-item-creator.c"
		}
	} else if (_tmp1_ == g_quark_from_string (RYGEL_MUSIC_ITEM_UPNP_CLASS))
	switch (0) {
		default:
		{
			result = (RygelMediaItem*) rygel_music_item_new (id, parent, title, RYGEL_MUSIC_ITEM_UPNP_CLASS);
#line 215 "rygel-item-creator.vala"
			return result;
#line 1119 "rygel-item-creator.c"
		}
	} else
	switch (0) {
		default:
		{
			_inner_error_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Creation of item of class '%s' " "not supported.", upnp_class);
			{
				g_propagate_error (error, _inner_error_);
				return NULL;
			}
		}
	}
}


static GCancellable* rygel_item_creator_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelItemCreator* self;
	self = (RygelItemCreator*) base;
	result = self->priv->_cancellable;
#line 47 "rygel-item-creator.vala"
	return result;
#line 1142 "rygel-item-creator.c"
}


static void rygel_item_creator_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelItemCreator* self;
	GCancellable* _tmp0_;
	self = (RygelItemCreator*) base;
	self->priv->_cancellable = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_cancellable), _tmp0_);
	g_object_notify ((GObject *) self, "cancellable");
}


static void rygel_item_creator_class_init (RygelItemCreatorClass * klass) {
	rygel_item_creator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelItemCreatorPrivate));
	G_OBJECT_CLASS (klass)->get_property = rygel_item_creator_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_item_creator_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_item_creator_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_ITEM_CREATOR_CANCELLABLE, "cancellable");
	rygel_item_creator_comment_pattern = g_pattern_spec_new ("*<!--*-->*");
}


static void rygel_item_creator_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_item_creator_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = rygel_item_creator_real_run;
	iface->run_finish = rygel_item_creator_real_run_finish;
	iface->get_cancellable = rygel_item_creator_real_get_cancellable;
	iface->set_cancellable = rygel_item_creator_real_set_cancellable;
}


static void rygel_item_creator_instance_init (RygelItemCreator * self) {
	self->priv = RYGEL_ITEM_CREATOR_GET_PRIVATE (self);
}


static void rygel_item_creator_finalize (GObject* obj) {
	RygelItemCreator * self;
	self = RYGEL_ITEM_CREATOR (obj);
	_g_free0 (self->container_id);
	_g_free0 (self->elements);
	_g_object_unref0 (self->didl_item);
	_g_object_unref0 (self->item);
	_g_object_unref0 (self->priv->content_dir);
	_g_object_unref0 (self->priv->didl_writer);
	_g_object_unref0 (self->priv->didl_parser);
	_g_object_unref0 (self->priv->_cancellable);
	G_OBJECT_CLASS (rygel_item_creator_parent_class)->finalize (obj);
}


/**
 * CreateObject action implementation.
 */
GType rygel_item_creator_get_type (void) {
	static volatile gsize rygel_item_creator_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_item_creator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelItemCreatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_item_creator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelItemCreator), 0, (GInstanceInitFunc) rygel_item_creator_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_item_creator_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_item_creator_type_id;
		rygel_item_creator_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelItemCreator", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_item_creator_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_item_creator_type_id__volatile, rygel_item_creator_type_id);
	}
	return rygel_item_creator_type_id__volatile;
}


static void rygel_item_creator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelItemCreator * self;
	self = RYGEL_ITEM_CREATOR (object);
	switch (property_id) {
		case RYGEL_ITEM_CREATOR_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void rygel_item_creator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelItemCreator * self;
	self = RYGEL_ITEM_CREATOR (object);
	switch (property_id) {
		case RYGEL_ITEM_CREATOR_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




