/* rygel-rendering-control.c generated by valac 0.9.6, the Vala compiler
 * generated from rygel-rendering-control.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_RENDERING_CONTROL (rygel_rendering_control_get_type ())
#define RYGEL_RENDERING_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RENDERING_CONTROL, RygelRenderingControl))
#define RYGEL_RENDERING_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RENDERING_CONTROL, RygelRenderingControlClass))
#define RYGEL_IS_RENDERING_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RENDERING_CONTROL))
#define RYGEL_IS_RENDERING_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RENDERING_CONTROL))
#define RYGEL_RENDERING_CONTROL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RENDERING_CONTROL, RygelRenderingControlClass))

typedef struct _RygelRenderingControl RygelRenderingControl;
typedef struct _RygelRenderingControlClass RygelRenderingControlClass;
typedef struct _RygelRenderingControlPrivate RygelRenderingControlPrivate;

#define RYGEL_TYPE_CHANGE_LOG (rygel_change_log_get_type ())
#define RYGEL_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CHANGE_LOG, RygelChangeLog))
#define RYGEL_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CHANGE_LOG, RygelChangeLogClass))
#define RYGEL_IS_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CHANGE_LOG))
#define RYGEL_IS_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CHANGE_LOG))
#define RYGEL_CHANGE_LOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CHANGE_LOG, RygelChangeLogClass))

typedef struct _RygelChangeLog RygelChangeLog;
typedef struct _RygelChangeLogClass RygelChangeLogClass;

#define RYGEL_TYPE_MEDIA_PLAYER (rygel_media_player_get_type ())
#define RYGEL_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayer))
#define RYGEL_IS_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_PLAYER))
#define RYGEL_MEDIA_PLAYER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayerIface))

typedef struct _RygelMediaPlayer RygelMediaPlayer;
typedef struct _RygelMediaPlayerIface RygelMediaPlayerIface;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_PLUGIN (rygel_plugin_get_type ())
#define RYGEL_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN, RygelPlugin))
#define RYGEL_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN, RygelPluginClass))
#define RYGEL_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN))
#define RYGEL_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN))
#define RYGEL_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN, RygelPluginClass))

typedef struct _RygelPlugin RygelPlugin;
typedef struct _RygelPluginClass RygelPluginClass;

#define RYGEL_TYPE_MEDIA_RENDERER_PLUGIN (rygel_media_renderer_plugin_get_type ())
#define RYGEL_MEDIA_RENDERER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPlugin))
#define RYGEL_MEDIA_RENDERER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPluginClass))
#define RYGEL_IS_MEDIA_RENDERER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN))
#define RYGEL_IS_MEDIA_RENDERER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN))
#define RYGEL_MEDIA_RENDERER_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPluginClass))

typedef struct _RygelMediaRendererPlugin RygelMediaRendererPlugin;
typedef struct _RygelMediaRendererPluginClass RygelMediaRendererPluginClass;

struct _RygelRenderingControl {
	GUPnPService parent_instance;
	RygelRenderingControlPrivate * priv;
};

struct _RygelRenderingControlClass {
	GUPnPServiceClass parent_class;
};

struct _RygelMediaPlayerIface {
	GTypeInterface parent_iface;
	gboolean (*seek) (RygelMediaPlayer* self, GstClockTime time);
	char** (*get_protocols) (RygelMediaPlayer* self, int* result_length1);
	char** (*get_mime_types) (RygelMediaPlayer* self, int* result_length1);
	char* (*get_playback_state) (RygelMediaPlayer* self);
	void (*set_playback_state) (RygelMediaPlayer* self, const char* value);
	char* (*get_uri) (RygelMediaPlayer* self);
	void (*set_uri) (RygelMediaPlayer* self, const char* value);
	double (*get_volume) (RygelMediaPlayer* self);
	void (*set_volume) (RygelMediaPlayer* self, double value);
	gint64 (*get_duration) (RygelMediaPlayer* self);
	gint64 (*get_position) (RygelMediaPlayer* self);
};

struct _RygelRenderingControlPrivate {
	gboolean _mute;
	guint _volume;
	char* preset_name_list;
	RygelChangeLog* changelog;
	RygelMediaPlayer* player;
};


static gpointer rygel_rendering_control_parent_class = NULL;

GType rygel_rendering_control_get_type (void) G_GNUC_CONST;
GType rygel_change_log_get_type (void) G_GNUC_CONST;
GType rygel_media_player_get_type (void) G_GNUC_CONST;
#define RYGEL_RENDERING_CONTROL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_RENDERING_CONTROL, RygelRenderingControlPrivate))
enum  {
	RYGEL_RENDERING_CONTROL_DUMMY_PROPERTY,
	RYGEL_RENDERING_CONTROL_MUTE,
	RYGEL_RENDERING_CONTROL_VOLUME
};
#define RYGEL_RENDERING_CONTROL_UPNP_ID "urn:upnp-org:serviceId:RenderingControl"
#define RYGEL_RENDERING_CONTROL_UPNP_TYPE "urn:schemas-upnp-org:service:RenderingControl:2"
#define RYGEL_RENDERING_CONTROL_DESCRIPTION_PATH "xml/RenderingControl2.xml"
#define RYGEL_RENDERING_CONTROL_LAST_CHANGE_NS "urn:schemas-upnp-org:metadata-1-0/RCS/"
static void rygel_rendering_control_real_constructed (GObject* base);
RygelChangeLog* rygel_change_log_new (GUPnPService* service, const char* service_ns);
RygelChangeLog* rygel_change_log_construct (GType object_type, GUPnPService* service, const char* service_ns);
static RygelMediaPlayer* rygel_rendering_control_get_player (RygelRenderingControl* self);
static void rygel_rendering_control_query_last_change_cb (RygelRenderingControl* self, GUPnPService* service, const char* variable, GValue* value);
static void _rygel_rendering_control_query_last_change_cb_gupnp_service_query_variable (GUPnPService* _sender, const char* variable, GValue* value, gpointer self);
static void rygel_rendering_control_list_presets_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_rendering_control_list_presets_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_rendering_control_select_preset_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_rendering_control_select_preset_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_rendering_control_get_mute_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_rendering_control_get_mute_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_rendering_control_set_mute_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_rendering_control_set_mute_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_rendering_control_get_volume_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_rendering_control_get_volume_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_rendering_control_set_volume_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_rendering_control_set_volume_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
guint rygel_volume_to_percentage (double volume);
double rygel_media_player_get_volume (RygelMediaPlayer* self);
gboolean rygel_rendering_control_get_mute (RygelRenderingControl* self);
void rygel_change_log_log_with_channel (RygelChangeLog* self, const char* variable, const char* value, const char* channel);
guint rygel_rendering_control_get_volume (RygelRenderingControl* self);
char* rygel_change_log_finish (RygelChangeLog* self);
GType rygel_plugin_get_type (void) G_GNUC_CONST;
GType rygel_media_renderer_plugin_get_type (void) G_GNUC_CONST;
RygelMediaPlayer* rygel_media_renderer_plugin_get_player (RygelMediaRendererPlugin* self);
static gboolean rygel_rendering_control_check_instance_id (RygelRenderingControl* self, GUPnPServiceAction* action);
static gboolean rygel_rendering_control_check_channel (RygelRenderingControl* self, GUPnPServiceAction* action);
void rygel_rendering_control_set_mute (RygelRenderingControl* self, gboolean value);
void rygel_rendering_control_set_volume (RygelRenderingControl* self, guint value);
RygelRenderingControl* rygel_rendering_control_new (void);
RygelRenderingControl* rygel_rendering_control_construct (GType object_type);
void rygel_media_player_set_volume (RygelMediaPlayer* self, double value);
double rygel_volume_from_percentage (guint percentage);
static void rygel_rendering_control_finalize (GObject* obj);
static void rygel_rendering_control_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void rygel_rendering_control_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



#line 96 "rygel-rendering-control.vala"
static void _rygel_rendering_control_query_last_change_cb_gupnp_service_query_variable (GUPnPService* _sender, const char* variable, GValue* value, gpointer self) {
#line 182 "rygel-rendering-control.c"
	rygel_rendering_control_query_last_change_cb (self, _sender, variable, value);
}


#line 129 "rygel-rendering-control.vala"
static void _rygel_rendering_control_list_presets_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 189 "rygel-rendering-control.c"
	rygel_rendering_control_list_presets_cb (self, _sender, action);
}


#line 142 "rygel-rendering-control.vala"
static void _rygel_rendering_control_select_preset_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 196 "rygel-rendering-control.c"
	rygel_rendering_control_select_preset_cb (self, _sender, action);
}


#line 174 "rygel-rendering-control.vala"
static void _rygel_rendering_control_get_mute_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 203 "rygel-rendering-control.c"
	rygel_rendering_control_get_mute_cb (self, _sender, action);
}


#line 189 "rygel-rendering-control.vala"
static void _rygel_rendering_control_set_mute_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 210 "rygel-rendering-control.c"
	rygel_rendering_control_set_mute_cb (self, _sender, action);
}


#line 208 "rygel-rendering-control.vala"
static void _rygel_rendering_control_get_volume_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 217 "rygel-rendering-control.c"
	rygel_rendering_control_get_volume_cb (self, _sender, action);
}


#line 223 "rygel-rendering-control.vala"
static void _rygel_rendering_control_set_volume_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 224 "rygel-rendering-control.c"
	rygel_rendering_control_set_volume_cb (self, _sender, action);
}


#line 80 "rygel-rendering-control.vala"
static void rygel_rendering_control_real_constructed (GObject* base) {
#line 231 "rygel-rendering-control.c"
	RygelRenderingControl * self;
	RygelChangeLog* _tmp0_;
	RygelMediaPlayer* _tmp1_;
	self = (RygelRenderingControl*) base;
#line 81 "rygel-rendering-control.vala"
	self->priv->changelog = (_tmp0_ = rygel_change_log_new ((GUPnPService*) self, RYGEL_RENDERING_CONTROL_LAST_CHANGE_NS), _g_object_unref0 (self->priv->changelog), _tmp0_);
#line 82 "rygel-rendering-control.vala"
	self->priv->player = (_tmp1_ = rygel_rendering_control_get_player (self), _g_object_unref0 (self->priv->player), _tmp1_);
#line 84 "rygel-rendering-control.vala"
	g_signal_connect_object ((GUPnPService*) self, "query-variable::LastChange", (GCallback) _rygel_rendering_control_query_last_change_cb_gupnp_service_query_variable, self, 0);
#line 86 "rygel-rendering-control.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::ListPresets", (GCallback) _rygel_rendering_control_list_presets_cb_gupnp_service_action_invoked, self, 0);
#line 87 "rygel-rendering-control.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::SelectPreset", (GCallback) _rygel_rendering_control_select_preset_cb_gupnp_service_action_invoked, self, 0);
#line 88 "rygel-rendering-control.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetMute", (GCallback) _rygel_rendering_control_get_mute_cb_gupnp_service_action_invoked, self, 0);
#line 89 "rygel-rendering-control.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::SetMute", (GCallback) _rygel_rendering_control_set_mute_cb_gupnp_service_action_invoked, self, 0);
#line 90 "rygel-rendering-control.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetVolume", (GCallback) _rygel_rendering_control_get_volume_cb_gupnp_service_action_invoked, self, 0);
#line 91 "rygel-rendering-control.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::SetVolume", (GCallback) _rygel_rendering_control_set_volume_cb_gupnp_service_action_invoked, self, 0);
#line 93 "rygel-rendering-control.vala"
	self->priv->_volume = rygel_volume_to_percentage (rygel_media_player_get_volume (self->priv->player));
#line 256 "rygel-rendering-control.c"
}


#line 96 "rygel-rendering-control.vala"
static void rygel_rendering_control_query_last_change_cb (RygelRenderingControl* self, GUPnPService* service, const char* variable, GValue* value) {
#line 262 "rygel-rendering-control.c"
	RygelChangeLog* log;
	const char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
#line 96 "rygel-rendering-control.vala"
	g_return_if_fail (self != NULL);
#line 96 "rygel-rendering-control.vala"
	g_return_if_fail (service != NULL);
#line 96 "rygel-rendering-control.vala"
	g_return_if_fail (variable != NULL);
#line 100 "rygel-rendering-control.vala"
	log = rygel_change_log_new (NULL, RYGEL_RENDERING_CONTROL_LAST_CHANGE_NS);
#line 275 "rygel-rendering-control.c"
	_tmp0_ = NULL;
#line 102 "rygel-rendering-control.vala"
	if (rygel_rendering_control_get_mute (self)) {
#line 102 "rygel-rendering-control.vala"
		_tmp0_ = "1";
#line 281 "rygel-rendering-control.c"
	} else {
#line 102 "rygel-rendering-control.vala"
		_tmp0_ = "0";
#line 285 "rygel-rendering-control.c"
	}
#line 102 "rygel-rendering-control.vala"
	rygel_change_log_log_with_channel (log, "Mute", _tmp0_, "Master");
#line 103 "rygel-rendering-control.vala"
	rygel_change_log_log_with_channel (log, "Volume", _tmp1_ = g_strdup_printf ("%u", rygel_rendering_control_get_volume (self)), "Master");
#line 291 "rygel-rendering-control.c"
	_g_free0 (_tmp1_);
#line 105 "rygel-rendering-control.vala"
	g_value_init (value, G_TYPE_STRING);
#line 106 "rygel-rendering-control.vala"
	g_value_set_string (value, _tmp2_ = rygel_change_log_finish (log));
#line 297 "rygel-rendering-control.c"
	_g_free0 (_tmp2_);
	_g_object_unref0 (log);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 109 "rygel-rendering-control.vala"
static RygelMediaPlayer* rygel_rendering_control_get_player (RygelRenderingControl* self) {
#line 310 "rygel-rendering-control.c"
	RygelMediaPlayer* result = NULL;
	GUPnPRootDevice* _tmp0_ = NULL;
	GUPnPRootDevice* _tmp1_;
	GUPnPResourceFactory* _tmp2_;
	RygelMediaRendererPlugin* _tmp3_;
	RygelMediaRendererPlugin* plugin;
#line 109 "rygel-rendering-control.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 110 "rygel-rendering-control.vala"
	plugin = (_tmp3_ = _g_object_ref0 ((_tmp2_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) (_tmp1_ = (g_object_get ((GUPnPService*) self, "root-device", &_tmp0_, NULL), _tmp0_))), RYGEL_IS_MEDIA_RENDERER_PLUGIN (_tmp2_) ? ((RygelMediaRendererPlugin*) _tmp2_) : NULL)), _g_object_unref0 (_tmp1_), _tmp3_);
#line 321 "rygel-rendering-control.c"
	result = rygel_media_renderer_plugin_get_player (plugin);
	_g_object_unref0 (plugin);
#line 112 "rygel-rendering-control.vala"
	return result;
#line 326 "rygel-rendering-control.c"
}


#line 116 "rygel-rendering-control.vala"
static gboolean rygel_rendering_control_check_instance_id (RygelRenderingControl* self, GUPnPServiceAction* action) {
#line 332 "rygel-rendering-control.c"
	gboolean result = FALSE;
	guint instance_id = 0U;
#line 116 "rygel-rendering-control.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 116 "rygel-rendering-control.vala"
	g_return_val_if_fail (action != NULL, FALSE);
#line 119 "rygel-rendering-control.vala"
	gupnp_service_action_get (action, "InstanceID", G_TYPE_UINT, &instance_id, NULL);
#line 120 "rygel-rendering-control.vala"
	if (instance_id != 0) {
#line 121 "rygel-rendering-control.vala"
		gupnp_service_action_return_error (action, (guint) 702, _ ("Invalid InstanceID"));
#line 345 "rygel-rendering-control.c"
		result = FALSE;
#line 123 "rygel-rendering-control.vala"
		return result;
#line 349 "rygel-rendering-control.c"
	}
	result = TRUE;
#line 126 "rygel-rendering-control.vala"
	return result;
#line 354 "rygel-rendering-control.c"
}


#line 129 "rygel-rendering-control.vala"
static void rygel_rendering_control_list_presets_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action) {
#line 129 "rygel-rendering-control.vala"
	g_return_if_fail (self != NULL);
#line 129 "rygel-rendering-control.vala"
	g_return_if_fail (service != NULL);
#line 129 "rygel-rendering-control.vala"
	g_return_if_fail (action != NULL);
#line 131 "rygel-rendering-control.vala"
	if (!rygel_rendering_control_check_instance_id (self, action)) {
#line 132 "rygel-rendering-control.vala"
		return;
#line 370 "rygel-rendering-control.c"
	}
#line 135 "rygel-rendering-control.vala"
	gupnp_service_action_set (action, "CurrentPresetNameList", G_TYPE_STRING, self->priv->preset_name_list, NULL);
#line 139 "rygel-rendering-control.vala"
	gupnp_service_action_return (action);
#line 376 "rygel-rendering-control.c"
}


#line 142 "rygel-rendering-control.vala"
static void rygel_rendering_control_select_preset_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action) {
#line 382 "rygel-rendering-control.c"
	char* preset_name;
#line 142 "rygel-rendering-control.vala"
	g_return_if_fail (self != NULL);
#line 142 "rygel-rendering-control.vala"
	g_return_if_fail (service != NULL);
#line 142 "rygel-rendering-control.vala"
	g_return_if_fail (action != NULL);
#line 144 "rygel-rendering-control.vala"
	if (!rygel_rendering_control_check_instance_id (self, action)) {
#line 145 "rygel-rendering-control.vala"
		return;
#line 394 "rygel-rendering-control.c"
	}
	preset_name = NULL;
#line 150 "rygel-rendering-control.vala"
	gupnp_service_action_get (action, "PresetName", G_TYPE_STRING, &preset_name, NULL);
#line 151 "rygel-rendering-control.vala"
	if (_vala_strcmp0 (preset_name, "") != 0) {
#line 152 "rygel-rendering-control.vala"
		gupnp_service_action_return_error (action, (guint) 701, _ ("Invalid Name"));
#line 403 "rygel-rendering-control.c"
		_g_free0 (preset_name);
#line 154 "rygel-rendering-control.vala"
		return;
#line 407 "rygel-rendering-control.c"
	}
#line 157 "rygel-rendering-control.vala"
	gupnp_service_action_return (action);
#line 411 "rygel-rendering-control.c"
	_g_free0 (preset_name);
}


#line 161 "rygel-rendering-control.vala"
static gboolean rygel_rendering_control_check_channel (RygelRenderingControl* self, GUPnPServiceAction* action) {
#line 418 "rygel-rendering-control.c"
	gboolean result = FALSE;
	char* channel;
#line 161 "rygel-rendering-control.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 161 "rygel-rendering-control.vala"
	g_return_val_if_fail (action != NULL, FALSE);
#line 425 "rygel-rendering-control.c"
	channel = NULL;
#line 164 "rygel-rendering-control.vala"
	gupnp_service_action_get (action, "Channel", G_TYPE_STRING, &channel, NULL);
#line 165 "rygel-rendering-control.vala"
	if (_vala_strcmp0 (channel, "Master") != 0) {
#line 166 "rygel-rendering-control.vala"
		gupnp_service_action_return_error (action, (guint) 501, _ ("Action Failed"));
#line 433 "rygel-rendering-control.c"
		result = FALSE;
		_g_free0 (channel);
#line 168 "rygel-rendering-control.vala"
		return result;
#line 438 "rygel-rendering-control.c"
	}
	result = TRUE;
	_g_free0 (channel);
#line 171 "rygel-rendering-control.vala"
	return result;
#line 444 "rygel-rendering-control.c"
}


#line 174 "rygel-rendering-control.vala"
static void rygel_rendering_control_get_mute_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action) {
#line 174 "rygel-rendering-control.vala"
	g_return_if_fail (self != NULL);
#line 174 "rygel-rendering-control.vala"
	g_return_if_fail (service != NULL);
#line 174 "rygel-rendering-control.vala"
	g_return_if_fail (action != NULL);
#line 176 "rygel-rendering-control.vala"
	if (!rygel_rendering_control_check_instance_id (self, action)) {
#line 177 "rygel-rendering-control.vala"
		return;
#line 460 "rygel-rendering-control.c"
	}
#line 180 "rygel-rendering-control.vala"
	if (!rygel_rendering_control_check_channel (self, action)) {
#line 181 "rygel-rendering-control.vala"
		return;
#line 466 "rygel-rendering-control.c"
	}
#line 184 "rygel-rendering-control.vala"
	gupnp_service_action_set (action, "CurrentMute", G_TYPE_BOOLEAN, rygel_rendering_control_get_mute (self), NULL);
#line 186 "rygel-rendering-control.vala"
	gupnp_service_action_return (action);
#line 472 "rygel-rendering-control.c"
}


#line 189 "rygel-rendering-control.vala"
static void rygel_rendering_control_set_mute_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action) {
#line 478 "rygel-rendering-control.c"
	gboolean mute = FALSE;
#line 189 "rygel-rendering-control.vala"
	g_return_if_fail (self != NULL);
#line 189 "rygel-rendering-control.vala"
	g_return_if_fail (service != NULL);
#line 189 "rygel-rendering-control.vala"
	g_return_if_fail (action != NULL);
#line 191 "rygel-rendering-control.vala"
	if (!rygel_rendering_control_check_instance_id (self, action)) {
#line 192 "rygel-rendering-control.vala"
		return;
#line 490 "rygel-rendering-control.c"
	}
#line 195 "rygel-rendering-control.vala"
	if (!rygel_rendering_control_check_channel (self, action)) {
#line 196 "rygel-rendering-control.vala"
		return;
#line 496 "rygel-rendering-control.c"
	}
#line 201 "rygel-rendering-control.vala"
	gupnp_service_action_get (action, "DesiredMute", G_TYPE_BOOLEAN, &mute, NULL);
#line 203 "rygel-rendering-control.vala"
	rygel_rendering_control_set_mute (self, mute);
#line 205 "rygel-rendering-control.vala"
	gupnp_service_action_return (action);
#line 504 "rygel-rendering-control.c"
}


#line 208 "rygel-rendering-control.vala"
static void rygel_rendering_control_get_volume_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action) {
#line 208 "rygel-rendering-control.vala"
	g_return_if_fail (self != NULL);
#line 208 "rygel-rendering-control.vala"
	g_return_if_fail (service != NULL);
#line 208 "rygel-rendering-control.vala"
	g_return_if_fail (action != NULL);
#line 210 "rygel-rendering-control.vala"
	if (!rygel_rendering_control_check_instance_id (self, action)) {
#line 211 "rygel-rendering-control.vala"
		return;
#line 520 "rygel-rendering-control.c"
	}
#line 214 "rygel-rendering-control.vala"
	if (!rygel_rendering_control_check_channel (self, action)) {
#line 215 "rygel-rendering-control.vala"
		return;
#line 526 "rygel-rendering-control.c"
	}
#line 218 "rygel-rendering-control.vala"
	gupnp_service_action_set (action, "CurrentVolume", G_TYPE_UINT, rygel_rendering_control_get_volume (self), NULL);
#line 220 "rygel-rendering-control.vala"
	gupnp_service_action_return (action);
#line 532 "rygel-rendering-control.c"
}


#line 223 "rygel-rendering-control.vala"
static void rygel_rendering_control_set_volume_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action) {
#line 538 "rygel-rendering-control.c"
	guint volume = 0U;
#line 223 "rygel-rendering-control.vala"
	g_return_if_fail (self != NULL);
#line 223 "rygel-rendering-control.vala"
	g_return_if_fail (service != NULL);
#line 223 "rygel-rendering-control.vala"
	g_return_if_fail (action != NULL);
#line 225 "rygel-rendering-control.vala"
	if (!rygel_rendering_control_check_instance_id (self, action)) {
#line 226 "rygel-rendering-control.vala"
		return;
#line 550 "rygel-rendering-control.c"
	}
#line 229 "rygel-rendering-control.vala"
	if (!rygel_rendering_control_check_channel (self, action)) {
#line 230 "rygel-rendering-control.vala"
		return;
#line 556 "rygel-rendering-control.c"
	}
#line 235 "rygel-rendering-control.vala"
	gupnp_service_action_get (action, "DesiredVolume", G_TYPE_UINT, &volume, NULL);
#line 236 "rygel-rendering-control.vala"
	if (volume > 100) {
#line 237 "rygel-rendering-control.vala"
		gupnp_service_action_return_error (action, (guint) 501, _ ("Action Failed"));
#line 239 "rygel-rendering-control.vala"
		return;
#line 566 "rygel-rendering-control.c"
	}
#line 242 "rygel-rendering-control.vala"
	rygel_rendering_control_set_volume (self, volume);
#line 244 "rygel-rendering-control.vala"
	gupnp_service_action_return (action);
#line 572 "rygel-rendering-control.c"
}


#line 27 "rygel-rendering-control.vala"
RygelRenderingControl* rygel_rendering_control_construct (GType object_type) {
#line 578 "rygel-rendering-control.c"
	RygelRenderingControl * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


#line 27 "rygel-rendering-control.vala"
RygelRenderingControl* rygel_rendering_control_new (void) {
#line 27 "rygel-rendering-control.vala"
	return rygel_rendering_control_construct (RYGEL_TYPE_RENDERING_CONTROL);
#line 589 "rygel-rendering-control.c"
}


gboolean rygel_rendering_control_get_mute (RygelRenderingControl* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_mute;
#line 38 "rygel-rendering-control.vala"
	return result;
#line 599 "rygel-rendering-control.c"
}


void rygel_rendering_control_set_mute (RygelRenderingControl* self, gboolean value) {
	const char* _tmp0_;
	g_return_if_fail (self != NULL);
#line 42 "rygel-rendering-control.vala"
	self->priv->_mute = value;
#line 44 "rygel-rendering-control.vala"
	if (self->priv->_mute) {
#line 45 "rygel-rendering-control.vala"
		rygel_media_player_set_volume (self->priv->player, (double) 0);
#line 612 "rygel-rendering-control.c"
	} else {
#line 47 "rygel-rendering-control.vala"
		rygel_media_player_set_volume (self->priv->player, rygel_volume_from_percentage (rygel_rendering_control_get_volume (self)));
#line 616 "rygel-rendering-control.c"
	}
	_tmp0_ = NULL;
#line 51 "rygel-rendering-control.vala"
	if (rygel_rendering_control_get_mute (self)) {
#line 51 "rygel-rendering-control.vala"
		_tmp0_ = "1";
#line 623 "rygel-rendering-control.c"
	} else {
#line 51 "rygel-rendering-control.vala"
		_tmp0_ = "0";
#line 627 "rygel-rendering-control.c"
	}
#line 50 "rygel-rendering-control.vala"
	rygel_change_log_log_with_channel (self->priv->changelog, "Mute", _tmp0_, "Master");
#line 631 "rygel-rendering-control.c"
	g_object_notify ((GObject *) self, "mute");
}


guint rygel_rendering_control_get_volume (RygelRenderingControl* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_volume;
#line 59 "rygel-rendering-control.vala"
	return result;
#line 642 "rygel-rendering-control.c"
}


void rygel_rendering_control_set_volume (RygelRenderingControl* self, guint value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
#line 63 "rygel-rendering-control.vala"
	self->priv->_volume = value;
#line 65 "rygel-rendering-control.vala"
	if (!rygel_rendering_control_get_mute (self)) {
#line 66 "rygel-rendering-control.vala"
		rygel_media_player_set_volume (self->priv->player, rygel_volume_from_percentage (rygel_rendering_control_get_volume (self)));
#line 655 "rygel-rendering-control.c"
	}
#line 69 "rygel-rendering-control.vala"
	rygel_change_log_log_with_channel (self->priv->changelog, "Volume", _tmp0_ = g_strdup_printf ("%u", rygel_rendering_control_get_volume (self)), "Master");
#line 659 "rygel-rendering-control.c"
	_g_free0 (_tmp0_);
	g_object_notify ((GObject *) self, "volume");
}


static void rygel_rendering_control_class_init (RygelRenderingControlClass * klass) {
	rygel_rendering_control_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelRenderingControlPrivate));
	G_OBJECT_CLASS (klass)->constructed = rygel_rendering_control_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = rygel_rendering_control_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_rendering_control_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_rendering_control_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_RENDERING_CONTROL_MUTE, g_param_spec_boolean ("mute", "mute", "mute", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_RENDERING_CONTROL_VOLUME, g_param_spec_uint ("volume", "volume", "volume", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void rygel_rendering_control_instance_init (RygelRenderingControl * self) {
	self->priv = RYGEL_RENDERING_CONTROL_GET_PRIVATE (self);
	self->priv->_mute = FALSE;
	self->priv->_volume = (guint) 0;
	self->priv->preset_name_list = g_strdup ("");
}


static void rygel_rendering_control_finalize (GObject* obj) {
	RygelRenderingControl * self;
	self = RYGEL_RENDERING_CONTROL (obj);
	_g_free0 (self->priv->preset_name_list);
	_g_object_unref0 (self->priv->changelog);
	_g_object_unref0 (self->priv->player);
	G_OBJECT_CLASS (rygel_rendering_control_parent_class)->finalize (obj);
}


GType rygel_rendering_control_get_type (void) {
	static volatile gsize rygel_rendering_control_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_rendering_control_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelRenderingControlClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_rendering_control_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelRenderingControl), 0, (GInstanceInitFunc) rygel_rendering_control_instance_init, NULL };
		GType rygel_rendering_control_type_id;
		rygel_rendering_control_type_id = g_type_register_static (GUPNP_TYPE_SERVICE, "RygelRenderingControl", &g_define_type_info, 0);
		g_once_init_leave (&rygel_rendering_control_type_id__volatile, rygel_rendering_control_type_id);
	}
	return rygel_rendering_control_type_id__volatile;
}


static void rygel_rendering_control_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelRenderingControl * self;
	self = RYGEL_RENDERING_CONTROL (object);
	switch (property_id) {
		case RYGEL_RENDERING_CONTROL_MUTE:
		g_value_set_boolean (value, rygel_rendering_control_get_mute (self));
		break;
		case RYGEL_RENDERING_CONTROL_VOLUME:
		g_value_set_uint (value, rygel_rendering_control_get_volume (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void rygel_rendering_control_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelRenderingControl * self;
	self = RYGEL_RENDERING_CONTROL (object);
	switch (property_id) {
		case RYGEL_RENDERING_CONTROL_MUTE:
		rygel_rendering_control_set_mute (self, g_value_get_boolean (value));
		break;
		case RYGEL_RENDERING_CONTROL_VOLUME:
		rygel_rendering_control_set_volume (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




