/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation, all rights reserved.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "rygel-tracker-image-item.h"
#include <rygel-media-object.h>
#include <rygel-media-item.h>
#include <gee/collection.h>


#define RYGEL_TRACKER_IMAGE_ITEM_TYPE_METADATA (rygel_tracker_image_item_metadata_get_type ())

typedef enum  {
	RYGEL_TRACKER_IMAGE_ITEM_METADATA_FILE_NAME,
	RYGEL_TRACKER_IMAGE_ITEM_METADATA_MIME,
	RYGEL_TRACKER_IMAGE_ITEM_METADATA_SIZE,
	RYGEL_TRACKER_IMAGE_ITEM_METADATA_TITLE,
	RYGEL_TRACKER_IMAGE_ITEM_METADATA_CREATOR,
	RYGEL_TRACKER_IMAGE_ITEM_METADATA_WIDTH,
	RYGEL_TRACKER_IMAGE_ITEM_METADATA_HEIGHT,
	RYGEL_TRACKER_IMAGE_ITEM_METADATA_ALBUM,
	RYGEL_TRACKER_IMAGE_ITEM_METADATA_IMAGE_DATE,
	RYGEL_TRACKER_IMAGE_ITEM_METADATA_DATE,
	RYGEL_TRACKER_IMAGE_ITEM_METADATA_LAST_KEY
} RygelTrackerImageItemMetadata;



enum  {
	RYGEL_TRACKER_IMAGE_ITEM_DUMMY_PROPERTY
};
GType rygel_tracker_image_item_metadata_get_type (void);
static void rygel_tracker_image_item_real_init_from_metadata (RygelTrackerItem* base, char** values, int values_length1);
static gpointer rygel_tracker_image_item_parent_class = NULL;
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);




GType rygel_tracker_image_item_metadata_get_type (void) {
	static GType rygel_tracker_image_item_metadata_type_id = 0;
	if (G_UNLIKELY (rygel_tracker_image_item_metadata_type_id == 0)) {
		static const GEnumValue values[] = {{RYGEL_TRACKER_IMAGE_ITEM_METADATA_FILE_NAME, "RYGEL_TRACKER_IMAGE_ITEM_METADATA_FILE_NAME", "file-name"}, {RYGEL_TRACKER_IMAGE_ITEM_METADATA_MIME, "RYGEL_TRACKER_IMAGE_ITEM_METADATA_MIME", "mime"}, {RYGEL_TRACKER_IMAGE_ITEM_METADATA_SIZE, "RYGEL_TRACKER_IMAGE_ITEM_METADATA_SIZE", "size"}, {RYGEL_TRACKER_IMAGE_ITEM_METADATA_TITLE, "RYGEL_TRACKER_IMAGE_ITEM_METADATA_TITLE", "title"}, {RYGEL_TRACKER_IMAGE_ITEM_METADATA_CREATOR, "RYGEL_TRACKER_IMAGE_ITEM_METADATA_CREATOR", "creator"}, {RYGEL_TRACKER_IMAGE_ITEM_METADATA_WIDTH, "RYGEL_TRACKER_IMAGE_ITEM_METADATA_WIDTH", "width"}, {RYGEL_TRACKER_IMAGE_ITEM_METADATA_HEIGHT, "RYGEL_TRACKER_IMAGE_ITEM_METADATA_HEIGHT", "height"}, {RYGEL_TRACKER_IMAGE_ITEM_METADATA_ALBUM, "RYGEL_TRACKER_IMAGE_ITEM_METADATA_ALBUM", "album"}, {RYGEL_TRACKER_IMAGE_ITEM_METADATA_IMAGE_DATE, "RYGEL_TRACKER_IMAGE_ITEM_METADATA_IMAGE_DATE", "image-date"}, {RYGEL_TRACKER_IMAGE_ITEM_METADATA_DATE, "RYGEL_TRACKER_IMAGE_ITEM_METADATA_DATE", "date"}, {RYGEL_TRACKER_IMAGE_ITEM_METADATA_LAST_KEY, "RYGEL_TRACKER_IMAGE_ITEM_METADATA_LAST_KEY", "last-key"}, {0, NULL, NULL}};
		rygel_tracker_image_item_metadata_type_id = g_enum_register_static ("RygelTrackerImageItemMetadata", values);
	}
	return rygel_tracker_image_item_metadata_type_id;
}


RygelTrackerImageItem* rygel_tracker_image_item_construct (GType object_type, const char* id, const char* path, RygelTrackerCategory* parent, char** metadata, int metadata_length1) {
	RygelTrackerImageItem * self;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	self = (RygelTrackerImageItem*) rygel_tracker_item_construct (object_type, id, path, parent, metadata, metadata_length1);
	return self;
}


RygelTrackerImageItem* rygel_tracker_image_item_new (const char* id, const char* path, RygelTrackerCategory* parent, char** metadata, int metadata_length1) {
	return rygel_tracker_image_item_construct (RYGEL_TYPE_TRACKER_IMAGE_ITEM, id, path, parent, metadata, metadata_length1);
}


char** rygel_tracker_image_item_get_metadata_keys (int* result_length1) {
	char** _tmp0;
	gint keys_size;
	gint keys_length1;
	char** keys;
	char* _tmp1;
	char* _tmp2;
	char* _tmp3;
	char* _tmp4;
	char* _tmp5;
	char* _tmp6;
	char* _tmp7;
	char* _tmp8;
	char* _tmp9;
	char* _tmp10;
	char** _tmp11;
	_tmp0 = NULL;
	keys = (_tmp0 = g_new0 (char*, RYGEL_TRACKER_IMAGE_ITEM_METADATA_LAST_KEY + 1), keys_length1 = RYGEL_TRACKER_IMAGE_ITEM_METADATA_LAST_KEY, keys_size = keys_length1, _tmp0);
	_tmp1 = NULL;
	keys[RYGEL_TRACKER_IMAGE_ITEM_METADATA_FILE_NAME] = (_tmp1 = g_strdup ("File:Name"), keys[RYGEL_TRACKER_IMAGE_ITEM_METADATA_FILE_NAME] = (g_free (keys[RYGEL_TRACKER_IMAGE_ITEM_METADATA_FILE_NAME]), NULL), _tmp1);
	_tmp2 = NULL;
	keys[RYGEL_TRACKER_IMAGE_ITEM_METADATA_MIME] = (_tmp2 = g_strdup ("File:Mime"), keys[RYGEL_TRACKER_IMAGE_ITEM_METADATA_MIME] = (g_free (keys[RYGEL_TRACKER_IMAGE_ITEM_METADATA_MIME]), NULL), _tmp2);
	_tmp3 = NULL;
	keys[RYGEL_TRACKER_IMAGE_ITEM_METADATA_SIZE] = (_tmp3 = g_strdup ("File:Size"), keys[RYGEL_TRACKER_IMAGE_ITEM_METADATA_SIZE] = (g_free (keys[RYGEL_TRACKER_IMAGE_ITEM_METADATA_SIZE]), NULL), _tmp3);
	_tmp4 = NULL;
	keys[RYGEL_TRACKER_IMAGE_ITEM_METADATA_TITLE] = (_tmp4 = g_strdup ("Video:Title"), keys[RYGEL_TRACKER_IMAGE_ITEM_METADATA_TITLE] = (g_free (keys[RYGEL_TRACKER_IMAGE_ITEM_METADATA_TITLE]), NULL), _tmp4);
	_tmp5 = NULL;
	keys[RYGEL_TRACKER_IMAGE_ITEM_METADATA_CREATOR] = (_tmp5 = g_strdup ("Image:Creator"), keys[RYGEL_TRACKER_IMAGE_ITEM_METADATA_CREATOR] = (g_free (keys[RYGEL_TRACKER_IMAGE_ITEM_METADATA_CREATOR]), NULL), _tmp5);
	_tmp6 = NULL;
	keys[RYGEL_TRACKER_IMAGE_ITEM_METADATA_WIDTH] = (_tmp6 = g_strdup ("Image:Width"), keys[RYGEL_TRACKER_IMAGE_ITEM_METADATA_WIDTH] = (g_free (keys[RYGEL_TRACKER_IMAGE_ITEM_METADATA_WIDTH]), NULL), _tmp6);
	_tmp7 = NULL;
	keys[RYGEL_TRACKER_IMAGE_ITEM_METADATA_HEIGHT] = (_tmp7 = g_strdup ("Image:Height"), keys[RYGEL_TRACKER_IMAGE_ITEM_METADATA_HEIGHT] = (g_free (keys[RYGEL_TRACKER_IMAGE_ITEM_METADATA_HEIGHT]), NULL), _tmp7);
	_tmp8 = NULL;
	keys[RYGEL_TRACKER_IMAGE_ITEM_METADATA_ALBUM] = (_tmp8 = g_strdup ("Image:Album"), keys[RYGEL_TRACKER_IMAGE_ITEM_METADATA_ALBUM] = (g_free (keys[RYGEL_TRACKER_IMAGE_ITEM_METADATA_ALBUM]), NULL), _tmp8);
	_tmp9 = NULL;
	keys[RYGEL_TRACKER_IMAGE_ITEM_METADATA_IMAGE_DATE] = (_tmp9 = g_strdup ("Image:Date"), keys[RYGEL_TRACKER_IMAGE_ITEM_METADATA_IMAGE_DATE] = (g_free (keys[RYGEL_TRACKER_IMAGE_ITEM_METADATA_IMAGE_DATE]), NULL), _tmp9);
	_tmp10 = NULL;
	keys[RYGEL_TRACKER_IMAGE_ITEM_METADATA_DATE] = (_tmp10 = g_strdup ("DC:Date"), keys[RYGEL_TRACKER_IMAGE_ITEM_METADATA_DATE] = (g_free (keys[RYGEL_TRACKER_IMAGE_ITEM_METADATA_DATE]), NULL), _tmp10);
	_tmp11 = NULL;
	return (_tmp11 = keys, *result_length1 = keys_length1, _tmp11);
}


static void rygel_tracker_image_item_real_init_from_metadata (RygelTrackerItem* base, char** values, int values_length1) {
	RygelTrackerImageItem * self;
	GError * inner_error;
	char* _tmp7;
	const char* _tmp6;
	char* _tmp9;
	const char* _tmp8;
	char* _tmp11;
	const char* _tmp10;
	char* _tmp12;
	char* _tmp13;
	self = (RygelTrackerImageItem*) base;
	inner_error = NULL;
	if (_vala_strcmp0 (values[RYGEL_TRACKER_IMAGE_ITEM_METADATA_TITLE], "") != 0) {
		char* _tmp1;
		const char* _tmp0;
		_tmp1 = NULL;
		_tmp0 = NULL;
		((RygelMediaObject*) self)->title = (_tmp1 = (_tmp0 = values[RYGEL_TRACKER_IMAGE_ITEM_METADATA_TITLE], (_tmp0 == NULL) ? NULL : g_strdup (_tmp0)), ((RygelMediaObject*) self)->title = (g_free (((RygelMediaObject*) self)->title), NULL), _tmp1);
	} else {
		char* _tmp3;
		const char* _tmp2;
		_tmp3 = NULL;
		_tmp2 = NULL;
		((RygelMediaObject*) self)->title = (_tmp3 = (_tmp2 = values[RYGEL_TRACKER_IMAGE_ITEM_METADATA_FILE_NAME], (_tmp2 == NULL) ? NULL : g_strdup (_tmp2)), ((RygelMediaObject*) self)->title = (g_free (((RygelMediaObject*) self)->title), NULL), _tmp3);
	}
	if (_vala_strcmp0 (values[RYGEL_TRACKER_IMAGE_ITEM_METADATA_SIZE], "") != 0) {
		((RygelMediaItem*) self)->size = (glong) atoi (values[RYGEL_TRACKER_IMAGE_ITEM_METADATA_SIZE]);
	}
	if (_vala_strcmp0 (values[RYGEL_TRACKER_IMAGE_ITEM_METADATA_WIDTH], "") != 0) {
		((RygelMediaItem*) self)->width = atoi (values[RYGEL_TRACKER_IMAGE_ITEM_METADATA_WIDTH]);
	}
	if (_vala_strcmp0 (values[RYGEL_TRACKER_IMAGE_ITEM_METADATA_HEIGHT], "") != 0) {
		((RygelMediaItem*) self)->height = atoi (values[RYGEL_TRACKER_IMAGE_ITEM_METADATA_HEIGHT]);
	}
	if (_vala_strcmp0 (values[RYGEL_TRACKER_IMAGE_ITEM_METADATA_SIZE], "") != 0) {
		((RygelMediaItem*) self)->size = (glong) atoi (values[RYGEL_TRACKER_IMAGE_ITEM_METADATA_SIZE]);
	}
	if (_vala_strcmp0 (values[RYGEL_TRACKER_IMAGE_ITEM_METADATA_DATE], "") != 0) {
		char* _tmp4;
		_tmp4 = NULL;
		((RygelMediaItem*) self)->date = (_tmp4 = rygel_tracker_item_seconds_to_iso8601 ((RygelTrackerItem*) self, values[RYGEL_TRACKER_IMAGE_ITEM_METADATA_DATE]), ((RygelMediaItem*) self)->date = (g_free (((RygelMediaItem*) self)->date), NULL), _tmp4);
	} else {
		char* _tmp5;
		_tmp5 = NULL;
		((RygelMediaItem*) self)->date = (_tmp5 = rygel_tracker_item_seconds_to_iso8601 ((RygelTrackerItem*) self, values[RYGEL_TRACKER_IMAGE_ITEM_METADATA_IMAGE_DATE]), ((RygelMediaItem*) self)->date = (g_free (((RygelMediaItem*) self)->date), NULL), _tmp5);
	}
	_tmp7 = NULL;
	_tmp6 = NULL;
	((RygelMediaItem*) self)->mime_type = (_tmp7 = (_tmp6 = values[RYGEL_TRACKER_IMAGE_ITEM_METADATA_MIME], (_tmp6 == NULL) ? NULL : g_strdup (_tmp6)), ((RygelMediaItem*) self)->mime_type = (g_free (((RygelMediaItem*) self)->mime_type), NULL), _tmp7);
	_tmp9 = NULL;
	_tmp8 = NULL;
	((RygelMediaItem*) self)->author = (_tmp9 = (_tmp8 = values[RYGEL_TRACKER_IMAGE_ITEM_METADATA_CREATOR], (_tmp8 == NULL) ? NULL : g_strdup (_tmp8)), ((RygelMediaItem*) self)->author = (g_free (((RygelMediaItem*) self)->author), NULL), _tmp9);
	_tmp11 = NULL;
	_tmp10 = NULL;
	((RygelMediaItem*) self)->album = (_tmp11 = (_tmp10 = values[RYGEL_TRACKER_IMAGE_ITEM_METADATA_ALBUM], (_tmp10 == NULL) ? NULL : g_strdup (_tmp10)), ((RygelMediaItem*) self)->album = (g_free (((RygelMediaItem*) self)->album), NULL), _tmp11);
	_tmp12 = g_filename_to_uri (((RygelTrackerItem*) self)->path, NULL, &inner_error);
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
	_tmp13 = NULL;
	gee_collection_add ((GeeCollection*) ((RygelMediaItem*) self)->uris, _tmp13 = _tmp12);
	_tmp13 = (g_free (_tmp13), NULL);
}


static void rygel_tracker_image_item_class_init (RygelTrackerImageItemClass * klass) {
	rygel_tracker_image_item_parent_class = g_type_class_peek_parent (klass);
	RYGEL_TRACKER_ITEM_CLASS (klass)->init_from_metadata = rygel_tracker_image_item_real_init_from_metadata;
}


static void rygel_tracker_image_item_instance_init (RygelTrackerImageItem * self) {
}


GType rygel_tracker_image_item_get_type (void) {
	static GType rygel_tracker_image_item_type_id = 0;
	if (rygel_tracker_image_item_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerImageItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_tracker_image_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTrackerImageItem), 0, (GInstanceInitFunc) rygel_tracker_image_item_instance_init, NULL };
		rygel_tracker_image_item_type_id = g_type_register_static (RYGEL_TYPE_TRACKER_ITEM, "RygelTrackerImageItem", &g_define_type_info, 0);
	}
	return rygel_tracker_image_item_type_id;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




