/*
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2008 Nokia Corporation, all rights reserved.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "rygel-test-video-item.h"
#include <rygel-media-item.h>
#include <rygel-media-object.h>




enum  {
	RYGEL_TEST_VIDEO_ITEM_DUMMY_PROPERTY
};
#define RYGEL_TEST_VIDEO_ITEM_TEST_MIMETYPE "video/mpeg"
static inline void _dynamic_set_is_live1 (GstElement* obj, gboolean value);
static GstElement* rygel_test_video_item_real_create_stream_source (RygelMediaItem* base);
static gpointer rygel_test_video_item_parent_class = NULL;



RygelTestVideoItem* rygel_test_video_item_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title) {
	RygelTestVideoItem * self;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	self = (RygelTestVideoItem*) rygel_test_item_construct (object_type, id, parent, title, RYGEL_TEST_VIDEO_ITEM_TEST_MIMETYPE, RYGEL_MEDIA_ITEM_VIDEO_CLASS);
	return self;
}


RygelTestVideoItem* rygel_test_video_item_new (const char* id, RygelMediaContainer* parent, const char* title) {
	return rygel_test_video_item_construct (RYGEL_TYPE_TEST_VIDEO_ITEM, id, parent, title);
}


static inline void _dynamic_set_is_live1 (GstElement* obj, gboolean value) {
	g_object_set (obj, "is-live", value, NULL);
}


static GstElement* rygel_test_video_item_real_create_stream_source (RygelMediaItem* base) {
	RygelTestVideoItem * self;
	GstBin* bin;
	GstElement* src;
	GstElement* encoder;
	GstElement* muxer;
	gboolean _tmp0;
	gboolean _tmp1;
	GstElement* _tmp5;
	GstElement* _tmp4;
	GstElement* _tmp3;
	GstPad* pad;
	char* _tmp7;
	char* _tmp6;
	GstGhostPad* _tmp8;
	GstGhostPad* ghost;
	GstPad* _tmp9;
	GstElement* _tmp10;
	self = (RygelTestVideoItem*) base;
	bin = (GstBin*) gst_bin_new (((RygelMediaObject*) self)->title);
	src = gst_element_factory_make ("videotestsrc", NULL);
	encoder = gst_element_factory_make ("ffenc_mpeg2video", NULL);
	muxer = gst_element_factory_make ("mpegtsmux", NULL);
	_tmp0 = FALSE;
	_tmp1 = FALSE;
	if (src == NULL) {
		_tmp1 = TRUE;
	} else {
		_tmp1 = muxer == NULL;
	}
	if (_tmp1) {
		_tmp0 = TRUE;
	} else {
		_tmp0 = encoder == NULL;
	}
	if (_tmp0) {
		GstElement* _tmp2;
		g_warning ("rygel-test-video-item.vala:54: Required plugin missing");
		_tmp2 = NULL;
		return (_tmp2 = NULL, (bin == NULL) ? NULL : (bin = (gst_object_unref (bin), NULL)), (src == NULL) ? NULL : (src = (gst_object_unref (src), NULL)), (encoder == NULL) ? NULL : (encoder = (gst_object_unref (encoder), NULL)), (muxer == NULL) ? NULL : (muxer = (gst_object_unref (muxer), NULL)), _tmp2);
	}
	/* Tell the source to behave like a live source*/
	_dynamic_set_is_live1 (src, TRUE);
	/* Add elements to our source bin*/
	_tmp5 = NULL;
	_tmp4 = NULL;
	_tmp3 = NULL;
	gst_bin_add_many (bin, (_tmp3 = src, (_tmp3 == NULL) ? NULL : gst_object_ref (_tmp3)), (_tmp4 = encoder, (_tmp4 == NULL) ? NULL : gst_object_ref (_tmp4)), (_tmp5 = muxer, (_tmp5 == NULL) ? NULL : gst_object_ref (_tmp5)), NULL);
	/* Link them*/
	gst_element_link_many (src, encoder, muxer, NULL);
	/* Now add the encoder's src pad to the bin*/
	pad = gst_element_get_static_pad (muxer, "src");
	_tmp7 = NULL;
	_tmp6 = NULL;
	_tmp8 = NULL;
	ghost = (_tmp8 = (GstGhostPad*) gst_ghost_pad_new (_tmp7 = g_strconcat (_tmp6 = g_strconcat (gst_object_get_name ((GstObject*) bin), ".", NULL), gst_object_get_name ((GstObject*) pad), NULL), pad), _tmp7 = (g_free (_tmp7), NULL), _tmp6 = (g_free (_tmp6), NULL), _tmp8);
	_tmp9 = NULL;
	gst_element_add_pad ((GstElement*) bin, (_tmp9 = (GstPad*) ghost, (_tmp9 == NULL) ? NULL : gst_object_ref (_tmp9)));
	_tmp10 = NULL;
	return (_tmp10 = (GstElement*) bin, (src == NULL) ? NULL : (src = (gst_object_unref (src), NULL)), (encoder == NULL) ? NULL : (encoder = (gst_object_unref (encoder), NULL)), (muxer == NULL) ? NULL : (muxer = (gst_object_unref (muxer), NULL)), (pad == NULL) ? NULL : (pad = (gst_object_unref (pad), NULL)), (ghost == NULL) ? NULL : (ghost = (gst_object_unref (ghost), NULL)), _tmp10);
}


static void rygel_test_video_item_class_init (RygelTestVideoItemClass * klass) {
	rygel_test_video_item_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_ITEM_CLASS (klass)->create_stream_source = rygel_test_video_item_real_create_stream_source;
}


static void rygel_test_video_item_instance_init (RygelTestVideoItem * self) {
}


GType rygel_test_video_item_get_type (void) {
	static GType rygel_test_video_item_type_id = 0;
	if (rygel_test_video_item_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTestVideoItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_test_video_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTestVideoItem), 0, (GInstanceInitFunc) rygel_test_video_item_instance_init, NULL };
		rygel_test_video_item_type_id = g_type_register_static (RYGEL_TYPE_TEST_ITEM, "RygelTestVideoItem", &g_define_type_info, 0);
	}
	return rygel_test_video_item_type_id;
}




