/*
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2008 Nokia Corporation, all rights reserved.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __RYGEL_TEST_CONTENT_DIR_H__
#define __RYGEL_TEST_CONTENT_DIR_H__

#include <glib.h>
#include <glib-object.h>
#include <rygel-content-directory.h>
#include <rygel-media-container.h>

G_BEGIN_DECLS


#define RYGEL_TYPE_TEST_CONTENT_DIR (rygel_test_content_dir_get_type ())
#define RYGEL_TEST_CONTENT_DIR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TEST_CONTENT_DIR, RygelTestContentDir))
#define RYGEL_TEST_CONTENT_DIR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TEST_CONTENT_DIR, RygelTestContentDirClass))
#define RYGEL_IS_TEST_CONTENT_DIR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TEST_CONTENT_DIR))
#define RYGEL_IS_TEST_CONTENT_DIR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TEST_CONTENT_DIR))
#define RYGEL_TEST_CONTENT_DIR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TEST_CONTENT_DIR, RygelTestContentDirClass))

typedef struct _RygelTestContentDir RygelTestContentDir;
typedef struct _RygelTestContentDirClass RygelTestContentDirClass;
typedef struct _RygelTestContentDirPrivate RygelTestContentDirPrivate;

/**
 * Implementation of ContentDirectory service, meant for testing purposes only.
 */
struct _RygelTestContentDir {
	RygelContentDirectory parent_instance;
	RygelTestContentDirPrivate * priv;
};

struct _RygelTestContentDirClass {
	RygelContentDirectoryClass parent_class;
};


RygelTestContentDir* rygel_test_content_dir_construct (GType object_type);
RygelTestContentDir* rygel_test_content_dir_new (void);
GType rygel_test_content_dir_get_type (void);


G_END_DECLS

#endif
