/* rygel-tracker-insertion-query.c generated by valac 0.12.0, the Vala compiler
 * generated from rygel-tracker-insertion-query.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <rygel.h>


#define RYGEL_TRACKER_TYPE_QUERY (rygel_tracker_query_get_type ())
#define RYGEL_TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQuery))
#define RYGEL_TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQueryClass))
#define RYGEL_TRACKER_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY))
#define RYGEL_TRACKER_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY))
#define RYGEL_TRACKER_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQueryClass))

typedef struct _RygelTrackerQuery RygelTrackerQuery;
typedef struct _RygelTrackerQueryClass RygelTrackerQueryClass;
typedef struct _RygelTrackerQueryPrivate RygelTrackerQueryPrivate;

#define RYGEL_TRACKER_TYPE_RESOURCES_IFACE (rygel_tracker_resources_iface_get_type ())
#define RYGEL_TRACKER_RESOURCES_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_RESOURCES_IFACE, RygelTrackerResourcesIface))
#define RYGEL_TRACKER_IS_RESOURCES_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_RESOURCES_IFACE))
#define RYGEL_TRACKER_RESOURCES_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TRACKER_TYPE_RESOURCES_IFACE, RygelTrackerResourcesIfaceIface))

typedef struct _RygelTrackerResourcesIface RygelTrackerResourcesIface;
typedef struct _RygelTrackerResourcesIfaceIface RygelTrackerResourcesIfaceIface;

#define RYGEL_TRACKER_TYPE_RESOURCES_IFACE_PROXY (rygel_tracker_resources_iface_proxy_get_type ())

#define RYGEL_TRACKER_TYPE_QUERY_TRIPLETS (rygel_tracker_query_triplets_get_type ())
#define RYGEL_TRACKER_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTriplets))
#define RYGEL_TRACKER_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))
#define RYGEL_TRACKER_IS_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS))
#define RYGEL_TRACKER_IS_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS))
#define RYGEL_TRACKER_QUERY_TRIPLETS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))

typedef struct _RygelTrackerQueryTriplets RygelTrackerQueryTriplets;
typedef struct _RygelTrackerQueryTripletsClass RygelTrackerQueryTripletsClass;

#define RYGEL_TRACKER_TYPE_INSERTION_QUERY (rygel_tracker_insertion_query_get_type ())
#define RYGEL_TRACKER_INSERTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_INSERTION_QUERY, RygelTrackerInsertionQuery))
#define RYGEL_TRACKER_INSERTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_INSERTION_QUERY, RygelTrackerInsertionQueryClass))
#define RYGEL_TRACKER_IS_INSERTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_INSERTION_QUERY))
#define RYGEL_TRACKER_IS_INSERTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_INSERTION_QUERY))
#define RYGEL_TRACKER_INSERTION_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_INSERTION_QUERY, RygelTrackerInsertionQueryClass))

typedef struct _RygelTrackerInsertionQuery RygelTrackerInsertionQuery;
typedef struct _RygelTrackerInsertionQueryClass RygelTrackerInsertionQueryClass;
typedef struct _RygelTrackerInsertionQueryPrivate RygelTrackerInsertionQueryPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TRACKER_TYPE_QUERY_TRIPLET (rygel_tracker_query_triplet_get_type ())
#define RYGEL_TRACKER_QUERY_TRIPLET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLET, RygelTrackerQueryTriplet))
#define RYGEL_TRACKER_QUERY_TRIPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLET, RygelTrackerQueryTripletClass))
#define RYGEL_TRACKER_IS_QUERY_TRIPLET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLET))
#define RYGEL_TRACKER_IS_QUERY_TRIPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLET))
#define RYGEL_TRACKER_QUERY_TRIPLET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLET, RygelTrackerQueryTripletClass))

typedef struct _RygelTrackerQueryTriplet RygelTrackerQueryTriplet;
typedef struct _RygelTrackerQueryTripletClass RygelTrackerQueryTripletClass;
#define _rygel_tracker_query_triplet_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_query_triplet_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _rygel_tracker_query_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_query_unref (var), NULL)))

#define RYGEL_TRACKER_TYPE_MINER_FILES_INDEX_IFACE (rygel_tracker_miner_files_index_iface_get_type ())
#define RYGEL_TRACKER_MINER_FILES_INDEX_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_MINER_FILES_INDEX_IFACE, RygelTrackerMinerFilesIndexIface))
#define RYGEL_TRACKER_IS_MINER_FILES_INDEX_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_MINER_FILES_INDEX_IFACE))
#define RYGEL_TRACKER_MINER_FILES_INDEX_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TRACKER_TYPE_MINER_FILES_INDEX_IFACE, RygelTrackerMinerFilesIndexIfaceIface))

typedef struct _RygelTrackerMinerFilesIndexIface RygelTrackerMinerFilesIndexIface;
typedef struct _RygelTrackerMinerFilesIndexIfaceIface RygelTrackerMinerFilesIndexIfaceIface;

#define RYGEL_TRACKER_TYPE_MINER_FILES_INDEX_IFACE_PROXY (rygel_tracker_miner_files_index_iface_proxy_get_type ())
typedef struct _RygelTrackerInsertionQueryExecuteData RygelTrackerInsertionQueryExecuteData;

struct _RygelTrackerResourcesIfaceIface {
	GTypeInterface parent_iface;
	void (*sparql_query) (RygelTrackerResourcesIface* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar** (*sparql_query_finish) (RygelTrackerResourcesIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
	void (*sparql_update) (RygelTrackerResourcesIface* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*sparql_update_finish) (RygelTrackerResourcesIface* self, GAsyncResult* _res_, GError** error);
	void (*sparql_update_blank) (RygelTrackerResourcesIface* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable** (*sparql_update_blank_finish) (RygelTrackerResourcesIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
};

struct _RygelTrackerQuery {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerQueryPrivate * priv;
	RygelTrackerQueryTriplets* triplets;
};

struct _RygelTrackerQueryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerQuery *self);
	void (*execute) (RygelTrackerQuery* self, RygelTrackerResourcesIface* resources, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*execute_finish) (RygelTrackerQuery* self, GAsyncResult* _res_, GError** error);
	gchar* (*to_string) (RygelTrackerQuery* self);
};

struct _RygelTrackerInsertionQuery {
	RygelTrackerQuery parent_instance;
	RygelTrackerInsertionQueryPrivate * priv;
	gchar* id;
};

struct _RygelTrackerInsertionQueryClass {
	RygelTrackerQueryClass parent_class;
};

struct _RygelTrackerInsertionQueryPrivate {
	gchar* uri;
};

struct _RygelTrackerMinerFilesIndexIfaceIface {
	GTypeInterface parent_iface;
	void (*index_file) (RygelTrackerMinerFilesIndexIface* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*index_file_finish) (RygelTrackerMinerFilesIndexIface* self, GAsyncResult* _res_, GError** error);
};

struct _RygelTrackerInsertionQueryExecuteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerInsertionQuery* self;
	RygelTrackerResourcesIface* resources;
	gchar* _tmp0_;
	gchar* str;
	gint _tmp1_;
	gint _tmp2_;
	GHashTable** _tmp3_;
	GHashTable** _result_;
	gint _result__length1;
	gint _result__length2;
	gconstpointer _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gchar** ids;
	gint ids_length1;
	gint ids_length2;
	gchar* _tmp12_;
	GFile* _tmp13_;
	GFile* file;
	gboolean _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	RygelTrackerMinerFilesIndexIface* _tmp17_;
	RygelTrackerMinerFilesIndexIface* miner;
	GError * _inner_error_;
};


static gpointer rygel_tracker_insertion_query_parent_class = NULL;

gpointer rygel_tracker_query_ref (gpointer instance);
void rygel_tracker_query_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_query (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_query (GValue* value, gpointer v_object);
void rygel_tracker_value_take_query (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_query (const GValue* value);
GType rygel_tracker_query_get_type (void) G_GNUC_CONST;
GType rygel_tracker_resources_iface_proxy_get_type (void) G_GNUC_CONST;
guint rygel_tracker_resources_iface_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType rygel_tracker_resources_iface_get_type (void) G_GNUC_CONST;
GType rygel_tracker_query_triplets_get_type (void) G_GNUC_CONST;
GType rygel_tracker_insertion_query_get_type (void) G_GNUC_CONST;
#define RYGEL_TRACKER_INSERTION_QUERY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TRACKER_TYPE_INSERTION_QUERY, RygelTrackerInsertionQueryPrivate))
enum  {
	RYGEL_TRACKER_INSERTION_QUERY_DUMMY_PROPERTY
};
#define RYGEL_TRACKER_INSERTION_QUERY_TEMP_ID "x"
#define RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID "_:" RYGEL_TRACKER_INSERTION_QUERY_TEMP_ID
#define RYGEL_TRACKER_INSERTION_QUERY_MINER_SERVICE "org.freedesktop.Tracker1.Miner.Files.Index"
#define RYGEL_TRACKER_INSERTION_QUERY_MINER_PATH "/org/freedesktop/Tracker1/Miner/Files/Index"
#define RYGEL_TRACKER_INSERTION_QUERY_MINER_GRAPH "urn:uuid:472ed0cc-40ff-4e37-9c0c-062d78656540"
#define RYGEL_TRACKER_INSERTION_QUERY_RESOURCE_ID_QUERY_TEMPLATE "SELECT ?resource WHERE { ?resource a nie:DataObject; nie:url '%s' }"
#define RYGEL_TRACKER_INSERTION_QUERY_RESOURCE_NOT_BOUND_TEMPLATE "OPTIONAL { ?resource a nie:DataObject; nie:url '%s' } " "FILTER (!bound(?resource))"
RygelTrackerInsertionQuery* rygel_tracker_insertion_query_new (RygelMediaItem* item, const gchar* category);
RygelTrackerInsertionQuery* rygel_tracker_insertion_query_construct (GType object_type, RygelMediaItem* item, const gchar* category);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_new (void);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_construct (GType object_type);
RygelTrackerQueryTriplet* rygel_tracker_query_triplet_new (const gchar* subject, const gchar* predicate, const gchar* obj);
RygelTrackerQueryTriplet* rygel_tracker_query_triplet_construct (GType object_type, const gchar* subject, const gchar* predicate, const gchar* obj);
gpointer rygel_tracker_query_triplet_ref (gpointer instance);
void rygel_tracker_query_triplet_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_query_triplet (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_query_triplet (GValue* value, gpointer v_object);
void rygel_tracker_value_take_query_triplet (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_query_triplet (const GValue* value);
GType rygel_tracker_query_triplet_get_type (void) G_GNUC_CONST;
RygelTrackerQueryTriplet* rygel_tracker_query_triplet_new_with_graph (const gchar* graph, const gchar* subject, const gchar* predicate, const gchar* object);
RygelTrackerQueryTriplet* rygel_tracker_query_triplet_construct_with_graph (GType object_type, const gchar* graph, const gchar* subject, const gchar* predicate, const gchar* object);
RygelTrackerQuery* rygel_tracker_query_construct (GType object_type, RygelTrackerQueryTriplets* triplets);
static void rygel_tracker_insertion_query_real_execute_data_free (gpointer _data);
static void rygel_tracker_insertion_query_real_execute (RygelTrackerQuery* base, RygelTrackerResourcesIface* resources, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_tracker_insertion_query_real_execute_co (RygelTrackerInsertionQueryExecuteData* data);
gchar* rygel_tracker_query_to_string (RygelTrackerQuery* self);
void rygel_tracker_resources_iface_sparql_update_blank (RygelTrackerResourcesIface* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
GHashTable** rygel_tracker_resources_iface_sparql_update_blank_finish (RygelTrackerResourcesIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
static void rygel_tracker_insertion_query_execute_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_tracker_resources_iface_sparql_query (RygelTrackerResourcesIface* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar** rygel_tracker_resources_iface_sparql_query_finish (RygelTrackerResourcesIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
static gchar* rygel_tracker_insertion_query_get_resource_id_query (RygelTrackerInsertionQuery* self);
GType rygel_tracker_miner_files_index_iface_proxy_get_type (void) G_GNUC_CONST;
guint rygel_tracker_miner_files_index_iface_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType rygel_tracker_miner_files_index_iface_get_type (void) G_GNUC_CONST;
void rygel_tracker_miner_files_index_iface_index_file (RygelTrackerMinerFilesIndexIface* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_tracker_miner_files_index_iface_index_file_finish (RygelTrackerMinerFilesIndexIface* self, GAsyncResult* _res_, GError** error);
static gchar* rygel_tracker_insertion_query_real_to_string (RygelTrackerQuery* base);
static void rygel_tracker_insertion_query_finalize (RygelTrackerQuery* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


RygelTrackerInsertionQuery* rygel_tracker_insertion_query_construct (GType object_type, RygelMediaItem* item, const gchar* category) {
	RygelTrackerInsertionQuery* self = NULL;
	gchar* _tmp0_;
	gchar* type;
	gpointer _tmp1_ = NULL;
	gchar* _tmp2_;
	GFile* _tmp3_ = NULL;
	GFile* _tmp4_;
	GFile* file;
	gboolean _tmp5_;
	RygelTrackerQueryTriplets* _tmp7_ = NULL;
	RygelTrackerQueryTriplets* triplets;
	RygelTrackerQueryTriplet* _tmp8_ = NULL;
	RygelTrackerQueryTriplet* _tmp9_;
	RygelTrackerQueryTriplet* _tmp10_ = NULL;
	RygelTrackerQueryTriplet* _tmp11_;
	RygelTrackerQueryTriplet* _tmp12_ = NULL;
	RygelTrackerQueryTriplet* _tmp13_;
	RygelTrackerQueryTriplet* _tmp14_ = NULL;
	RygelTrackerQueryTriplet* _tmp15_;
	RygelTrackerQueryTriplet* _tmp16_ = NULL;
	RygelTrackerQueryTriplet* _tmp17_;
	const gchar* _tmp18_ = NULL;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	RygelTrackerQueryTriplet* _tmp23_ = NULL;
	RygelTrackerQueryTriplet* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	RygelTrackerQueryTriplet* _tmp29_ = NULL;
	RygelTrackerQueryTriplet* _tmp30_;
	gpointer _tmp37_ = NULL;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	RygelTrackerQueryTriplet* _tmp43_ = NULL;
	RygelTrackerQueryTriplet* _tmp44_;
	GTimeVal now = {0};
	gchar* _tmp45_ = NULL;
	gchar* date;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	RygelTrackerQueryTriplet* _tmp50_ = NULL;
	RygelTrackerQueryTriplet* _tmp51_;
	gint64 _tmp52_;
	gpointer _tmp62_ = NULL;
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (category != NULL, NULL);
	_tmp0_ = g_strdup ("nie:DataObject");
	type = _tmp0_;
	_tmp1_ = gee_abstract_list_get ((GeeAbstractList*) ((RygelMediaObject*) item)->uris, 0);
	_tmp2_ = (gchar*) _tmp1_;
	_tmp3_ = g_file_new_for_uri (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	file = _tmp4_;
	_tmp5_ = g_file_is_native (file);
	if (!_tmp5_) {
		gchar* _tmp6_;
		_tmp6_ = g_strdup ("nfo:RemoteDataObject");
		_g_free0 (type);
		type = _tmp6_;
	}
	_tmp7_ = rygel_tracker_query_triplets_new ();
	triplets = _tmp7_;
	_tmp8_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "a", category);
	_tmp9_ = _tmp8_;
	gee_abstract_collection_add ((GeeAbstractCollection*) triplets, _tmp9_);
	_rygel_tracker_query_triplet_unref0 (_tmp9_);
	_tmp10_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "a", type);
	_tmp11_ = _tmp10_;
	gee_abstract_collection_add ((GeeAbstractCollection*) triplets, _tmp11_);
	_rygel_tracker_query_triplet_unref0 (_tmp11_);
	_tmp12_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "nmm:uPnPShared", "true");
	_tmp13_ = _tmp12_;
	gee_abstract_collection_add ((GeeAbstractCollection*) triplets, _tmp13_);
	_rygel_tracker_query_triplet_unref0 (_tmp13_);
	_tmp14_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "tracker:available", "true");
	_tmp15_ = _tmp14_;
	gee_abstract_collection_add ((GeeAbstractCollection*) triplets, _tmp15_);
	_rygel_tracker_query_triplet_unref0 (_tmp15_);
	_tmp16_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "nie:generator", "\"rygel\"");
	_tmp17_ = _tmp16_;
	gee_abstract_collection_add ((GeeAbstractCollection*) triplets, _tmp17_);
	_rygel_tracker_query_triplet_unref0 (_tmp17_);
	_tmp18_ = rygel_media_object_get_title ((RygelMediaObject*) item);
	_tmp19_ = g_strconcat ("\"", _tmp18_, NULL);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_strconcat (_tmp20_, "\"", NULL);
	_tmp22_ = _tmp21_;
	_tmp23_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "nie:title", _tmp22_);
	_tmp24_ = _tmp23_;
	gee_abstract_collection_add ((GeeAbstractCollection*) triplets, _tmp24_);
	_rygel_tracker_query_triplet_unref0 (_tmp24_);
	_g_free0 (_tmp22_);
	_g_free0 (_tmp20_);
	_tmp25_ = g_strconcat ("\"", item->mime_type, NULL);
	_tmp26_ = _tmp25_;
	_tmp27_ = g_strconcat (_tmp26_, "\"", NULL);
	_tmp28_ = _tmp27_;
	_tmp29_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "nie:mimeType", _tmp28_);
	_tmp30_ = _tmp29_;
	gee_abstract_collection_add ((GeeAbstractCollection*) triplets, _tmp30_);
	_rygel_tracker_query_triplet_unref0 (_tmp30_);
	_g_free0 (_tmp28_);
	_g_free0 (_tmp26_);
	if (item->dlna_profile != NULL) {
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		RygelTrackerQueryTriplet* _tmp35_ = NULL;
		RygelTrackerQueryTriplet* _tmp36_;
		_tmp31_ = g_strconcat ("\"", item->dlna_profile, NULL);
		_tmp32_ = _tmp31_;
		_tmp33_ = g_strconcat (_tmp32_, "\"", NULL);
		_tmp34_ = _tmp33_;
		_tmp35_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "nmm:dlnaProfile", _tmp34_);
		_tmp36_ = _tmp35_;
		gee_abstract_collection_add ((GeeAbstractCollection*) triplets, _tmp36_);
		_rygel_tracker_query_triplet_unref0 (_tmp36_);
		_g_free0 (_tmp34_);
		_g_free0 (_tmp32_);
	}
	_tmp37_ = gee_abstract_list_get ((GeeAbstractList*) ((RygelMediaObject*) item)->uris, 0);
	_tmp38_ = (gchar*) _tmp37_;
	_tmp39_ = g_strconcat ("\"", _tmp38_, NULL);
	_tmp40_ = _tmp39_;
	_tmp41_ = g_strconcat (_tmp40_, "\"", NULL);
	_tmp42_ = _tmp41_;
	_tmp43_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "nie:url", _tmp42_);
	_tmp44_ = _tmp43_;
	gee_abstract_collection_add ((GeeAbstractCollection*) triplets, _tmp44_);
	_rygel_tracker_query_triplet_unref0 (_tmp44_);
	_g_free0 (_tmp42_);
	_g_free0 (_tmp40_);
	_g_free0 (_tmp38_);
	g_get_current_time (&now);
	_tmp45_ = g_time_val_to_iso8601 (&now);
	date = _tmp45_;
	_tmp46_ = g_strconcat ("\"", date, NULL);
	_tmp47_ = _tmp46_;
	_tmp48_ = g_strconcat (_tmp47_, "\"", NULL);
	_tmp49_ = _tmp48_;
	_tmp50_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "nie:contentCreated", _tmp49_);
	_tmp51_ = _tmp50_;
	gee_abstract_collection_add ((GeeAbstractCollection*) triplets, _tmp51_);
	_rygel_tracker_query_triplet_unref0 (_tmp51_);
	_g_free0 (_tmp49_);
	_g_free0 (_tmp47_);
	_tmp52_ = rygel_media_item_get_size (item);
	if (_tmp52_ > 0) {
		gint64 _tmp53_;
		gchar* _tmp54_ = NULL;
		gchar* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		gchar* _tmp59_;
		RygelTrackerQueryTriplet* _tmp60_ = NULL;
		RygelTrackerQueryTriplet* _tmp61_;
		_tmp53_ = rygel_media_item_get_size (item);
		_tmp54_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp53_);
		_tmp55_ = _tmp54_;
		_tmp56_ = g_strconcat ("\"", _tmp55_, NULL);
		_tmp57_ = _tmp56_;
		_tmp58_ = g_strconcat (_tmp57_, "\"", NULL);
		_tmp59_ = _tmp58_;
		_tmp60_ = rygel_tracker_query_triplet_new_with_graph (RYGEL_TRACKER_INSERTION_QUERY_MINER_GRAPH, RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "nie:byteSize", _tmp59_);
		_tmp61_ = _tmp60_;
		gee_abstract_collection_add ((GeeAbstractCollection*) triplets, _tmp61_);
		_rygel_tracker_query_triplet_unref0 (_tmp61_);
		_g_free0 (_tmp59_);
		_g_free0 (_tmp57_);
		_g_free0 (_tmp55_);
	}
	self = (RygelTrackerInsertionQuery*) rygel_tracker_query_construct (object_type, triplets);
	_tmp62_ = gee_abstract_list_get ((GeeAbstractList*) ((RygelMediaObject*) item)->uris, 0);
	_g_free0 (self->priv->uri);
	self->priv->uri = (gchar*) _tmp62_;
	_g_free0 (date);
	_g_object_unref0 (triplets);
	_g_object_unref0 (file);
	_g_free0 (type);
	return self;
}


RygelTrackerInsertionQuery* rygel_tracker_insertion_query_new (RygelMediaItem* item, const gchar* category) {
	return rygel_tracker_insertion_query_construct (RYGEL_TRACKER_TYPE_INSERTION_QUERY, item, category);
}


static void rygel_tracker_insertion_query_real_execute_data_free (gpointer _data) {
	RygelTrackerInsertionQueryExecuteData* data;
	data = _data;
	_g_object_unref0 (data->resources);
	_rygel_tracker_query_unref0 (data->self);
	g_slice_free (RygelTrackerInsertionQueryExecuteData, data);
}


static gpointer _rygel_tracker_query_ref0 (gpointer self) {
	return self ? rygel_tracker_query_ref (self) : NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_tracker_insertion_query_real_execute (RygelTrackerQuery* base, RygelTrackerResourcesIface* resources, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerInsertionQuery * self;
	RygelTrackerInsertionQueryExecuteData* _data_;
	self = (RygelTrackerInsertionQuery*) base;
	_data_ = g_slice_new0 (RygelTrackerInsertionQueryExecuteData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, rygel_tracker_insertion_query_real_execute);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_insertion_query_real_execute_data_free);
	_data_->self = _rygel_tracker_query_ref0 (self);
	_data_->resources = _g_object_ref0 (resources);
	rygel_tracker_insertion_query_real_execute_co (_data_);
}


static void rygel_tracker_insertion_query_real_execute_finish (RygelTrackerQuery* base, GAsyncResult* _res_, GError** error) {
	RygelTrackerInsertionQueryExecuteData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_tracker_insertion_query_execute_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerInsertionQueryExecuteData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_tracker_insertion_query_real_execute_co (data);
}


static gboolean rygel_tracker_insertion_query_real_execute_co (RygelTrackerInsertionQueryExecuteData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = rygel_tracker_query_to_string ((RygelTrackerQuery*) data->self);
	data->str = data->_tmp0_;
	g_debug ("rygel-tracker-insertion-query.vala:108: Executing SPARQL query: %s", data->str);
	data->_state_ = 1;
	rygel_tracker_resources_iface_sparql_update_blank (data->resources, data->str, rygel_tracker_insertion_query_execute_ready, data);
	return FALSE;
	_state_1:
	data->_tmp3_ = NULL;
	data->_tmp3_ = rygel_tracker_resources_iface_sparql_update_blank_finish (data->resources, data->_res_, &data->_tmp1_, &data->_tmp2_, &data->_inner_error_);
	data->_result_ = data->_tmp3_;
	data->_result__length1 = data->_tmp1_;
	data->_result__length2 = data->_tmp2_;
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == G_IO_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_free0 (data->str);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_free0 (data->str);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->_tmp4_ = NULL;
	data->_tmp4_ = g_hash_table_lookup (data->_result_[(0 * data->_result__length2) + 0], RYGEL_TRACKER_INSERTION_QUERY_TEMP_ID);
	data->_tmp5_ = g_strdup ((const gchar*) data->_tmp4_);
	_g_free0 (data->self->id);
	data->self->id = data->_tmp5_;
	if (data->self->id == NULL) {
		data->_tmp6_ = NULL;
		data->_tmp6_ = rygel_tracker_insertion_query_get_resource_id_query (data->self);
		data->_tmp7_ = data->_tmp6_;
		data->_state_ = 2;
		rygel_tracker_resources_iface_sparql_query (data->resources, data->_tmp7_, rygel_tracker_insertion_query_execute_ready, data);
		return FALSE;
		_state_2:
		data->_tmp10_ = NULL;
		data->_tmp10_ = rygel_tracker_resources_iface_sparql_query_finish (data->resources, data->_res_, &data->_tmp8_, &data->_tmp9_, &data->_inner_error_);
		data->_tmp11_ = data->_tmp10_;
		_g_free0 (data->_tmp7_);
		data->ids = data->_tmp11_;
		data->ids_length1 = data->_tmp8_;
		data->ids_length2 = data->_tmp9_;
		if (data->_inner_error_ != NULL) {
			if (data->_inner_error_->domain == G_IO_ERROR) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				data->_result_ = (_vala_array_free (data->_result_, data->_result__length1 * data->_result__length2, (GDestroyNotify) g_hash_table_unref), NULL);
				_g_free0 (data->str);
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			} else {
				data->_result_ = (_vala_array_free (data->_result_, data->_result__length1 * data->_result__length2, (GDestroyNotify) g_hash_table_unref), NULL);
				_g_free0 (data->str);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
		data->_tmp12_ = g_strdup (data->ids[(0 * data->ids_length2) + 0]);
		_g_free0 (data->self->id);
		data->self->id = data->_tmp12_;
		data->ids = (_vala_array_free (data->ids, data->ids_length1 * data->ids_length2, (GDestroyNotify) g_free), NULL);
	} else {
		data->_tmp13_ = NULL;
		data->_tmp13_ = g_file_new_for_uri (data->self->priv->uri);
		data->file = data->_tmp13_;
		data->_tmp15_ = g_file_is_native (data->file);
		if (data->_tmp15_) {
			data->_tmp16_ = g_file_query_exists (data->file, NULL);
			data->_tmp14_ = data->_tmp16_;
		} else {
			data->_tmp14_ = FALSE;
		}
		if (data->_tmp14_) {
			data->_tmp17_ = NULL;
			data->_tmp17_ = g_initable_new (RYGEL_TRACKER_TYPE_MINER_FILES_INDEX_IFACE_PROXY, NULL, &data->_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", RYGEL_TRACKER_INSERTION_QUERY_MINER_SERVICE, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", RYGEL_TRACKER_INSERTION_QUERY_MINER_PATH, "g-interface-name", "org.freedesktop.Tracker1.Miner.Files.Index", NULL);
			data->miner = (RygelTrackerMinerFilesIndexIface*) data->_tmp17_;
			if (data->_inner_error_ != NULL) {
				if (data->_inner_error_->domain == G_IO_ERROR) {
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					_g_object_unref0 (data->file);
					data->_result_ = (_vala_array_free (data->_result_, data->_result__length1 * data->_result__length2, (GDestroyNotify) g_hash_table_unref), NULL);
					_g_free0 (data->str);
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				} else {
					_g_object_unref0 (data->file);
					data->_result_ = (_vala_array_free (data->_result_, data->_result__length1 * data->_result__length2, (GDestroyNotify) g_hash_table_unref), NULL);
					_g_free0 (data->str);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
					g_clear_error (&data->_inner_error_);
					return FALSE;
				}
			}
			rygel_tracker_miner_files_index_iface_index_file (data->miner, data->self->priv->uri, NULL, NULL);
			_g_object_unref0 (data->miner);
		}
		_g_object_unref0 (data->file);
	}
	g_debug ("rygel-tracker-insertion-query.vala:133: Created item in Tracker store " \
"with ID '%s'", data->self->id);
	data->_result_ = (_vala_array_free (data->_result_, data->_result__length1 * data->_result__length2, (GDestroyNotify) g_hash_table_unref), NULL);
	_g_free0 (data->str);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static gchar* rygel_tracker_insertion_query_real_to_string (RygelTrackerQuery* base) {
	RygelTrackerInsertionQuery * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* query;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	self = (RygelTrackerInsertionQuery*) base;
	_tmp0_ = RYGEL_TRACKER_QUERY_CLASS (rygel_tracker_insertion_query_parent_class)->to_string (RYGEL_TRACKER_QUERY (self));
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("INSERT { ", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, " }", NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	query = _tmp5_;
	_tmp6_ = g_strdup_printf (RYGEL_TRACKER_INSERTION_QUERY_RESOURCE_NOT_BOUND_TEMPLATE, self->priv->uri);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat ("WHERE {", _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, "}", NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat (query, _tmp11_, NULL);
	_g_free0 (query);
	query = _tmp12_;
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	result = query;
	return result;
}


static gchar* rygel_tracker_insertion_query_get_resource_id_query (RygelTrackerInsertionQuery* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup_printf (RYGEL_TRACKER_INSERTION_QUERY_RESOURCE_ID_QUERY_TEMPLATE, self->priv->uri);
	result = _tmp0_;
	return result;
}


static void rygel_tracker_insertion_query_class_init (RygelTrackerInsertionQueryClass * klass) {
	rygel_tracker_insertion_query_parent_class = g_type_class_peek_parent (klass);
	RYGEL_TRACKER_QUERY_CLASS (klass)->finalize = rygel_tracker_insertion_query_finalize;
	g_type_class_add_private (klass, sizeof (RygelTrackerInsertionQueryPrivate));
	RYGEL_TRACKER_QUERY_CLASS (klass)->execute = rygel_tracker_insertion_query_real_execute;
	RYGEL_TRACKER_QUERY_CLASS (klass)->execute_finish = rygel_tracker_insertion_query_real_execute_finish;
	RYGEL_TRACKER_QUERY_CLASS (klass)->to_string = rygel_tracker_insertion_query_real_to_string;
}


static void rygel_tracker_insertion_query_instance_init (RygelTrackerInsertionQuery * self) {
	self->priv = RYGEL_TRACKER_INSERTION_QUERY_GET_PRIVATE (self);
}


static void rygel_tracker_insertion_query_finalize (RygelTrackerQuery* obj) {
	RygelTrackerInsertionQuery * self;
	self = RYGEL_TRACKER_INSERTION_QUERY (obj);
	_g_free0 (self->id);
	_g_free0 (self->priv->uri);
	RYGEL_TRACKER_QUERY_CLASS (rygel_tracker_insertion_query_parent_class)->finalize (obj);
}


/**
 * Represents Tracker SPARQL Insertion query
 */
GType rygel_tracker_insertion_query_get_type (void) {
	static volatile gsize rygel_tracker_insertion_query_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_tracker_insertion_query_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerInsertionQueryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_tracker_insertion_query_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTrackerInsertionQuery), 0, (GInstanceInitFunc) rygel_tracker_insertion_query_instance_init, NULL };
		GType rygel_tracker_insertion_query_type_id;
		rygel_tracker_insertion_query_type_id = g_type_register_static (RYGEL_TRACKER_TYPE_QUERY, "RygelTrackerInsertionQuery", &g_define_type_info, 0);
		g_once_init_leave (&rygel_tracker_insertion_query_type_id__volatile, rygel_tracker_insertion_query_type_id);
	}
	return rygel_tracker_insertion_query_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



