/* rygel-http-gst-sink.c generated by valac 0.12.0, the Vala compiler
 * generated from rygel-http-gst-sink.vala, do not modify */

/*
 * Copyright (C) 2011 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/base/gstbasesink.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>
#include <libsoup/soup.h>


#define RYGEL_TYPE_HTTP_GST_SINK (rygel_http_gst_sink_get_type ())
#define RYGEL_HTTP_GST_SINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GST_SINK, RygelHTTPGstSink))
#define RYGEL_HTTP_GST_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GST_SINK, RygelHTTPGstSinkClass))
#define RYGEL_IS_HTTP_GST_SINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GST_SINK))
#define RYGEL_IS_HTTP_GST_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GST_SINK))
#define RYGEL_HTTP_GST_SINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GST_SINK, RygelHTTPGstSinkClass))

typedef struct _RygelHTTPGstSink RygelHTTPGstSink;
typedef struct _RygelHTTPGstSinkClass RygelHTTPGstSinkClass;
typedef struct _RygelHTTPGstSinkPrivate RygelHTTPGstSinkPrivate;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_mutex_free0(var) ((var == NULL) ? NULL : (var = (g_mutex_free (var), NULL)))
#define _g_cond_free0(var) ((var == NULL) ? NULL : (var = (g_cond_free (var), NULL)))

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;
typedef struct _RygelHTTPResponsePrivate RygelHTTPResponsePrivate;

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;

#define RYGEL_TYPE_HTTP_BYTE_SEEK (rygel_http_byte_seek_get_type ())
#define RYGEL_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeek))
#define RYGEL_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))
#define RYGEL_IS_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_IS_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_HTTP_BYTE_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))

typedef struct _RygelHTTPByteSeek RygelHTTPByteSeek;
typedef struct _RygelHTTPByteSeekClass RygelHTTPByteSeekClass;
typedef struct _Block2Data Block2Data;
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
#define _gst_buffer_unref0(var) ((var == NULL) ? NULL : (var = (gst_buffer_unref (var), NULL)))
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))

struct _RygelHTTPGstSink {
	GstBaseSink parent_instance;
	RygelHTTPGstSinkPrivate * priv;
	GCancellable* cancellable;
};

struct _RygelHTTPGstSinkClass {
	GstBaseSinkClass parent_class;
};

struct _RygelHTTPGstSinkPrivate {
	RygelHTTPResponse* response;
	gint priority;
	gint64 chunks_buffered;
	gint64 bytes_sent;
	gint64 max_bytes;
	GMutex* buffer_mutex;
	GCond* buffer_condition;
};

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPResponse {
	GObject parent_instance;
	RygelHTTPResponsePrivate * priv;
	SoupMessage* msg;
	RygelHTTPSeek* seek;
};

struct _RygelHTTPResponseClass {
	GObjectClass parent_class;
	void (*end) (RygelHTTPResponse* self, gboolean aborted, guint status);
};

struct _Block2Data {
	int _ref_count_;
	RygelHTTPGstSink * self;
	GstBuffer* buffer;
};


static gpointer rygel_http_gst_sink_parent_class = NULL;

GType rygel_http_gst_sink_get_type (void) G_GNUC_CONST;
GType rygel_http_response_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_GST_SINK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_GST_SINK, RygelHTTPGstSinkPrivate))
enum  {
	RYGEL_HTTP_GST_SINK_DUMMY_PROPERTY
};
#define RYGEL_HTTP_GST_SINK_NAME "http-gst-sink"
#define RYGEL_HTTP_GST_SINK_PAD_NAME "sink"
#define RYGEL_HTTP_GST_SINK_MAX_BUFFERED_CHUNKS ((guint) 32)
#define RYGEL_HTTP_GST_SINK_MIN_BUFFERED_CHUNKS ((guint) 4)
RygelHTTPGstSink* rygel_http_gst_sink_new (RygelHTTPResponse* response);
RygelHTTPGstSink* rygel_http_gst_sink_construct (GType object_type, RygelHTTPResponse* response);
gint rygel_http_response_get_priority (RygelHTTPResponse* self);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_get_type (void) G_GNUC_CONST;
GType rygel_http_byte_seek_get_type (void) G_GNUC_CONST;
gint64 rygel_http_seek_get_length (RygelHTTPSeek* self);
static void rygel_http_gst_sink_on_cancelled (RygelHTTPGstSink* self);
static void _rygel_http_gst_sink_on_cancelled_g_cancellable_cancelled (GCancellable* _sender, gpointer self);
static void rygel_http_gst_sink_on_wrote_chunk (RygelHTTPGstSink* self, SoupMessage* msg);
static void _rygel_http_gst_sink_on_wrote_chunk_soup_message_wrote_chunk (SoupMessage* _sender, gpointer self);
static GstFlowReturn rygel_http_gst_sink_real_render (GstBaseSink* base, GstBuffer* buffer);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static gboolean _lambda2_ (Block2Data* _data2_);
gboolean rygel_http_gst_sink_push_data (RygelHTTPGstSink* self, GstBuffer* buffer);
static gboolean __lambda2__gsource_func (gpointer self);
void rygel_http_response_push_data (RygelHTTPResponse* self, guint8* data, int data_length1);
static void rygel_http_gst_sink_finalize (GObject* obj);


static void _rygel_http_gst_sink_on_cancelled_g_cancellable_cancelled (GCancellable* _sender, gpointer self) {
	rygel_http_gst_sink_on_cancelled (self);
}


static void _rygel_http_gst_sink_on_wrote_chunk_soup_message_wrote_chunk (SoupMessage* _sender, gpointer self) {
	rygel_http_gst_sink_on_wrote_chunk (self, _sender);
}


RygelHTTPGstSink* rygel_http_gst_sink_construct (GType object_type, RygelHTTPResponse* response) {
	RygelHTTPGstSink * self = NULL;
	GMutex* _tmp0_ = NULL;
	GCond* _tmp1_ = NULL;
	GCancellable* _tmp2_ = NULL;
	gint _tmp3_;
	g_return_val_if_fail (response != NULL, NULL);
	self = (RygelHTTPGstSink*) g_object_new (object_type, NULL);
	self->priv->chunks_buffered = (gint64) 0;
	self->priv->bytes_sent = (gint64) 0;
	self->priv->max_bytes = G_MAXINT64;
	_tmp0_ = g_mutex_new ();
	_g_mutex_free0 (self->priv->buffer_mutex);
	self->priv->buffer_mutex = _tmp0_;
	_tmp1_ = g_cond_new ();
	_g_cond_free0 (self->priv->buffer_condition);
	self->priv->buffer_condition = _tmp1_;
	_tmp2_ = g_cancellable_new ();
	_g_object_unref0 (self->cancellable);
	self->cancellable = _tmp2_;
	_tmp3_ = rygel_http_response_get_priority (response);
	self->priv->priority = _tmp3_;
	self->priv->response = response;
	gst_base_sink_set_sync ((GstBaseSink*) self, FALSE);
	gst_object_set_name ((GstObject*) self, RYGEL_HTTP_GST_SINK_NAME);
	if (response->seek != NULL) {
		if (RYGEL_IS_HTTP_BYTE_SEEK (response->seek)) {
			gint64 _tmp4_;
			_tmp4_ = rygel_http_seek_get_length (response->seek);
			self->priv->max_bytes = _tmp4_;
		}
	}
	g_signal_connect_object (self->cancellable, "cancelled", (GCallback) _rygel_http_gst_sink_on_cancelled_g_cancellable_cancelled, self, 0);
	g_signal_connect_object (response->msg, "wrote-chunk", (GCallback) _rygel_http_gst_sink_on_wrote_chunk_soup_message_wrote_chunk, self, 0);
	return self;
}


RygelHTTPGstSink* rygel_http_gst_sink_new (RygelHTTPResponse* response) {
	return rygel_http_gst_sink_construct (RYGEL_TYPE_HTTP_GST_SINK, response);
}


static gpointer _gst_buffer_ref0 (gpointer self) {
	return self ? gst_buffer_ref (self) : NULL;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_gst_object_unref0 (_data2_->self);
		_gst_buffer_unref0 (_data2_->buffer);
		g_slice_free (Block2Data, _data2_);
	}
}


static gboolean _lambda2_ (Block2Data* _data2_) {
	RygelHTTPGstSink * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = _data2_->self;
	_tmp0_ = rygel_http_gst_sink_push_data (self, _data2_->buffer);
	result = _tmp0_;
	return result;
}


static gboolean __lambda2__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda2_ (self);
	return result;
}


static GstFlowReturn rygel_http_gst_sink_real_render (GstBaseSink* base, GstBuffer* buffer) {
	RygelHTTPGstSink * self;
	GstFlowReturn result = 0;
	Block2Data* _data2_;
	gboolean _tmp2_;
	self = (RygelHTTPGstSink*) base;
	g_return_val_if_fail (buffer != NULL, 0);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = gst_object_ref (self);
	_data2_->buffer = _gst_buffer_ref0 (buffer);
	g_mutex_lock (self->priv->buffer_mutex);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_;
		_tmp1_ = g_cancellable_is_cancelled (self->cancellable);
		if (!_tmp1_) {
			_tmp0_ = self->priv->chunks_buffered > RYGEL_HTTP_GST_SINK_MAX_BUFFERED_CHUNKS;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		g_cond_wait (self->priv->buffer_condition, self->priv->buffer_mutex);
	}
	g_mutex_unlock (self->priv->buffer_mutex);
	_tmp2_ = g_cancellable_is_cancelled (self->cancellable);
	if (_tmp2_) {
		result = GST_FLOW_OK;
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return result;
	}
	g_idle_add_full (self->priv->priority, __lambda2__gsource_func, block2_data_ref (_data2_), block2_data_unref);
	result = GST_FLOW_OK;
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}


gboolean rygel_http_gst_sink_push_data (RygelHTTPGstSink* self, GstBuffer* buffer) {
	gboolean result = FALSE;
	gint64 left;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gint64 _tmp2_;
	gint64 to_send;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (buffer != NULL, FALSE);
	left = self->priv->max_bytes - self->priv->bytes_sent;
	_tmp1_ = g_cancellable_is_cancelled (self->cancellable);
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = left <= 0;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = MIN ((gint64) buffer->size, left);
	to_send = _tmp2_;
	rygel_http_response_push_data (self->priv->response, buffer->data + 0, to_send - 0);
	self->priv->chunks_buffered++;
	self->priv->bytes_sent = self->priv->bytes_sent + to_send;
	result = FALSE;
	return result;
}


static void rygel_http_gst_sink_on_wrote_chunk (RygelHTTPGstSink* self, SoupMessage* msg) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	g_mutex_lock (self->priv->buffer_mutex);
	self->priv->chunks_buffered--;
	if (self->priv->chunks_buffered < RYGEL_HTTP_GST_SINK_MIN_BUFFERED_CHUNKS) {
		g_cond_broadcast (self->priv->buffer_condition);
	}
	g_mutex_unlock (self->priv->buffer_mutex);
}


static void rygel_http_gst_sink_on_cancelled (RygelHTTPGstSink* self) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	g_mutex_lock (self->priv->buffer_mutex);
	g_cond_broadcast (self->priv->buffer_condition);
	g_mutex_unlock (self->priv->buffer_mutex);
	g_signal_parse_name ("wrote-chunk", SOUP_TYPE_MESSAGE, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (self->priv->response->msg, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _rygel_http_gst_sink_on_wrote_chunk_soup_message_wrote_chunk, self);
}


static gpointer _gst_caps_ref0 (gpointer self) {
	return self ? gst_caps_ref (self) : NULL;
}


static void rygel_http_gst_sink_class_init (RygelHTTPGstSinkClass * klass) {
	GstCaps* _tmp0_ = NULL;
	GstCaps* caps;
	GstCaps* _tmp1_;
	GstPadTemplate* _tmp2_ = NULL;
	GstPadTemplate* template;
	rygel_http_gst_sink_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPGstSinkPrivate));
	GST_BASE_SINK_CLASS (klass)->render = rygel_http_gst_sink_real_render;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_gst_sink_finalize;
	_tmp0_ = gst_caps_new_any ();
	caps = _tmp0_;
	_tmp1_ = _gst_caps_ref0 (caps);
	_tmp2_ = gst_pad_template_new (RYGEL_HTTP_GST_SINK_PAD_NAME, GST_PAD_SINK, GST_PAD_ALWAYS, _tmp1_);
	template = _tmp2_;
	gst_element_class_add_pad_template (GST_ELEMENT_CLASS (klass), template);
	_gst_object_unref0 (template);
	_gst_caps_unref0 (caps);
}


static void rygel_http_gst_sink_instance_init (RygelHTTPGstSink * self) {
	self->priv = RYGEL_HTTP_GST_SINK_GET_PRIVATE (self);
}


static void rygel_http_gst_sink_finalize (GObject* obj) {
	RygelHTTPGstSink * self;
	self = RYGEL_HTTP_GST_SINK (obj);
	_g_object_unref0 (self->cancellable);
	_g_mutex_free0 (self->priv->buffer_mutex);
	_g_cond_free0 (self->priv->buffer_condition);
	G_OBJECT_CLASS (rygel_http_gst_sink_parent_class)->finalize (obj);
}


GType rygel_http_gst_sink_get_type (void) {
	static volatile gsize rygel_http_gst_sink_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_gst_sink_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGstSinkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_gst_sink_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGstSink), 0, (GInstanceInitFunc) rygel_http_gst_sink_instance_init, NULL };
		GType rygel_http_gst_sink_type_id;
		rygel_http_gst_sink_type_id = g_type_register_static (GST_TYPE_BASE_SINK, "RygelHTTPGstSink", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_gst_sink_type_id__volatile, rygel_http_gst_sink_type_id);
	}
	return rygel_http_gst_sink_type_id__volatile;
}



