/* rygel-tracker-music-item-factory.c generated by valac 0.12.0, the Vala compiler
 * generated from rygel-tracker-music-item-factory.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation.
 * Copyright (C) 2010 MediaNet Inh.
 *
 * Authors: Zeeshan Ali <zeenix@gmail.com>
 *          Sunil Mohan Adapa <sunil@medhas.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <rygel.h>
#include <gee.h>


#define RYGEL_TRACKER_TYPE_ITEM_FACTORY (rygel_tracker_item_factory_get_type ())
#define RYGEL_TRACKER_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactory))
#define RYGEL_TRACKER_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryClass))
#define RYGEL_TRACKER_IS_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY))
#define RYGEL_TRACKER_IS_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_ITEM_FACTORY))
#define RYGEL_TRACKER_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryClass))

typedef struct _RygelTrackerItemFactory RygelTrackerItemFactory;
typedef struct _RygelTrackerItemFactoryClass RygelTrackerItemFactoryClass;
typedef struct _RygelTrackerItemFactoryPrivate RygelTrackerItemFactoryPrivate;

#define RYGEL_TRACKER_TYPE_SEARCH_CONTAINER (rygel_tracker_search_container_get_type ())
#define RYGEL_TRACKER_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainer))
#define RYGEL_TRACKER_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))
#define RYGEL_TRACKER_IS_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER))
#define RYGEL_TRACKER_IS_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER))
#define RYGEL_TRACKER_SEARCH_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))

typedef struct _RygelTrackerSearchContainer RygelTrackerSearchContainer;
typedef struct _RygelTrackerSearchContainerClass RygelTrackerSearchContainerClass;

#define RYGEL_TRACKER_TYPE_MUSIC_ITEM_FACTORY (rygel_tracker_music_item_factory_get_type ())
#define RYGEL_TRACKER_MUSIC_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_MUSIC_ITEM_FACTORY, RygelTrackerMusicItemFactory))
#define RYGEL_TRACKER_MUSIC_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_MUSIC_ITEM_FACTORY, RygelTrackerMusicItemFactoryClass))
#define RYGEL_TRACKER_IS_MUSIC_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_MUSIC_ITEM_FACTORY))
#define RYGEL_TRACKER_IS_MUSIC_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_MUSIC_ITEM_FACTORY))
#define RYGEL_TRACKER_MUSIC_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_MUSIC_ITEM_FACTORY, RygelTrackerMusicItemFactoryClass))

typedef struct _RygelTrackerMusicItemFactory RygelTrackerMusicItemFactory;
typedef struct _RygelTrackerMusicItemFactoryClass RygelTrackerMusicItemFactoryClass;
typedef struct _RygelTrackerMusicItemFactoryPrivate RygelTrackerMusicItemFactoryPrivate;

#define RYGEL_TRACKER_ITEM_FACTORY_TYPE_METADATA (rygel_tracker_item_factory_metadata_get_type ())

#define RYGEL_TRACKER_MUSIC_ITEM_FACTORY_TYPE_MUSIC_METADATA (rygel_tracker_music_item_factory_music_metadata_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelTrackerItemFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerItemFactoryPrivate * priv;
	gchar* category;
	gchar* upnp_class;
	gchar* upload_dir;
	GeeArrayList* properties;
};

struct _RygelTrackerItemFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerItemFactory *self);
	RygelMediaItem* (*create) (RygelTrackerItemFactory* self, const gchar* id, const gchar* uri, RygelTrackerSearchContainer* parent, gchar** metadata, int metadata_length1, GError** error);
	void (*set_metadata) (RygelTrackerItemFactory* self, RygelMediaItem* item, const gchar* uri, gchar** metadata, int metadata_length1, GError** error);
};

struct _RygelTrackerMusicItemFactory {
	RygelTrackerItemFactory parent_instance;
	RygelTrackerMusicItemFactoryPrivate * priv;
};

struct _RygelTrackerMusicItemFactoryClass {
	RygelTrackerItemFactoryClass parent_class;
};

typedef enum  {
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_URL,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_FILE_NAME,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_TITLE,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_DLNA_PROFILE,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_MIME,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_SIZE,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_DATE,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_LAST_KEY
} RygelTrackerItemFactoryMetadata;

typedef enum  {
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_DURATION = RYGEL_TRACKER_ITEM_FACTORY_METADATA_LAST_KEY,
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ALBUM,
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ARTIST,
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_TRACK_NUM,
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_GENRE,
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_SAMPLE_RATE,
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_CHANNELS,
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITS_PER_SAMPLE,
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITRATE,
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_LAST_KEY
} RygelTrackerMusicItemFactoryMusicMetadata;


static gpointer rygel_tracker_music_item_factory_parent_class = NULL;

gpointer rygel_tracker_item_factory_ref (gpointer instance);
void rygel_tracker_item_factory_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_item_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_item_factory (GValue* value, gpointer v_object);
void rygel_tracker_value_take_item_factory (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_item_factory (const GValue* value);
GType rygel_tracker_item_factory_get_type (void) G_GNUC_CONST;
GType rygel_tracker_search_container_get_type (void) G_GNUC_CONST;
GType rygel_tracker_music_item_factory_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_DUMMY_PROPERTY
};
GType rygel_tracker_item_factory_metadata_get_type (void) G_GNUC_CONST;
static GType rygel_tracker_music_item_factory_music_metadata_get_type (void) G_GNUC_UNUSED;
#define RYGEL_TRACKER_MUSIC_ITEM_FACTORY_CATEGORY "nmm:MusicPiece"
RygelTrackerMusicItemFactory* rygel_tracker_music_item_factory_new (void);
RygelTrackerMusicItemFactory* rygel_tracker_music_item_factory_construct (GType object_type);
RygelTrackerItemFactory* rygel_tracker_item_factory_construct (GType object_type, const gchar* category, const gchar* upnp_class, const gchar* upload_dir);
static RygelMediaItem* rygel_tracker_music_item_factory_real_create (RygelTrackerItemFactory* base, const gchar* id, const gchar* uri, RygelTrackerSearchContainer* parent, gchar** metadata, int metadata_length1, GError** error);
void rygel_tracker_item_factory_set_metadata (RygelTrackerItemFactory* self, RygelMediaItem* item, const gchar* uri, gchar** metadata, int metadata_length1, GError** error);
static void rygel_tracker_music_item_factory_real_set_metadata (RygelTrackerItemFactory* base, RygelMediaItem* item, const gchar* uri, gchar** metadata, int metadata_length1, GError** error);


static GType rygel_tracker_music_item_factory_music_metadata_get_type (void) {
	static volatile gsize rygel_tracker_music_item_factory_music_metadata_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_tracker_music_item_factory_music_metadata_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_DURATION, "RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_DURATION", "duration"}, {RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ALBUM, "RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ALBUM", "audio-album"}, {RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ARTIST, "RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ARTIST", "audio-artist"}, {RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_TRACK_NUM, "RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_TRACK_NUM", "audio-track-num"}, {RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_GENRE, "RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_GENRE", "audio-genre"}, {RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_SAMPLE_RATE, "RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_SAMPLE_RATE", "sample-rate"}, {RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_CHANNELS, "RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_CHANNELS", "channels"}, {RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITS_PER_SAMPLE, "RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITS_PER_SAMPLE", "bits-per-sample"}, {RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITRATE, "RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITRATE", "bitrate"}, {RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_LAST_KEY, "RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_LAST_KEY", "last-key"}, {0, NULL, NULL}};
		GType rygel_tracker_music_item_factory_music_metadata_type_id;
		rygel_tracker_music_item_factory_music_metadata_type_id = g_enum_register_static ("RygelTrackerMusicItemFactoryMusicMetadata", values);
		g_once_init_leave (&rygel_tracker_music_item_factory_music_metadata_type_id__volatile, rygel_tracker_music_item_factory_music_metadata_type_id);
	}
	return rygel_tracker_music_item_factory_music_metadata_type_id__volatile;
}


RygelTrackerMusicItemFactory* rygel_tracker_music_item_factory_construct (GType object_type) {
	RygelTrackerMusicItemFactory* self = NULL;
	const gchar* _tmp0_ = NULL;
	_tmp0_ = g_get_user_special_dir (G_USER_DIRECTORY_MUSIC);
	self = (RygelTrackerMusicItemFactory*) rygel_tracker_item_factory_construct (object_type, RYGEL_TRACKER_MUSIC_ITEM_FACTORY_CATEGORY, RYGEL_MUSIC_ITEM_UPNP_CLASS, _tmp0_);
	gee_abstract_collection_add ((GeeAbstractCollection*) ((RygelTrackerItemFactory*) self)->properties, "res@duration");
	gee_abstract_collection_add ((GeeAbstractCollection*) ((RygelTrackerItemFactory*) self)->properties, "upnp:album");
	gee_abstract_collection_add ((GeeAbstractCollection*) ((RygelTrackerItemFactory*) self)->properties, "upnp:artist");
	gee_abstract_collection_add ((GeeAbstractCollection*) ((RygelTrackerItemFactory*) self)->properties, "upnp:originalTrackNumber");
	gee_abstract_collection_add ((GeeAbstractCollection*) ((RygelTrackerItemFactory*) self)->properties, "upnp:genre");
	gee_abstract_collection_add ((GeeAbstractCollection*) ((RygelTrackerItemFactory*) self)->properties, "sampleRate");
	gee_abstract_collection_add ((GeeAbstractCollection*) ((RygelTrackerItemFactory*) self)->properties, "upnp:nrAudioChannels");
	gee_abstract_collection_add ((GeeAbstractCollection*) ((RygelTrackerItemFactory*) self)->properties, "upnp:bitsPerSample");
	gee_abstract_collection_add ((GeeAbstractCollection*) ((RygelTrackerItemFactory*) self)->properties, "upnp:bitrate");
	return self;
}


RygelTrackerMusicItemFactory* rygel_tracker_music_item_factory_new (void) {
	return rygel_tracker_music_item_factory_construct (RYGEL_TRACKER_TYPE_MUSIC_ITEM_FACTORY);
}


static RygelMediaItem* rygel_tracker_music_item_factory_real_create (RygelTrackerItemFactory* base, const gchar* id, const gchar* uri, RygelTrackerSearchContainer* parent, gchar** metadata, int metadata_length1, GError** error) {
	RygelTrackerMusicItemFactory * self;
	RygelMediaItem* result = NULL;
	RygelMusicItem* _tmp0_ = NULL;
	RygelMusicItem* item;
	GError * _inner_error_ = NULL;
	self = (RygelTrackerMusicItemFactory*) base;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	_tmp0_ = rygel_music_item_new (id, (RygelMediaContainer*) parent, "", RYGEL_MUSIC_ITEM_UPNP_CLASS);
	item = _tmp0_;
	rygel_tracker_item_factory_set_metadata ((RygelTrackerItemFactory*) self, (RygelMediaItem*) item, uri, metadata, metadata_length1, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (item);
		return NULL;
	}
	result = (RygelMediaItem*) item;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_tracker_music_item_factory_real_set_metadata (RygelTrackerItemFactory* base, RygelMediaItem* item, const gchar* uri, gchar** metadata, int metadata_length1, GError** error) {
	RygelTrackerMusicItemFactory * self;
	RygelMediaItem* _tmp0_;
	RygelMusicItem* _tmp1_;
	RygelMusicItem* music;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GError * _inner_error_ = NULL;
	self = (RygelTrackerMusicItemFactory*) base;
	g_return_if_fail (item != NULL);
	g_return_if_fail (uri != NULL);
	RYGEL_TRACKER_ITEM_FACTORY_CLASS (rygel_tracker_music_item_factory_parent_class)->set_metadata (RYGEL_TRACKER_ITEM_FACTORY (self), item, uri, metadata, metadata_length1, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp0_ = item;
	_tmp1_ = _g_object_ref0 (RYGEL_IS_MUSIC_ITEM (_tmp0_) ? ((RygelMusicItem*) _tmp0_) : NULL);
	music = _tmp1_;
	if (g_strcmp0 (metadata[RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_DURATION], "") != 0) {
		_tmp2_ = g_strcmp0 (metadata[RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_DURATION], "0") != 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gint _tmp3_;
		_tmp3_ = atoi (metadata[RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_DURATION]);
		((RygelAudioItem*) music)->duration = (glong) _tmp3_;
	}
	if (g_strcmp0 (metadata[RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_SAMPLE_RATE], "") != 0) {
		gint _tmp4_;
		_tmp4_ = atoi (metadata[RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_SAMPLE_RATE]);
		((RygelAudioItem*) music)->sample_freq = _tmp4_;
	}
	if (g_strcmp0 (metadata[RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_CHANNELS], "") != 0) {
		gint _tmp5_;
		_tmp5_ = atoi (metadata[RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_CHANNELS]);
		((RygelAudioItem*) music)->channels = _tmp5_;
	}
	if (g_strcmp0 (metadata[RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITS_PER_SAMPLE], "") != 0) {
		gchar* _tmp6_;
		gchar* bits_per_sample;
		gint _tmp7_;
		_tmp6_ = g_strdup (metadata[RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITS_PER_SAMPLE]);
		bits_per_sample = _tmp6_;
		_tmp7_ = atoi (bits_per_sample);
		((RygelAudioItem*) music)->bits_per_sample = _tmp7_;
		_g_free0 (bits_per_sample);
	}
	if (g_strcmp0 (metadata[RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITRATE], "") != 0) {
		gint _tmp8_;
		_tmp8_ = atoi (metadata[RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITRATE]);
		((RygelAudioItem*) music)->bitrate = _tmp8_ / 8;
	}
	if (g_strcmp0 (metadata[RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_TRACK_NUM], "") != 0) {
		gchar* _tmp9_;
		gchar* track_number;
		gint _tmp10_;
		_tmp9_ = g_strdup (metadata[RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_TRACK_NUM]);
		track_number = _tmp9_;
		_tmp10_ = atoi (track_number);
		music->track_number = _tmp10_;
		_g_free0 (track_number);
	}
	_tmp11_ = g_strdup (metadata[RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ARTIST]);
	_g_free0 (music->artist);
	music->artist = _tmp11_;
	_tmp12_ = g_strdup (metadata[RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ALBUM]);
	_g_free0 (music->album);
	music->album = _tmp12_;
	_tmp13_ = g_strdup (metadata[RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_GENRE]);
	_g_free0 (music->genre);
	music->genre = _tmp13_;
	rygel_music_item_lookup_album_art (music);
	_g_object_unref0 (music);
}


static void rygel_tracker_music_item_factory_class_init (RygelTrackerMusicItemFactoryClass * klass) {
	rygel_tracker_music_item_factory_parent_class = g_type_class_peek_parent (klass);
	RYGEL_TRACKER_ITEM_FACTORY_CLASS (klass)->create = rygel_tracker_music_item_factory_real_create;
	RYGEL_TRACKER_ITEM_FACTORY_CLASS (klass)->set_metadata = rygel_tracker_music_item_factory_real_set_metadata;
}


static void rygel_tracker_music_item_factory_instance_init (RygelTrackerMusicItemFactory * self) {
}


/**
 * Tracker music item factory.
 */
GType rygel_tracker_music_item_factory_get_type (void) {
	static volatile gsize rygel_tracker_music_item_factory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_tracker_music_item_factory_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerMusicItemFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_tracker_music_item_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTrackerMusicItemFactory), 0, (GInstanceInitFunc) rygel_tracker_music_item_factory_instance_init, NULL };
		GType rygel_tracker_music_item_factory_type_id;
		rygel_tracker_music_item_factory_type_id = g_type_register_static (RYGEL_TRACKER_TYPE_ITEM_FACTORY, "RygelTrackerMusicItemFactory", &g_define_type_info, 0);
		g_once_init_leave (&rygel_tracker_music_item_factory_type_id__volatile, rygel_tracker_music_item_factory_type_id);
	}
	return rygel_tracker_music_item_factory_type_id__volatile;
}



