/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <glib.h>
#include <gdk/gdkpixbuf.h>
#include "jg_jnu.h"

#ifdef __cplusplus
extern "C" 
{
#endif

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_set_pixbuf
 */
JNIEXPORT void JNICALL Java_org_gnu_glib_Value_g_1value_1set_1pixbuf (JNIEnv *env, jclass cls, 
    jobject value, jobject obj) 
{
    g_value_set_object ((GValue*)getPointerFromHandle(env, value), (GdkPixbuf*)getPointerFromHandle(env, obj));
}

/*
 */
JNIEXPORT jint JNICALL Java_org_gnu_glib_Value_g_1value_1get_1pixbuf (JNIEnv *env, jclass 
    cls, jint value) 
{
    GValue *value_g = (GValue *)value;
    {
        gpointer pointer_g = (gpointer) (g_value_get_pointer (value_g));
        return (jint) pointer_g;
    }
}

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_set_java_object
 */
JNIEXPORT void JNICALL Java_org_gnu_glib_Value_g_1value_1set_1java_1object (JNIEnv *env, jclass cls, 
    jint value, jobject obj) 
{
	gpointer ptr =  (*env)->NewGlobalRef(env, obj);
    GValue *value_g = (GValue *)value;
    {
        g_value_set_pointer (value_g, ptr);
    }
}

/*
 */
JNIEXPORT jobject JNICALL Java_org_gnu_glib_Value_g_1value_1get_1java_1object (JNIEnv *env, jclass 
    cls, jint value) 
{
    GValue *value_g = (GValue *)value;
    {
        gpointer pointer_g = (gpointer) (g_value_get_pointer (value_g));
        return (jobject) pointer_g;
    }
}

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_init
 * Signature: (I)Lorg/gnu/glib/Handle;
 */
JNIEXPORT jobject JNICALL Java_org_gnu_glib_Value_g_1value_1init (JNIEnv *env, jclass cls, 
    jint type) 
{
    GValue *value_g = (GValue *) g_malloc(sizeof(GValue));
	value_g->g_type = 0;
    value_g = g_value_init (value_g,(GType)type);
    return getHandleFromPointer(env, value_g);
}

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_copy
 * Signature: (Lorg/gnu/glib/Handle;)Lorg/gnu/glib/Handle;
 */
JNIEXPORT jobject JNICALL Java_org_gnu_glib_Value_g_1value_1copy (JNIEnv *env, jclass cls, jobject srcValue) 
{
    GValue *srcValue_g = (GValue *)getPointerFromHandle(env, srcValue);
    GValue *destValue = NULL;
    g_value_copy (srcValue_g, destValue);
    return getHandleFromPointer(env, destValue);
}

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_reset
 * Signature: (Lorg/gnu/glib/Handle;)Lorg/gnu/glib/Handle;
 */
JNIEXPORT jobject JNICALL Java_org_gnu_glib_Value_g_1value_1reset (JNIEnv *env, jclass cls, jobject value) 
{
    GValue *value_g = (GValue *)getPointerFromHandle(env, value);
    return getHandleFromPointer(env, g_value_reset (value_g));
}

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_unset
 * Signature: (Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_glib_Value_g_1value_1unset (JNIEnv *env, jclass cls, jobject value) 
{
    GValue *value_g = (GValue *)getPointerFromHandle(env, value);
    g_value_unset (value_g);
}

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_set_char
 * Signature: (Lorg/gnu/glib/Handle;B)V
 */
JNIEXPORT void JNICALL Java_org_gnu_glib_Value_g_1value_1set_1char (JNIEnv *env, jclass cls, 
    jobject value, jbyte vChar) 
{
    GValue *value_g = (GValue *)getPointerFromHandle(env, value);
    gchar vChar_g = (gchar) vChar;
    g_value_set_char (value_g, vChar_g);
}

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_get_char
 * Signature: (Lorg/gnu/glib/Handle;)B
 */
JNIEXPORT jbyte JNICALL Java_org_gnu_glib_Value_g_1value_1get_1char (JNIEnv *env, jclass cls, 
    jobject value) 
{
    GValue *value_g = (GValue *)getPointerFromHandle(env, value);
    jbyte result_j = (jbyte) (g_value_get_char (value_g));
    return result_j;
}

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_set_boolean
 * Signature: (Lorg/gnu/glib/Handle;Z)V
 */
JNIEXPORT void JNICALL Java_org_gnu_glib_Value_g_1value_1set_1boolean (JNIEnv *env, jclass cls, 
    jobject value, jboolean vBoolean) 
{
    GValue *value_g = (GValue *)getPointerFromHandle(env, value);
    gboolean vBoolean_g = (gboolean) vBoolean;
    g_value_set_boolean (value_g, vBoolean_g);
}

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_get_boolean
 * Signature: (Lorg/gnu/glib/Handle;)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_glib_Value_g_1value_1get_1boolean (JNIEnv *env, jclass 
    cls, jobject value) 
{
    GValue *value_g = (GValue *)getPointerFromHandle(env, value);
    jboolean result_j = (jboolean) (g_value_get_boolean (value_g));
    return result_j;
}

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_set_int
 * Signature: (Lorg/gnu/glib/Handle;I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_glib_Value_g_1value_1set_1int (JNIEnv *env, jclass cls, 
    jobject value, jint vInt) 
{
    GValue *value_g = (GValue *)getPointerFromHandle(env, value);
    gint32 vInt_g = (gint32) vInt;
    g_value_set_int (value_g, vInt_g);
}

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_get_int
 * Signature: (Lorg/gnu/glib/Handle;)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_glib_Value_g_1value_1get_1int (JNIEnv *env, jclass cls, 
    jobject value) 
{
    GValue *value_g = (GValue *)getPointerFromHandle(env, value);
    jint result_j = (jint) (g_value_get_int (value_g));
    return result_j;
}

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_set_long
 * Signature: (Lorg/gnu/glib/handleJ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_glib_Value_g_1value_1set_1long (JNIEnv *env, jclass cls, 
    jobject value, jlong vLong) 
{
    GValue *value_g = (GValue *)getPointerFromHandle(env, value);
    glong vLong_g = (glong) vLong;
    g_value_set_long (value_g, vLong_g);
}

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_get_long
 * Signature: (Lorg/gnu/glib/Handle;)J
 */
JNIEXPORT jlong JNICALL Java_org_gnu_glib_Value_g_1value_1get_1long (JNIEnv *env, jclass cls, 
    jobject value) 
{
    GValue *value_g = (GValue *)getPointerFromHandle(env, value);
    jlong result_j = (jlong) (g_value_get_long (value_g));
    return result_j;
}

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_set_float
 * Signature: (Lorg/gnu/glib/Handle;D)V
 */
JNIEXPORT void JNICALL Java_org_gnu_glib_Value_g_1value_1set_1float (JNIEnv *env, jclass cls, 
    jobject value, jdouble vFloat) 
{
    GValue *value_g = (GValue *)getPointerFromHandle(env, value);
    gdouble vFloat_g = (gdouble) vFloat;
    g_value_set_float (value_g, vFloat_g);
}

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_get_float
 * Signature: (Lorg/gnu/glib/Handle;)D
 */
JNIEXPORT jdouble JNICALL Java_org_gnu_glib_Value_g_1value_1get_1float (JNIEnv *env, jclass 
    cls, jobject value) 
{
    GValue *value_g = (GValue *)getPointerFromHandle(env, value);
    jdouble result_j = (jdouble) (g_value_get_float (value_g));
    return result_j;
}

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_set_double
 * Signature: (Lorg/gnu/glib/Handle;D)V
 */
JNIEXPORT void JNICALL Java_org_gnu_glib_Value_g_1value_1set_1double (JNIEnv *env, jclass cls, 
    jobject value, jdouble vDouble) 
{
    GValue *value_g = (GValue *)getPointerFromHandle(env, value);
    gdouble vDouble_g = (gdouble) vDouble;
    g_value_set_double (value_g, vDouble_g);
}

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_get_double
 * Signature: (Lorg/gnu/glib/Handle;)D
 */
JNIEXPORT jdouble JNICALL Java_org_gnu_glib_Value_g_1value_1get_1double (JNIEnv *env, jclass 
    cls, jobject value) 
{
    GValue *value_g = (GValue *)getPointerFromHandle(env, value);
    jdouble result_j = (jdouble) (g_value_get_double (value_g));
    return result_j;
}

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_set_string
 * Signature: (Lorg/gnu/glib/Handle;Ljava.lang.String)V
 */
JNIEXPORT void JNICALL Java_org_gnu_glib_Value_g_1value_1set_1string (JNIEnv *env, jclass cls, 
    jobject value, jstring vString) 
{
    GValue *value_g = (GValue *)getPointerFromHandle(env, value);
    const gchar* vString_g = (*env)->GetStringUTFChars(env, vString, 0);
    g_value_set_string (value_g, vString_g);
    (*env)->ReleaseStringUTFChars(env, vString, vString_g);
}

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_get_string
 * Signature: (Lorg/gnu/glib/Handle;)Ljava.lang.String
 */
JNIEXPORT jstring JNICALL Java_org_gnu_glib_Value_g_1value_1get_1string (JNIEnv *env, jclass 
    cls, jobject value) 
{
    GValue *value_g = (GValue *)getPointerFromHandle(env, value);
    const gchar *result_g = g_value_get_string ((const GValue*)value_g);
    jstring result = (*env)->NewStringUTF(env, result_g);
    return result;
}

#ifdef __cplusplus
}

#endif
