/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <gdk/gdk.h>
#include "jg_jnu.h"

#ifdef __cplusplus
extern "C" 
{
#endif

JNIEXPORT jobject JNICALL Java_org_gnu_gdk_Color_allocHandle (JNIEnv *env, jclass cls) 
{
    GdkColor* handle = g_malloc(sizeof(GdkColor));
    return getHandleFromPointer(env, handle);
}

JNIEXPORT void JNICALL Java_org_gnu_gdk_Color_freeHandle(JNIEnv *env, jclass cls, jobject handle) 
{
    g_free(getPointerFromHandle(env, handle));
}
    

/*
 * Class:     org.gnu.gdk.Color
 * Method:    getPixel
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Color_getPixel (JNIEnv *env, jclass cls, jobject obj) 
{
    GdkColor *obj_g = (GdkColor *)getPointerFromHandle(env, obj);
    return (jint)obj_g->pixel;
}

/*
 * Class:     org.gnu.gdk.Color
 * Method:    getRed
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Color_getRed (JNIEnv *env, jclass cls, jobject obj) 
{
    GdkColor *obj_g = (GdkColor *)getPointerFromHandle(env, obj);
    return (jint)obj_g->red;
}

/*
 * Class:     org.gnu.gdk.Color
 * Method:    setRed
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Color_setRed (JNIEnv *env, jclass cls, jobject obj, jint red) 
{
    GdkColor *obj_g = (GdkColor *)getPointerFromHandle(env, obj);
    obj_g->red = (guint16)red;
}

/*
 * Class:     org.gnu.gdk.Color
 * Method:    getGreen
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Color_getGreen (JNIEnv *env, jclass cls, jobject obj) 
{
    GdkColor *obj_g = (GdkColor *)getPointerFromHandle(env, obj);
    return (jint)obj_g->green;
}

/*
 * Class:     org.gnu.gdk.Color
 * Method:    setGreen
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Color_setGreen (JNIEnv *env, jclass cls, jobject obj, jint green) 
{
    GdkColor *obj_g = (GdkColor *)getPointerFromHandle(env, obj);
    obj_g->green = (guint16)green;
}

/*
 * Class:     org.gnu.gdk.Color
 * Method:    getBlue
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Color_getBlue (JNIEnv *env, jclass cls, jobject obj) 
{
    GdkColor *obj_g = (GdkColor *)getPointerFromHandle(env, obj);
    return (jint)obj_g->blue;
}

/*
 * Class:     org.gnu.gdk.Color
 * Method:    setBlue
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Color_setBlue (JNIEnv *env, jclass cls, jobject obj, jint blue) 
{
    GdkColor *obj_g = (GdkColor *)getPointerFromHandle(env, obj);
    obj_g->blue = (guint16)blue;
}

/*
 * Class:     org.gnu.gdk.Color
 * Method:    gdk_color_get_type
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Color_gdk_1color_1get_1type (JNIEnv *env, jclass cls) 
{
    return (jint)gdk_color_get_type ();
}

/*
 * Class:     org.gnu.gdk.Color
 * Method:    gdk_color_copy
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_Color_gdk_1color_1copy (JNIEnv *env, jclass cls, jobject color) 
{
    GdkColor *color_g = (GdkColor *)getPointerFromHandle(env, color);
    return getHandleFromPointer(env, gdk_color_copy (color_g));
}

/*
 * Class:     org.gnu.gdk.Color
 * Method:    gdk_color_free
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Color_gdk_1color_1free (JNIEnv *env, jclass cls, jobject color) 
{
    GdkColor *color_g = (GdkColor *)getPointerFromHandle(env, color);
    gdk_color_free (color_g);
}

/*
 * Class:     org.gnu.gdk.Color
 * Method:    gdk_color_parse
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Color_gdk_1color_1parse (JNIEnv *env, jclass cls, 
    jstring spec, jobject color) 
{
    const gchar* spec_g = (*env)->GetStringUTFChars(env, spec, 0);
    GdkColor *color_g = (GdkColor *)getPointerFromHandle(env, color);
    jint result_j = (jint) (gdk_color_parse (spec_g, color_g));
    (*env)->ReleaseStringUTFChars(env, spec, spec_g);
    return result_j;
}

/*
 * Class:     org.gnu.gdk.Color
 * Method:    gdk_color_hash
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Color_gdk_1color_1hash (JNIEnv *env, jclass cls, jobject color) 
{
    GdkColor *color_g = (GdkColor *)getPointerFromHandle(env, color);
    jint result_j = (jint) (gdk_color_hash (color_g));
    return result_j;
}

/*
 * Class:     org.gnu.gdk.Color
 * Method:    gdk_color_equal
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_Color_gdk_1color_1equal (JNIEnv *env, jclass cls, 
    jobject colora, jobject colorb) 
{
    GdkColor *colora_g = (GdkColor *)getPointerFromHandle(env, colora);
    GdkColor *colorb_g = (GdkColor *)getPointerFromHandle(env, colorb);
    return (jboolean) (gdk_color_equal (colora_g, colorb_g));
}


#ifdef __cplusplus
}

#endif
