/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.Type;

/**
 * HRuler displays a horizontally-oriented scale that optionally can
 * contain the marks and a current-position pointer. You can set the
 * pointer position from inside the program - it follows the mouse.
 */
public class HRuler extends Ruler 
{
	public HRuler() {
		super(gtk_hruler_new());
	}
	
	/**
	 * Construct a HRuler from a handle to a native resource.
	 */
	public HRuler(int handle) {
	    super(handle);
	}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_hruler_get_type());
	}

    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int gtk_hruler_get_type ();
    native static final protected int gtk_hruler_new ();
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

