/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-01 07:00:33 EDT
 */

#include <jni.h>
#include <sys/types.h>
#include <gdk/gdk.h>
#ifdef __cplusplus
extern "C" 
{
#endif
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    /*
     * Class:     org.gnu.gdk.Pixmap
     * Method:    gdk_pixmap_get_type
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Pixmap_gdk_1pixmap_1get_1type (JNIEnv *env, jclass cls) 
    {
        {
            return (jint)gdk_pixmap_get_type ();
        }
    }

    /*
     * Class:     org.gnu.gdk.Pixmap
     * Method:    gdk_pixmap_new
     * Signature: (IIII)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Pixmap_gdk_1pixmap_1new (JNIEnv *env, jclass cls, jint 
        window, jint width, jint height, jint depth) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        gint32 width_g = (gint32) width;
        gint32 height_g = (gint32) height;
        gint32 depth_g = (gint32) depth;
        {
            return (jint)gdk_pixmap_new (window_g, width_g, height_g, depth_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Pixmap
     * Method:    gdk_pixmap_create_from_data
     * Signature: (I[BIIIII)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Pixmap_gdk_1pixmap_1create_1from_1data (JNIEnv *env, 
        jclass cls, jint window, jbyteArray data, jint width, jint height, jint depth, jint fg, 
        jint bg) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        jint data_len = (*env)->GetArrayLength(env, data);
        gchar* data_g = (gchar*)g_malloc(data_len + 1);
        gint32 width_g = (gint32) width;
        gint32 height_g = (gint32) height;
        gint32 depth_g = (gint32) depth;
        GdkColor *fg_g = (GdkColor *)fg;
        GdkColor *bg_g = (GdkColor *)bg;
        (*env)->GetByteArrayRegion(env, data, 0, data_len, (jbyte*)data_g);
        data_g[data_len] = 0;
        {
            return (jint)gdk_pixmap_create_from_data (window_g, data_g, width_g, height_g, depth_g, 
                fg_g, bg_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Pixmap
     * Method:    gdk_pixmap_create_from_xpm
     * Signature: (IIIjava.lang.String;)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Pixmap_gdk_1pixmap_1create_1from_1xpm (JNIEnv *env, 
        jclass cls, jint window, jint mask, jint transparentColor, jstring filename) 
    {
        gchar* filename_g = (gchar*)(*env)->GetStringUTFChars(env, filename, 0);
        jint result = (jint)gdk_pixmap_create_from_xpm ((GdkWindow*)window, 
							(GdkBitmap**)mask, 
							(GdkColor*)transparentColor, 
							filename_g);
	(*env)->ReleaseStringUTFChars(env, filename, filename_g);
	return result;
    }

    /*
     * Class:     org.gnu.gdk.Pixmap
     * Method:    gdk_pixmap_colormap_create_from_xpm
     * Signature: (IIIIjava.lang.String;)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Pixmap_gdk_1pixmap_1colormap_1create_1from_1xpm (JNIEnv 
        *env, jclass cls, jint window, jint colormap, jint mask, jint transparentColor, jstring filename) 
    {
        gchar* filename_g = (gchar*)(*env)->GetStringUTFChars(env, filename, 0);
        jint result = (jint)gdk_pixmap_colormap_create_from_xpm ((GdkWindow*)window, 
								 (GdkColormap*)colormap, 
								 (GdkBitmap**)mask, 
								 (GdkColor*)transparentColor, 
								 filename_g);
	(*env)->ReleaseStringUTFChars(env, filename, filename_g);
	return result;
    }

    /*
     * Class:     org.gnu.gdk.Pixmap
     * Method:    gdk_pixmap_create_from_xpm_d
     * Signature: (III[B)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Pixmap_gdk_1pixmap_1create_1from_1xpm_1d (JNIEnv *env, 
        jclass cls, jint window, jint mask, jint transparentColor, jbyteArray data) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        GdkBitmap **mask_g = (GdkBitmap **)mask;
        GdkColor *transparentColor_g = (GdkColor *)transparentColor;
        jint data_len = (*env)->GetArrayLength(env, data);
        gchar* data_g = (gchar*)g_malloc(data_len + 1);
        (*env)->GetByteArrayRegion(env, data, 0, data_len, (jbyte*)data_g);
        data_g[data_len] = 0;
	return (jint)gdk_pixmap_create_from_xpm_d (window_g, mask_g, transparentColor_g, data_g);
    }

    /*
     * Class:     org.gnu.gdk.Pixmap
     * Method:    gdk_pixmap_colormap_create_from_xpm_d
     * Signature: (IIII[B)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Pixmap_gdk_1pixmap_1colormap_1create_1from_1xpm_1d (
        JNIEnv *env, jclass cls, jint window, jint colormap, jint mask, jint transparentColor, 
        jbyteArray data) 
    {
        GdkWindow *window_g = (GdkWindow *)window;
        GdkColormap *colormap_g = (GdkColormap *)colormap;
        GdkBitmap **mask_g = (GdkBitmap **)mask;
        GdkColor *transparentColor_g = (GdkColor *)transparentColor;
        jint data_len = (*env)->GetArrayLength(env, data);
        gchar* data_g = (gchar*)g_malloc(data_len + 1);
        (*env)->GetByteArrayRegion(env, data, 0, data_len, (jbyte*)data_g);
        data_g[data_len] = 0;
	return (jint)gdk_pixmap_colormap_create_from_xpm_d (window_g, colormap_g, mask_g, 
							    transparentColor_g, data_g);
    }

    /*
     * Class:     org.gnu.gdk.Pixmap
     * Method:    gdk_pixmap_foreign_new
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Pixmap_gdk_1pixmap_1foreign_1new (JNIEnv *env, jclass 
        cls, jint anid) 
    {
        GdkNativeWindow anid_g = (GdkNativeWindow)&anid;
        {
            return (jint)gdk_pixmap_foreign_new (anid_g);
        }
    }

    /****************************************
     * END OF GENERATED CODE
     ****************************************/
#ifdef __cplusplus
}

#endif
