/* utility.h
 *
 * Copyright (C) 2003 - 2005 Vivien Malerba <malerba@gnome-db.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include "gnome-db-data-set.h"
#include "gnome-db-data-entry.h"


/*
 *
 * Data Entry utilities
 *
 */
GtkWidget*              utility_entry_build_actions_menu      (GObject *obj_data, guint attrs, GCallback function);
GdkColor **             utility_entry_build_info_colors_array (void);

/*
 *
 * Query execution function with user feedback. To be removed?
 *
 */
gboolean                utility_query_execute_modif (GnomeDbQuery *query, GnomeDbDataSet *context,
                                                     gboolean ask_confirm_insert,
                                                     gboolean ask_confirm_update,
                                                     gboolean ask_confirm_delete,
                                                     GtkWidget *parent_window,
                                                     gboolean *user_cancelled,
                                                     gboolean *query_error);

/*
 *
 * Utilities dealing with GnomeDbDataSetNodes where node->params in not NULL
 *
 */
typedef struct {
	GnomeDbDataSet          *data_set;
	GnomeDbDataSetNode      *node;

	/* data among which the values must be chosen */
        GnomeDbDataModel        *data_model;
	
        /* displayed columns in 'data_model' */
        gint                     shown_n_cols;
        gint                    *shown_cols_index;

        /* columns used as a reference (corresponding to PK values) in 'data_model' */
        gint                     ref_n_cols;
        gint                    *ref_cols_index;
} DataSetNodeInfo;
#define DATA_SET_NODE_INFO(x) ((DataSetNodeInfo*)(x))

DataSetNodeInfo *utility_data_set_node_info_create             (GnomeDbDataSet *data_set, GnomeDbDataSetNode *node);
void             utility_data_set_node_info_destroy            (DataSetNodeInfo *info);
GList           *utility_data_set_node_info_compute_values     (DataSetNodeInfo *info, GnomeDbDataProxy *proxy, 
								GtkTreeIter *iter);
GList           *utility_data_set_node_info_compute_values_ext (DataSetNodeInfo *info, GnomeDbDataProxy *proxy, 
								GtkTreeIter *iter);
guint            utility_data_set_node_info_compute_attributes (DataSetNodeInfo *info, GnomeDbDataProxy *proxy, 
								GtkTreeIter *iter, gboolean *to_be_deleted);
