/* gnome-db-sql-tree.c
 *
 * Copyright (C) 2004 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <stdio.h>
#include <stdlib.h>

#include "gnome-db-sql-parser.h"
#include "gnome-db-sql-tree.h"

GnomeDbSqlStatement *
gnome_db_sql_statement_build (GnomeDbSqlStatementType type, GList *expr_list)
{
	GnomeDbSqlStatement *retval;
	GList *list, *pspecs = NULL;
	GnomeDbSqlExpr *first = NULL;

	switch (type) {
	case GNOME_DB_SQL_SELECT:
		first = gnome_db_sql_expr_build (g_strdup ("SELECT"), NULL);
		break;
	case GNOME_DB_SQL_INSERT:
		first = gnome_db_sql_expr_build (g_strdup ("INSERT"), NULL);
		break;
	case GNOME_DB_SQL_DELETE:
		first = gnome_db_sql_expr_build (g_strdup ("DELETE"), NULL);
		break;
	case GNOME_DB_SQL_UPDATE:
		first = gnome_db_sql_expr_build (g_strdup ("UPDATE"), NULL);
		break;
	default:
		g_assert_not_reached ();
		break;
	}

	/* build returned structure */
	retval = g_new0 (GnomeDbSqlStatement, 1);
	retval->type = type;
	retval->full_query = NULL;
	if (first)
		retval->expr_list = g_list_prepend (expr_list, first);
	else
		retval->expr_list = expr_list;

	/* make a list of the para specs */
	list = expr_list;
	while (list) {
		if (((GnomeDbSqlExpr *)(list->data))->pspec_list)
			pspecs = g_list_append (pspecs, ((GnomeDbSqlExpr *)(list->data))->pspec_list);
		list = g_list_next (list);
	}
	retval->params_specs = pspecs;

	return retval;
}

GnomeDbSqlExpr *
gnome_db_sql_expr_build (gchar *str, GList *pspec_list)
{
	GnomeDbSqlExpr *retval;

	retval = g_new0 (GnomeDbSqlExpr, 1);
	retval->pspec_list = pspec_list;
	retval->sql_text = str;

	return retval;
}

GnomeDbParamSpec *
gnome_db_sql_param_spec_build (GnomeDbParamSpecType type, char *content)
{
	GnomeDbParamSpec *retval;

	retval = g_new0 (GnomeDbParamSpec, 1);
	retval->type = type;
	retval->content = content;

	return retval;
}

