/* GNOME-DB Components
 * Copyright (C) 2000-2002 The GNOME Foundation.
 *
 * AUTHORS:
 *      Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtkdialog.h>
#include <gtk/gtkstock.h>
#include <libgnomedb/libgnomedb.h>
#include <libgnomeui/gnome-client.h>
#include <libgnomedb/gnome-db-i18n.h>
#include <libgnomeui/gnome-window-icon.h>
#include "database-capplet.h"

static void
dialog_response_cb (GtkDialog *dialog, gint response_id, gpointer user_data)
{
	if (response_id == GTK_RESPONSE_CLOSE)
		gnome_db_main_quit ();
}

static void
create_dialog (gpointer user_data)
{
	GtkWidget *dialog;
	GtkWidget *capplet;

	/* create the dialog */
	dialog = gtk_dialog_new_with_buttons (_("Database properties"),
					      NULL, 0,
					      GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE,
					      NULL);
	gtk_widget_set_usize (dialog, 450, 500);
        gtk_container_set_border_width (GTK_CONTAINER (dialog), 6);
        gtk_dialog_set_has_separator (GTK_DIALOG (dialog), FALSE);
	gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_CENTER);
	gnome_window_icon_set_from_file (GTK_WINDOW (dialog),
					 LIBGNOMEDB_ICONSDIR "/gnome-db.png");
	g_signal_connect (G_OBJECT (dialog), "response",
			  G_CALLBACK (dialog_response_cb), NULL);

	capplet = database_capplet_new ();
        gtk_container_set_border_width (GTK_CONTAINER (capplet), 6);
        gtk_box_set_spacing (GTK_BOX (GTK_DIALOG (dialog)->vbox), 6);
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), capplet, TRUE, TRUE, 0);

	/* run the dialog */
	gtk_widget_show_all (dialog);
}

int
main (int argc, char *argv[])
{
	GnomeClient *session_client;

	bindtextdomain (GETTEXT_PACKAGE, LIBGNOMEDB_LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);

	gnome_db_init ("gnome-database-properties", VERSION, argc, argv);

	/* session management */
	session_client = gnome_master_client ();
	gnome_client_set_restart_style (session_client, GNOME_RESTART_NEVER);

	/* application loop */
	gnome_db_main_run ((GdaInitFunc) create_dialog, NULL);

	return 0;
}
