// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDA_UIMM_DATASTORE_H
#define _LIBGDA_UIMM_DATASTORE_H


#include <glibmm.h>

/* libgda-uimm - a C++ wrapper for libgda-ui
 *
 * Copyright (c) 2010 libgda-uimm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <gtkmm/treemodel.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdauiDataStore GdauiDataStore;
typedef struct _GdauiDataStoreClass GdauiDataStoreClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace GdaUI
{ class DataStore_Class; } // namespace GdaUI

} // namespace Gnome
namespace Gnome
{

// Gnome::Gda class forward declarations.
namespace Gda
{

class DataModel;
class DataProxy;

}

namespace GdaUI
{

/** DataStore - Bridge between a Gnome::Gda::DataModel  and a Gtk::TreeModel.
 * The DataStore  object implements the Gtk::TreeModel interface on top of a
 * Gnome::Gda::DataModel  to be able to display its contents in a GtkTreeView.
 */

class DataStore :
  public Glib::Object,
  public Gtk::TreeModel
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef DataStore CppObjectType;
  typedef DataStore_Class CppClassType;
  typedef GdauiDataStore BaseObjectType;
  typedef GdauiDataStoreClass BaseClassType;

private:  friend class DataStore_Class;
  static CppClassType datastore_class_;

private:
  // noncopyable
  DataStore(const DataStore&);
  DataStore& operator=(const DataStore&);

protected:
  explicit DataStore(const Glib::ConstructParams& construct_params);
  explicit DataStore(GdauiDataStore* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~DataStore();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdauiDataStore*       gobj()       { return reinterpret_cast<GdauiDataStore*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdauiDataStore* gobj() const { return reinterpret_cast<GdauiDataStore*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdauiDataStore* gobj_copy();

private:

  
public:
  
  /** Creates a Gtk::TreeModel interface with a Gda::DataModel
   * @param model A Gda::DataModel object.
   * @return The new object
   * 
   * @newin{4,2}.
   */

  explicit DataStore(const Glib::RefPtr<Gnome::Gda::DataModel>& model);

public:
  
  /** 
   * @return The internal Gda::DataProxy being used by @a store
   * 
   * @newin{4,2}.
   */
  Glib::RefPtr<Gnome::Gda::DataProxy> get_proxy();
  
  /** 
   * @return The internal Gda::DataProxy being used by @a store
   * 
   * @newin{4,2}.
   */
  Glib::RefPtr<const Gnome::Gda::DataProxy> get_proxy() const;
  
  /** Get the number of the row represented by @a iter
   * @param iter A valid Gtk::TreeIter.
   * @return The row number, or -1 if an error occurred
   * 
   * @newin{4,2}.
   */
  int get_row_from_iter(const Gtk::TreeModel::const_iterator& iter) const;

//TODO:
//#m4 __CONVERSION(`const Glib::SListHandle<Glib::ValueBase>&', `GSList*', `$3.data()')
//#m4 __CONVERSION(`const Glib::ArrayHandle<int>&', `gint*', `const_cast<int*>($3.data())')
  //_WRAP_METHOD(bool get_iter_from_values(Gtk::TreeModel::iterator& iter, const Glib::SListHandle<Glib::ValueBase>& values, const Glib::ArrayHandle<int>& cols_index), gdaui_data_store_get_iter_from_values)

  
  /** Stores a value in the @a store data model.
   * @param iter The considered row.
   * @param value The value to store (gets copied).
   * @return <tt>true</tt> on success
   * 
   * @newin{4,2}.
   */
  bool set_value(const Gtk::TreeModel::iterator& iter, int col, const Glib::ValueBase& value);

  /** Stores a value in the store data model.
   * @param iter The considered row.
   * @param col The column.
   * @param value The value to store.
   * @return true on success, false otherwise.
   */
  template <class DataType>
  bool set_value(const Gtk::TreeModel::iterator& iter, int col, const DataType& value);

  
  /** Marks the row pointed by @a iter to be deleted
   * 
   * @newin{4,2}
   * @param iter The considered row.
   */
  void remove(const Gtk::TreeModel::iterator& iter);
  
  /** Remove the "to be deleted" mark the row pointed by @a iter, if it existed.
   * 
   * @newin{4,2}
   * @param iter The considered row.
   */
  void restore(const Gtk::TreeModel::iterator& iter);
  
  /** Appends a new row.
   * @param iter An unset Gtk::TreeIter to set to the appended row.
   * @return <tt>true</tt> if no error occurred
   * 
   * @newin{4,2}.
   */
  bool append(const Gtk::TreeModel::iterator& iter);

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gnome::Gda::DataModel> > property_model() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_prepend_null_entry() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_prepend_null_entry() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gnome::Gda::DataProxy> > property_proxy() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

/***************************** DataStore *****************************/

#ifndef DOXYGEN_SHOULD_SKIP_THIS

template <class DataType>
bool DataStore::set_value(const Gtk::TreeModel::iterator& iter, int col,
  const DataType& value)
{
  typedef Glib::Value<DataType> ValueType;

  ValueType temp;
  temp.init(ValueType::value_type());
  temp.set(value);
  return this->set_value(iter, col, temp);
}

#endif /* DOXYGEN_SHOULD_SKIP_THIS */


} // namespace GdaUI

} // namespace Gnome


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gnome::GdaUI::DataStore
   */
  Glib::RefPtr<Gnome::GdaUI::DataStore> wrap(GdauiDataStore* object, bool take_copy = false);
}


#endif /* _LIBGDA_UIMM_DATASTORE_H */

