/*-----------------------------------------------------------------
  Everything here is preliminary. 

  03/15/2000
------------------------------------------------------------------*/

/*
  Currently supported detection methods:
*/

#define PCONF_DETECT_PPORT 1
#define PCONF_DETECT_NETWORK 2
#define PCONF_DETECT_HPMULTI 3
#define PCONF_DETECT_USB 4
#define PCONF_DETECT_IRDA 5

/* Printer detection methods */

typedef struct {
  int type;
  char description[50];
} pconf_detmethod_t;

/*------------------------------------------------------------------
  pconf_xref_t - a list of printer information cross-referenced by
  a unique printer ID.
------------------------------------------------------------------*/

typedef struct pconf_xref_t {
  char *id;
  char *ppd;
  char *shortdesc;
  char *longdesc;
  struct pconf_xref_t *next;
} pconf_xref_t;

/*------------------------------------------------------------------
  Function Prototypes:
------------------------------------------------------------------*/

/*------------------------------------------------------------------
  List autodetection methods.

  Return a list of printer detection methods supported. This is
  static now, should be dynamic (based on what methods are 
  available on the machine) in the future.
------------------------------------------------------------------*/
pconf_detmethod_t *pconf_get_detection_methods(int *count);

/*------------------------------------------------------------------
  Return array of strings containing printer specific information. 

  Return an array of strings with semi-colon-separated printer 
  specific information. 

  For a parallel port printer, this would be: "port=p;model=m".

  For a network printer it is: "printer=hostaddr;vendor=v;model=m".

------------------------------------------------------------------*/
char **pconf_detect_printer(int dettype, char *detinfo, int *retval);

/*------------------------------------------------------------------
  Read a printer/PPD cross-reference file.

  Read a printer/PPD cross-reference file. This file is a 
  tab-delimited text file with the format:

  # comment
  printer-id\tppd-file-name

------------------------------------------------------------------*/
pconf_xref_t *pconf_read_xref_file(char *filename);

/*------------------------------------------------------------------
  Return a printer information struct.

  Given a unique printer ID, return a struct for setup and 
  configuration.
------------------------------------------------------------------*/
pconf_xref_t *pconf_find_xref_by_id(char *target_id);
